/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.multi.tenant;

import java.security.Principal;
import java.util.ArrayList;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.SystemPrincipal;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.local.ClientLoginModule;
import org.nuxeo.ecm.multi.tenant.cache.SimpleCache;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

public class MultiTenantHelper {
    protected static final SimpleCache<String> pathCache = new SimpleCache(100);

    private MultiTenantHelper() {
    }

    public static String computeTenantAdministratorsGroup(String tenantId) {
        return "tenant-" + tenantId + "_tenantAdministrators";
    }

    public static String computeTenantMembersGroup(String tenantId) {
        return "tenant-" + tenantId + "_tenantMembers";
    }

    public static String getCurrentTenantId(Principal principal) throws ClientException {
        if (principal instanceof SystemPrincipal) {
            UserManager userManager = (UserManager)Framework.getLocalService(UserManager.class);
            String originatingUser = ((SystemPrincipal)principal).getOriginatingUser();
            if (originatingUser != null) {
                NuxeoPrincipal nuxeoPrincipal = userManager.getPrincipal(originatingUser);
                return nuxeoPrincipal.getTenantId();
            }
            return null;
        }
        return ClientLoginModule.getCurrentPrincipal().getTenantId();
    }

    public static String getTenantId(String username) throws ClientException {
        UserManager userManager = (UserManager)Framework.getLocalService(UserManager.class);
        NuxeoPrincipal nuxeoPrincipal = userManager.getPrincipal(username);
        return nuxeoPrincipal.getTenantId();
    }

    public static String getTenantDocumentPath(CoreSession session, final String tenantId) throws ClientException {
        String path = pathCache.get(tenantId);
        if (path == null) {
            final ArrayList paths = new ArrayList();
            new UnrestrictedSessionRunner(session){

                public void run() throws ClientException {
                    String query = String.format("SELECT * FROM Document WHERE tenantconfig:tenantId = '%s'", tenantId);
                    DocumentModelList docs = this.session.query(query);
                    if (!docs.isEmpty()) {
                        paths.add(((DocumentModel)docs.get(0)).getPathAsString());
                    }
                }
            }.runUnrestricted();
            String string = path = paths.isEmpty() ? null : (String)paths.get(0);
            if (path != null) {
                pathCache.put(tenantId, path);
            }
        }
        return path;
    }
}

