/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.multi.tenant;

import java.io.Serializable;
import java.util.List;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.multi.tenant.MultiTenantService;
import org.nuxeo.ecm.webapp.directory.DirectoryUIActionsBean;
import org.nuxeo.runtime.api.Framework;

@Name(value="multiTenantActions")
@Scope(value=ScopeType.STATELESS)
@Install(precedence=10)
public class MultiTenantActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    @In(create=true)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected DirectoryUIActionsBean directoryUIActions;

    public List<DocumentModel> getTenants() throws ClientException {
        MultiTenantService multiTenantService = (MultiTenantService)Framework.getLocalService(MultiTenantService.class);
        return multiTenantService.getTenants();
    }

    public boolean isTenantIsolationEnabled() throws ClientException {
        MultiTenantService multiTenantService = (MultiTenantService)Framework.getLocalService(MultiTenantService.class);
        return multiTenantService.isTenantIsolationEnabled(this.documentManager);
    }

    public void enableTenantIsolation() throws ClientException {
        MultiTenantService multiTenantService = (MultiTenantService)Framework.getLocalService(MultiTenantService.class);
        multiTenantService.enableTenantIsolation(this.documentManager);
    }

    public void disableTenantIsolation() throws ClientException {
        MultiTenantService multiTenantService = (MultiTenantService)Framework.getLocalService(MultiTenantService.class);
        multiTenantService.disableTenantIsolation(this.documentManager);
    }

    public boolean isReadOnlyDirectory(String directoryName) throws ClientException {
        MultiTenantService multiTenantService = (MultiTenantService)Framework.getLocalService(MultiTenantService.class);
        if (multiTenantService.isTenantIsolationEnabled(this.documentManager) && multiTenantService.isTenantAdministrator(this.documentManager.getPrincipal())) {
            DirectoryService directoryService = (DirectoryService)Framework.getLocalService(DirectoryService.class);
            return !directoryService.getDirectory(directoryName).isMultiTenant();
        }
        return this.directoryUIActions.isReadOnly(directoryName);
    }
}

