/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.multi.tenant;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.multi.tenant.MultiTenantHelper;
import org.nuxeo.ecm.platform.computedgroups.AbstractGroupComputer;
import org.nuxeo.ecm.platform.usermanager.NuxeoPrincipalImpl;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class MultiTenantGroupComputer
extends AbstractGroupComputer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getGroupsForUser(final NuxeoPrincipalImpl nuxeoPrincipal) throws Exception {
        final ArrayList<String> groups = new ArrayList<String>();
        final String tenantId = (String)((Object)nuxeoPrincipal.getModel().getPropertyValue("user:tenantId"));
        if (!StringUtils.isBlank((String)tenantId)) {
            String defaultRepositoryName = ((RepositoryManager)Framework.getLocalService(RepositoryManager.class)).getDefaultRepository().getName();
            boolean transactionStarted = false;
            if (!TransactionHelper.isTransactionActive()) {
                TransactionHelper.startTransaction();
                transactionStarted = true;
            }
            try {
                new UnrestrictedSessionRunner(defaultRepositoryName){

                    public void run() throws ClientException {
                        String query = String.format("SELECT * FROM Document WHERE tenantconfig:tenantId = '%s'", tenantId);
                        DocumentModelList docs = this.session.query(query);
                        if (!docs.isEmpty()) {
                            DocumentModel tenant = (DocumentModel)docs.get(0);
                            List tenantAdministrators = (List)((Object)tenant.getPropertyValue("tenantconfig:administrators"));
                            if (tenantAdministrators.contains(nuxeoPrincipal.getName())) {
                                groups.add(MultiTenantHelper.computeTenantAdministratorsGroup(tenantId));
                                groups.add("powerusers");
                            }
                            groups.add(MultiTenantHelper.computeTenantMembersGroup(tenantId));
                        }
                    }
                }.runUnrestricted();
            }
            finally {
                if (transactionStarted) {
                    TransactionHelper.commitOrRollbackTransaction();
                }
            }
        }
        return groups;
    }

    public List<String> getAllGroupIds() throws Exception {
        return null;
    }

    public List<String> getGroupMembers(String s) throws Exception {
        return null;
    }

    public List<String> getParentsGroupNames(String s) throws Exception {
        return null;
    }

    public List<String> getSubGroupsNames(String s) throws Exception {
        return null;
    }
}

