/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.multi.tenant.dashboard;

import java.util.Map;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.multi.tenant.MultiTenantHelper;
import org.nuxeo.ecm.user.center.dashboard.DefaultDashboardSpaceCreator;

public class MultiTenantDefaultDashboardSpaceCreator
extends DefaultDashboardSpaceCreator {
    protected String tenantId;
    protected String tenantDashboardManagementPath;

    public MultiTenantDefaultDashboardSpaceCreator(CoreSession session, Map<String, String> parameters, String tenantId, String tenantDashboardManagementPath) {
        super(session, parameters);
        this.tenantId = tenantId;
        this.tenantDashboardManagementPath = tenantDashboardManagementPath;
    }

    public void run() throws ClientException {
        String defaultDashboardSpacePath = new Path(this.tenantDashboardManagementPath).append("defaultDashboardSpace").toString();
        PathRef defaultDashboardSpacePathRef = new PathRef(defaultDashboardSpacePath);
        DocumentModel defaultDashboardSpace = !this.session.exists((DocumentRef)defaultDashboardSpacePathRef) ? this.createDefaultDashboardSpace(this.tenantDashboardManagementPath) : this.session.getDocument((DocumentRef)defaultDashboardSpacePathRef);
        this.defaultDashboardSpaceRef = defaultDashboardSpace.getRef();
    }

    protected void addDefaultACP(DocumentModel defaultDashboardSpace) throws ClientException {
        ACP acp = defaultDashboardSpace.getACP();
        ACL acl = acp.getOrCreateACL();
        String tenantAdministratorsGroup = MultiTenantHelper.computeTenantAdministratorsGroup(this.tenantId);
        acl.add((Object)new ACE(tenantAdministratorsGroup, "Everything", true));
        acl.add((Object)new ACE("Everyone", "Everything", false));
        defaultDashboardSpace.setACP(acp, true);
    }
}

