/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.multi.tenant.userworkspace;

import java.security.Principal;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.multi.tenant.MultiTenantHelper;
import org.nuxeo.ecm.multi.tenant.MultiTenantService;
import org.nuxeo.ecm.platform.userworkspace.core.service.DefaultUserWorkspaceServiceImpl;
import org.nuxeo.runtime.api.Framework;

public class MultiTenantUserWorkspaceService
extends DefaultUserWorkspaceServiceImpl {
    private static final long serialVersionUID = 1L;

    protected String computePathUserWorkspaceRoot(CoreSession userCoreSession, DocumentModel currentDocument) throws ClientException {
        MultiTenantService multiTenantService = (MultiTenantService)Framework.getLocalService(MultiTenantService.class);
        if (!multiTenantService.isTenantIsolationEnabled(userCoreSession)) {
            return super.computePathUserWorkspaceRoot(userCoreSession, currentDocument);
        }
        String tenantId = MultiTenantHelper.getCurrentTenantId(userCoreSession.getPrincipal());
        if (StringUtils.isBlank((String)tenantId)) {
            return super.computePathUserWorkspaceRoot(userCoreSession, currentDocument);
        }
        return this.computePathUserWorkspaceRoot(userCoreSession, tenantId);
    }

    protected String computePathUserWorkspaceRoot(CoreSession session, String tenantId) throws ClientException {
        String tenantDocumentPath = MultiTenantHelper.getTenantDocumentPath(session, tenantId);
        Path path = new Path(tenantDocumentPath);
        path = path.append("UserWorkspaces");
        return path.toString();
    }

    protected String computePathForUserWorkspace(CoreSession userCoreSession, String userName, DocumentModel currentDocument) throws ClientException {
        MultiTenantService multiTenantService = (MultiTenantService)Framework.getLocalService(MultiTenantService.class);
        if (!multiTenantService.isTenantIsolationEnabled(userCoreSession)) {
            return super.computePathForUserWorkspace(userCoreSession, userName, currentDocument);
        }
        String tenantId = MultiTenantHelper.getTenantId(userName);
        if (StringUtils.isBlank((String)tenantId)) {
            return super.computePathForUserWorkspace(userCoreSession, userName, currentDocument);
        }
        return this.computePathForUserWorkspace(userCoreSession, tenantId, userName);
    }

    protected String computePathForUserWorkspace(CoreSession session, String tenantId, String userName) throws ClientException {
        String rootPath = this.computePathUserWorkspaceRoot(session, tenantId);
        Path path = new Path(rootPath);
        path = path.append(MultiTenantUserWorkspaceService.getUserWorkspaceNameForUser((String)userName));
        return path.toString();
    }

    protected DocumentModel getCurrentUserPersonalWorkspace(Principal principal, String username, CoreSession userCoreSession, DocumentModel context) throws ClientException {
        MultiTenantService multiTenantService = (MultiTenantService)Framework.getLocalService(MultiTenantService.class);
        if (!multiTenantService.isTenantIsolationEnabled(userCoreSession)) {
            return super.getCurrentUserPersonalWorkspace(principal, username, userCoreSession, context);
        }
        String usedUsername = principal == null ? username : principal.getName();
        String tenantId = MultiTenantHelper.getTenantId(usedUsername);
        if (StringUtils.isBlank((String)tenantId)) {
            return super.getCurrentUserPersonalWorkspace(principal, usedUsername, userCoreSession, context);
        }
        PathRef uwsDocRef = new PathRef(this.computePathForUserWorkspace(userCoreSession, tenantId, usedUsername));
        if (!userCoreSession.exists((DocumentRef)uwsDocRef)) {
            PathRef rootRef = new PathRef(this.computePathUserWorkspaceRoot(userCoreSession, tenantId));
            uwsDocRef = this.createUserWorkspace(rootRef, uwsDocRef, userCoreSession, principal, usedUsername);
        }
        if (userCoreSession.getClass().getSimpleName().equals("LocalSession")) {
            userCoreSession.save();
        }
        return userCoreSession.getDocument((DocumentRef)uwsDocRef);
    }

    @Deprecated
    protected boolean isSameUserName(CoreSession session, String userName) {
        return session.getPrincipal().getName().equals(userName);
    }
}

