/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.multi.tenant.userworkspace;

import org.apache.commons.lang.StringUtils;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.multi.tenant.MultiTenantHelper;
import org.nuxeo.ecm.multi.tenant.MultiTenantService;
import org.nuxeo.ecm.platform.userworkspace.core.service.DefaultUserWorkspaceServiceImpl;
import org.nuxeo.runtime.api.Framework;

public class MultiTenantUserWorkspaceService
extends DefaultUserWorkspaceServiceImpl {
    private static final long serialVersionUID = 1L;

    protected String getTenantId(CoreSession userCoreSession, String userName) throws ClientException {
        MultiTenantService multiTenantService;
        String tenantId = null;
        if (userName == null) {
            userName = userCoreSession.getPrincipal().getName();
        }
        if ((multiTenantService = (MultiTenantService)Framework.getLocalService(MultiTenantService.class)).isTenantIsolationEnabled(userCoreSession)) {
            tenantId = MultiTenantHelper.getTenantId(userName);
        }
        return tenantId;
    }

    protected String computePathUserWorkspaceRoot(CoreSession userCoreSession, String userName, DocumentModel currentDocument) throws ClientException {
        String tenantId = this.getTenantId(userCoreSession, userName);
        if (StringUtils.isBlank((String)tenantId)) {
            return super.computePathUserWorkspaceRoot(userCoreSession, userName, currentDocument);
        }
        return this.computePathUserWorkspaceRootForTenant(userCoreSession, tenantId);
    }

    protected String computePathUserWorkspaceRootForTenant(CoreSession session, String tenantId) throws ClientException {
        String tenantDocumentPath = MultiTenantHelper.getTenantDocumentPath(session, tenantId);
        Path path = new Path(tenantDocumentPath);
        path = path.append("UserWorkspaces");
        return path.toString();
    }

    protected String computePathForUserWorkspace(CoreSession userCoreSession, String userName, DocumentModel currentDocument) throws ClientException {
        String tenantId = this.getTenantId(userCoreSession, userName);
        if (StringUtils.isBlank((String)tenantId)) {
            return super.computePathForUserWorkspace(userCoreSession, userName, currentDocument);
        }
        return this.computePathForUserWorkspaceForTenant(userCoreSession, tenantId, userName);
    }

    protected String computePathForUserWorkspaceForTenant(CoreSession session, String tenantId, String userName) throws ClientException {
        String rootPath = this.computePathUserWorkspaceRootForTenant(session, tenantId);
        Path path = new Path(rootPath);
        path = path.append(this.getUserWorkspaceNameForUser(userName));
        return path.toString();
    }
}

