/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.multi.tenant;

import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.multi.tenant.MultiTenantService;
import org.nuxeo.runtime.api.Framework;

public class MultiTenantListener
implements EventListener {
    public void handleEvent(Event event) throws ClientException {
        EventContext ctx = event.getContext();
        if (!(ctx instanceof DocumentEventContext)) {
            return;
        }
        MultiTenantService multiTenantService = (MultiTenantService)Framework.getLocalService(MultiTenantService.class);
        String tenantDocumentType = multiTenantService.getTenantDocumentType();
        DocumentModel doc = ((DocumentEventContext)ctx).getSourceDocument();
        if (!doc.getType().equals(tenantDocumentType)) {
            return;
        }
        CoreSession session = ctx.getCoreSession();
        if (!multiTenantService.isTenantIsolationEnabled(session)) {
            return;
        }
        String eventName = event.getName();
        if ("documentCreated".equals(eventName) || "documentCreatedByCopy".equals(eventName)) {
            multiTenantService.enableTenantIsolationFor(session, doc);
            session.save();
        } else if ("documentRemoved".equals(eventName)) {
            multiTenantService.disableTenantIsolationFor(session, doc);
            session.save();
        } else if ("lifecycle_transition_event".equals(eventName)) {
            String transition = (String)((Object)ctx.getProperty("transition"));
            if ("delete".equals(transition)) {
                multiTenantService.disableTenantIsolationFor(session, doc);
                session.save();
            } else if ("undelete".equals(transition)) {
                multiTenantService.enableTenantIsolationFor(session, doc);
                session.save();
            }
        }
    }
}

