/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.multi.tenant.operations;

import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.usermanager.UserManager;

@Operation(id="Services.CreateUser", category="Services", label="Creates a new user", description="Creates a new user.")
public class CreateUser {
    public static final String ID = "Services.CreateUser";
    @Context
    protected UserManager userManager;
    @Param(name="username", required=true)
    protected String username;
    @Param(name="password", required=true)
    protected String password;
    @Param(name="email", required=true)
    protected String email;
    @Param(name="firstName", required=false)
    protected String firstName;
    @Param(name="lastName", required=false)
    protected String lastName;
    @Param(name="company", required=false)
    protected String company;
    @Param(name="tenantId", required=false)
    protected String tenantId = "";
    @Param(name="groups", required=false)
    protected StringList groups;

    @OperationMethod
    public void run() {
        if (this.userManager.getPrincipal(this.username) != null) {
            return;
        }
        DocumentModel newUser = this.userManager.getBareUserModel();
        newUser.setProperty("user", "username", (Object)this.username);
        newUser.setProperty("user", "password", (Object)this.password);
        newUser.setProperty("user", "email", (Object)this.email);
        newUser.setProperty("user", "firstName", (Object)this.firstName);
        newUser.setProperty("user", "lastName", (Object)this.lastName);
        newUser.setProperty("user", "company", (Object)this.company);
        newUser.setProperty("user", "tenantId", (Object)this.tenantId);
        newUser.setProperty("user", "groups", (Object)this.groups);
        this.userManager.createUser(newUser);
    }
}

