/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.nuxeo.launcher.NuxeoLauncher;
import org.nuxeo.launcher.config.ConfigurationGenerator;

public class NuxeoTomcatLauncher
extends NuxeoLauncher {
    public NuxeoTomcatLauncher(ConfigurationGenerator configurationGenerator) {
        super(configurationGenerator);
    }

    @Override
    protected Collection<? extends String> getServerProperties() {
        ArrayList<String> serverProperties = new ArrayList<String>();
        serverProperties.add("-Djava.util.logging.manager=org.apache.juli.ClassLoaderLogManager");
        File home = this.configurationGenerator.getNuxeoHome();
        File endorsed = new File(home, "endorsed");
        serverProperties.add("-Dcatalina.base=" + home.getPath());
        serverProperties.add("-Dcatalina.home=" + home.getPath());
        serverProperties.add("-Djava.endorsed.dirs=" + endorsed.getPath());
        return serverProperties;
    }

    @Override
    protected String getClassPath() {
        String cp = ".";
        cp = this.addToClassPath(cp, "nxserver" + File.separator + "lib");
        cp = this.addToClassPath(cp, "bin" + File.separator + "bootstrap.jar");
        return cp;
    }

    @Override
    protected void setServerStartCommand(List<String> command) {
        command.add("org.apache.catalina.startup.Bootstrap");
        command.add("start");
    }

    @Override
    protected void setServerStopCommand(List<String> command) {
        command.add("org.apache.catalina.startup.Bootstrap");
        command.add("stop");
    }

    @Override
    protected String getServerPrint() {
        return "org.apache.catalina.startup.Bootstrap";
    }
}

