/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.nuxeo.launcher.NuxeoLauncher;
import org.nuxeo.launcher.config.ConfigurationGenerator;
import org.nuxeo.launcher.config.JBossConfigurator;

public class NuxeoJBossLauncher
extends NuxeoLauncher {
    private static final String BIND_ADDRESS_PARAM = "nuxeo.bind.address";
    private static final String BIND_ADDRESS_DEFAULT = "0.0.0.0";

    public NuxeoJBossLauncher(ConfigurationGenerator configurationGenerator) {
        super(configurationGenerator);
    }

    @Override
    protected String getClassPath() {
        String cp = ".";
        cp = this.addToClassPath(cp, "bin" + File.separator + "run.jar");
        return cp;
    }

    @Override
    protected void setServerStartCommand(List<String> command) {
        command.add("org.jboss.Main");
        command.add("-b");
        command.add(this.configurationGenerator.getUserConfig().getProperty(BIND_ADDRESS_PARAM, BIND_ADDRESS_DEFAULT));
    }

    @Override
    protected void setServerStopCommand(List<String> command) {
        command.add("org.jboss.Shutdown");
        command.add("--shutdown");
    }

    @Override
    protected Collection<? extends String> getServerProperties() {
        ArrayList<String> serverProperties = new ArrayList<String>();
        serverProperties.add("-Djava.endorsed.dirs=" + new File(this.configurationGenerator.getNuxeoHome(), "lib" + File.separator + "endorsed"));
        serverProperties.add("-Djboss.server.log.dir=" + this.configurationGenerator.getLogDir());
        serverProperties.add("-Djboss.server.temp.dir=" + this.configurationGenerator.getTmpDir());
        if (this.overrideJavaTmpDir) {
            serverProperties.add("-Djboss.server.temp.dir.overrideJavaTmpDir=true");
        }
        return serverProperties;
    }

    @Override
    protected String getServerPrint() {
        return "org.jboss.Main";
    }

    @Override
    protected String getInstallClassPath(File tmpDir) throws IOException {
        String cp = ".";
        tmpDir.delete();
        tmpDir.mkdirs();
        File baseDir = new File(this.configurationGenerator.getRuntimeHome(), "bundles");
        String[] filenames = new String[]{"nuxeo-runtime-osgi", "nuxeo-runtime", "nuxeo-common", "nuxeo-connect-update", "nuxeo-connect-client", "nuxeo-connect-offline-update", "nuxeo-connect-client-wrapper", "nuxeo-runtime-reload", "nuxeo-launcher-commons"};
        cp = this.getTempClassPath(tmpDir, cp, baseDir, filenames);
        baseDir = this.configurationGenerator.getServerConfigurator().getNuxeoLibDir();
        filenames = new String[]{"commons-io", "commons-jexl", "groovy-all", "osgi-core", "xercesImpl"};
        cp = this.getTempClassPath(tmpDir, cp, baseDir, filenames);
        baseDir = this.configurationGenerator.getServerConfigurator().getServerLibDir();
        filenames = new String[]{"commons-collections", "commons-logging", "log4j"};
        cp = this.getTempClassPath(tmpDir, cp, baseDir, filenames);
        baseDir = new File(this.configurationGenerator.getNuxeoHome(), "server" + File.separator + ((JBossConfigurator)this.configurationGenerator.getServerConfigurator()).getConfiguration() + File.separator + "lib");
        filenames = new String[]{"commons-lang"};
        cp = this.getTempClassPath(tmpDir, cp, baseDir, filenames);
        baseDir = new File(this.configurationGenerator.getNuxeoHome(), "bin");
        filenames = new String[]{"nuxeo-launcher"};
        cp = this.getTempClassPath(tmpDir, cp, baseDir, filenames);
        return cp;
    }
}

