/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.nuxeo.launcher.NuxeoLauncher;
import org.nuxeo.launcher.config.ConfigurationGenerator;

public class NuxeoJettyLauncher
extends NuxeoLauncher {
    public NuxeoJettyLauncher(ConfigurationGenerator configurationGenerator) {
        super(configurationGenerator);
        throw new UnsupportedOperationException();
    }

    @Override
    protected String getClassPath() {
        String cp = ".";
        cp = this.addToClassPath(cp, "lib");
        cp = this.addToClassPath(cp, "nuxeo-runtime-launcher-*.jar");
        cp = this.addToClassPath(cp, "bundles");
        return cp;
    }

    @Override
    protected void setServerStartCommand(List<String> command) {
        command.add("org.nuxeo.osgi.application.Main");
        command.add("-home");
        command.add(this.configurationGenerator.getNuxeoHome().getPath());
    }

    @Override
    protected void setServerStopCommand(List<String> command) {
        command.add("org.nuxeo.osgi.application.Main");
        command.add("stop");
    }

    @Override
    protected Collection<? extends String> getServerProperties() {
        ArrayList serverProperties = new ArrayList();
        return serverProperties;
    }

    @Override
    protected String getServerPrint() {
        return "org.nuxeo.osgi.application.Main";
    }

    @Override
    protected String getInstallClassPath(File tmpDir) throws IOException {
        String cp = ".";
        tmpDir.delete();
        tmpDir.mkdirs();
        File baseDir = new File(this.configurationGenerator.getRuntimeHome(), "bundles");
        String[] filenames = new String[]{"nuxeo-runtime-osgi", "nuxeo-runtime", "nuxeo-common", "nuxeo-connect-update", "nuxeo-connect-client", "nuxeo-connect-offline-update", "nuxeo-connect-client-wrapper", "nuxeo-runtime-reload", "nuxeo-launcher-commons"};
        cp = this.getTempClassPath(tmpDir, cp, baseDir, filenames);
        baseDir = this.configurationGenerator.getServerConfigurator().getNuxeoLibDir();
        filenames = new String[]{"commons-io", "commons-jexl", "groovy-all", "osgi-core", "xercesImpl", "commons-collections"};
        cp = this.getTempClassPath(tmpDir, cp, baseDir, filenames);
        baseDir = this.configurationGenerator.getServerConfigurator().getServerLibDir();
        filenames = new String[]{"commons-lang", "commons-logging", "log4j"};
        cp = this.getTempClassPath(tmpDir, cp, baseDir, filenames);
        baseDir = new File(this.configurationGenerator.getNuxeoHome(), "bin");
        filenames = new String[]{"nuxeo-launcher"};
        cp = this.getTempClassPath(tmpDir, cp, baseDir, filenames);
        return cp;
    }
}

