/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher.connect;

import java.io.Console;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.Environment;
import org.nuxeo.connect.CallbackHolder;
import org.nuxeo.connect.NuxeoConnectClient;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.data.DownloadingPackage;
import org.nuxeo.connect.downloads.ConnectDownloadManager;
import org.nuxeo.connect.identity.LogicalInstanceIdentifier;
import org.nuxeo.connect.packages.PackageManager;
import org.nuxeo.connect.packages.dependencies.DependencyResolution;
import org.nuxeo.connect.update.LocalPackage;
import org.nuxeo.connect.update.Package;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.PackageType;
import org.nuxeo.connect.update.PackageVisibility;
import org.nuxeo.connect.update.ValidationStatus;
import org.nuxeo.connect.update.Version;
import org.nuxeo.connect.update.model.PackageDefinition;
import org.nuxeo.connect.update.standalone.StandaloneUpdateService;
import org.nuxeo.connect.update.task.Task;
import org.nuxeo.launcher.connect.StandaloneCallbackHolder;
import org.nuxeo.launcher.info.CommandInfo;
import org.nuxeo.launcher.info.CommandSetInfo;
import org.nuxeo.launcher.info.PackageInfo;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class ConnectBroker {
    private static final Log log = LogFactory.getLog(ConnectBroker.class);
    private static final int PACKAGES_DOWNLOAD_TIMEOUT_SECONDS = 300;
    public static final String PARAM_MP_DIR = "nuxeo.distribution.marketplace.dir";
    public static final String DISTRIBUTION_MP_DIR_DEFAULT = "setupWizardDownloads";
    public static final String PACKAGES_XML = "packages.xml";
    protected static final String LAUNCHER_CHANGED_PROPERTY = "launcher.changed";
    protected static final int LAUNCHER_CHANGED_EXIT_CODE = 128;
    private Environment env;
    private StandaloneUpdateService service;
    private CallbackHolder cbHolder;
    private CommandSetInfo cset = new CommandSetInfo();
    private String targetPlatform;
    private String distributionMPDir;
    private String relax = "ask";
    public static final String OPTION_RELAX_DEFAULT = "ask";
    private String accept = "ask";
    public static final String OPTION_ACCEPT_DEFAULT = "ask";

    public ConnectBroker(Environment env) throws IOException, PackageException {
        this.env = env;
        this.service = new StandaloneUpdateService(env);
        this.service.initialize();
        this.cbHolder = new StandaloneCallbackHolder(env, this.service);
        NuxeoConnectClient.setCallBackHolder((CallbackHolder)this.cbHolder);
        this.targetPlatform = env.getProperty("org.nuxeo.distribution.name") + "-" + env.getProperty("org.nuxeo.distribution.version");
        this.distributionMPDir = env.getProperty(PARAM_MP_DIR, DISTRIBUTION_MP_DIR_DEFAULT);
    }

    public String getCLID() throws LogicalInstanceIdentifier.NoCLID {
        return LogicalInstanceIdentifier.instance().getCLID();
    }

    public StandaloneUpdateService getUpdateService() {
        return this.service;
    }

    public PackageManager getPackageManager() {
        return NuxeoConnectClient.getPackageManager();
    }

    public void refreshCache() {
        this.getPackageManager().flushCache();
        NuxeoConnectClient.getPackageManager().listAllPackages();
    }

    public CommandSetInfo getCommandSet() {
        return this.cset;
    }

    protected boolean isInstalledPackageName(String pkgName) {
        List<LocalPackage> localPackages = this.getPkgList();
        boolean foundName = false;
        for (LocalPackage pkg : localPackages) {
            if (!pkg.getName().equals(pkgName) || pkg.getState() != 3 && pkg.getState() != 4 && pkg.getState() != 5) continue;
            foundName = true;
            break;
        }
        return foundName;
    }

    protected boolean isLocalPackageId(String pkgId) {
        List<LocalPackage> localPackages = this.getPkgList();
        boolean foundId = false;
        for (LocalPackage pkg : localPackages) {
            if (!pkg.getId().equals(pkgId)) continue;
            foundId = true;
            break;
        }
        return foundId;
    }

    protected boolean isRemotePackageId(String pkgId) {
        List remotePackages = NuxeoConnectClient.getPackageManager().listAllPackages();
        boolean foundId = false;
        for (DownloadablePackage pkg : remotePackages) {
            if (!pkg.getId().equals(pkgId)) continue;
            foundId = true;
            break;
        }
        return foundId;
    }

    protected String getBestIdForNameInList(String pkgName, List<? extends Package> pkgList) {
        String foundId = null;
        TreeMap<Version, String> foundPkgs = new TreeMap<Version, String>();
        TreeMap<Version, String> matchingPkgs = new TreeMap<Version, String>();
        for (Package package_ : pkgList) {
            if (!package_.getName().equals(pkgName)) continue;
            foundPkgs.put(package_.getVersion(), package_.getId());
            if (!Arrays.asList(package_.getTargetPlatforms()).contains(this.targetPlatform)) continue;
            matchingPkgs.put(package_.getVersion(), package_.getId());
        }
        if (matchingPkgs.size() != 0) {
            foundId = (String)matchingPkgs.get(matchingPkgs.lastKey());
        } else if (foundPkgs.size() != 0) {
            foundId = (String)foundPkgs.get(foundPkgs.lastKey());
        }
        return foundId;
    }

    protected String getLocalPackageIdFromName(String pkgName) {
        return this.getBestIdForNameInList(pkgName, this.getPkgList());
    }

    protected List<String> getAllLocalPackageIdsFromName(String pkgName) {
        ArrayList<String> foundIds = new ArrayList<String>();
        for (LocalPackage pkg : this.getPkgList()) {
            if (!pkg.getName().equals(pkgName)) continue;
            foundIds.add(pkg.getId());
        }
        return foundIds;
    }

    protected String getInstalledPackageIdFromName(String pkgName) {
        List<LocalPackage> localPackages = this.getPkgList();
        ArrayList<LocalPackage> installedPackages = new ArrayList<LocalPackage>();
        for (LocalPackage pkg : localPackages) {
            if (pkg.getState() != 3 && pkg.getState() != 4 && pkg.getState() != 5) continue;
            installedPackages.add(pkg);
        }
        return this.getBestIdForNameInList(pkgName, installedPackages);
    }

    protected String getRemotePackageIdFromName(String pkgName) {
        return this.getBestIdForNameInList(pkgName, NuxeoConnectClient.getPackageManager().listAllPackages());
    }

    protected File getLocalPackageFile(String pkgFile) {
        File fileToCheck;
        boolean foundFile = false;
        if (pkgFile.startsWith("file:")) {
            pkgFile = pkgFile.substring(5);
        }
        if ((fileToCheck = new File(pkgFile)).exists()) {
            foundFile = true;
        } else {
            fileToCheck = new File(this.env.getServerHome(), pkgFile);
            if (fileToCheck.exists()) {
                foundFile = true;
            }
        }
        if (foundFile) {
            return fileToCheck;
        }
        return null;
    }

    protected boolean isLocalPackageFile(String pkgFile) {
        return this.getLocalPackageFile(pkgFile) != null;
    }

    protected List<String> getDistributionFilenames() {
        File distributionMPFile = new File(this.distributionMPDir, PACKAGES_XML);
        ArrayList<String> md5Filenames = new ArrayList<String>();
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        docFactory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = docFactory.newDocumentBuilder();
            Document doc = builder.parse(distributionMPFile);
            XPathFactory xpFactory = XPathFactory.newInstance();
            XPath xpath = xpFactory.newXPath();
            XPathExpression expr = xpath.compile("//package/@md5");
            NodeList nodes = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
            for (int i = 0; i < nodes.getLength(); ++i) {
                String md5 = nodes.item(i).getNodeValue();
                if (md5 == null || md5.length() <= 0) continue;
                md5Filenames.add(md5);
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed parsing " + distributionMPFile), (Throwable)e);
            return new ArrayList<String>();
        }
        return md5Filenames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, PackageDefinition> getDistributionDefinitions(List<String> md5Filenames) {
        HashMap<String, PackageDefinition> allDefinitions = new HashMap<String, PackageDefinition>();
        if (md5Filenames == null) {
            return allDefinitions;
        }
        for (String md5Filename : md5Filenames) {
            ZipFile zipFile;
            File md5File = new File(this.distributionMPDir, md5Filename);
            if (!md5File.exists()) continue;
            try {
                zipFile = new ZipFile(md5File);
            }
            catch (ZipException e) {
                log.warn((Object)("Unzip error reading file " + md5File), (Throwable)e);
                continue;
            }
            catch (IOException e) {
                log.warn((Object)("Could not read file " + md5File), (Throwable)e);
                continue;
            }
            try {
                ZipEntry zipEntry = zipFile.getEntry("package.xml");
                InputStream in = zipFile.getInputStream(zipEntry);
                PackageDefinition pd = NuxeoConnectClient.getPackageUpdateService().loadPackage(in);
                allDefinitions.put(md5Filename, pd);
            }
            catch (Exception e) {
                log.error((Object)"Could not read package description", (Throwable)e);
            }
            finally {
                try {
                    zipFile.close();
                }
                catch (IOException e) {
                    log.warn((Object)("Unexpected error closing file " + md5File), (Throwable)e);
                }
            }
        }
        return allDefinitions;
    }

    protected void addDistributionPackage(String md5) {
        File distributionFile = new File(this.distributionMPDir, md5);
        if (distributionFile.exists()) {
            try {
                this.pkgAdd(distributionFile.getCanonicalPath());
            }
            catch (IOException e) {
                log.warn((Object)("Could not add distribution file " + md5));
            }
        }
    }

    public void addDistributionPackages() {
        Map<String, PackageDefinition> distributionPackages = this.getDistributionDefinitions(this.getDistributionFilenames());
        if (distributionPackages.isEmpty()) {
            return;
        }
        List<LocalPackage> localPackages = this.getPkgList();
        HashMap<String, LocalPackage> localPackagesById = new HashMap<String, LocalPackage>();
        if (localPackages != null) {
            for (LocalPackage pkg : localPackages) {
                localPackagesById.put(pkg.getId(), pkg);
            }
        }
        for (String md5 : distributionPackages.keySet()) {
            PackageDefinition md5Pkg = distributionPackages.get(md5);
            if (localPackagesById.containsKey(md5Pkg.getId())) {
                LocalPackage localPackage = (LocalPackage)localPackagesById.get(md5Pkg.getId());
                if (!localPackage.getVersion().isSnapshot() || localPackage.getState() == 5) continue;
                this.pkgRemove(localPackage.getId());
                this.addDistributionPackage(md5);
                continue;
            }
            this.addDistributionPackage(md5);
        }
    }

    public List<LocalPackage> getPkgList() {
        try {
            return this.service.getPackages();
        }
        catch (Exception e) {
            log.error((Object)"Could not read package list");
            return null;
        }
    }

    public void pkgList() {
        log.info((Object)"Local packages:");
        this.pkgList(this.getPkgList());
    }

    public void pkgListAll() {
        log.info((Object)"All packages:");
        this.pkgList(NuxeoConnectClient.getPackageManager().listAllPackages());
    }

    public void pkgList(List<? extends Package> packagesList) {
        CommandInfo cmdInfo = this.cset.newCommandInfo("list");
        try {
            if (packagesList.isEmpty()) {
                log.info((Object)"None");
            } else {
                NuxeoConnectClient.getPackageManager().sort(packagesList);
                StringBuilder sb = new StringBuilder();
                for (Package package_ : packagesList) {
                    String packageDescription;
                    cmdInfo.packages.add(new PackageInfo(package_.getName(), package_.getVersion().toString(), package_.getId(), package_.getState()));
                    switch (package_.getState()) {
                        case 1: {
                            packageDescription = "downloading";
                            break;
                        }
                        case 2: {
                            packageDescription = "downloaded";
                            break;
                        }
                        case 3: {
                            packageDescription = "installing";
                            break;
                        }
                        case 4: {
                            packageDescription = "installed";
                            break;
                        }
                        case 5: {
                            packageDescription = "started";
                            break;
                        }
                        case 0: {
                            packageDescription = "remote";
                            break;
                        }
                        default: {
                            packageDescription = "unknown";
                        }
                    }
                    packageDescription = String.format("%6s %11s\t", package_.getType(), packageDescription);
                    if (package_.getState() == 0 && package_.getType() != PackageType.STUDIO && package_.getVisibility() != PackageVisibility.PUBLIC && !LogicalInstanceIdentifier.isRegistered()) {
                        packageDescription = packageDescription + "Registration required for ";
                    }
                    packageDescription = packageDescription + String.format("%s (id: %s)\n", package_.getName(), package_.getId());
                    sb.append(packageDescription);
                }
                log.info((Object)sb.toString());
            }
            cmdInfo.exitCode = 0;
        }
        catch (Exception e) {
            log.error((Object)e);
            cmdInfo.exitCode = 1;
        }
    }

    protected void performTask(Task task) throws PackageException {
        ValidationStatus validationStatus = task.validate();
        if (validationStatus.hasErrors()) {
            throw new PackageException("Failed to validate package " + task.getPackage().getId() + " -> " + validationStatus.getErrors());
        }
        if (validationStatus.hasWarnings()) {
            log.warn((Object)("Got warnings on package validation " + task.getPackage().getId() + " -> " + validationStatus.getWarnings()));
        }
        task.run(null);
    }

    public boolean pkgReset() {
        CommandInfo cmdInfo = this.cset.newCommandInfo("reset");
        if ("ask".equalsIgnoreCase(this.accept)) {
            this.accept = this.readConsole("The reset will erase Marketplace packages history.\nDo you want to continue (yes/no)? [yes] ", "yes", new Object[0]);
        }
        if (!Boolean.parseBoolean(this.accept)) {
            cmdInfo.exitCode = 1;
            return false;
        }
        try {
            this.service.reset();
            log.info((Object)"Packages reset done: all packages were marked as DOWNLOADED");
            List localPackages = this.service.getPackages();
            for (LocalPackage localPackage : localPackages) {
                localPackage.getUninstallFile().delete();
                FileUtils.deleteDirectory((File)localPackage.getData().getEntry("backup"));
                cmdInfo.packages.add(new PackageInfo(localPackage.getName(), localPackage.getVersion().toString(), localPackage.getId(), localPackage.getState()));
            }
            this.service.getRegistry().delete();
            FileUtils.deleteDirectory((File)this.service.getBackupDir());
            cmdInfo.exitCode = 0;
        }
        catch (PackageException e) {
            log.error((Object)e);
            cmdInfo.exitCode = 1;
        }
        catch (IOException e) {
            log.error((Object)e);
            cmdInfo.exitCode = 1;
        }
        return cmdInfo.exitCode == 0;
    }

    public boolean pkgPurge() throws PackageException {
        ArrayList<String> localNames = new ArrayList<String>();
        for (LocalPackage pkg : this.service.getPackages()) {
            localNames.add(pkg.getName());
        }
        return this.pkgRequest(null, null, null, localNames);
    }

    public boolean pkgUninstall(List<String> packageIdsToRemove) {
        log.debug((Object)("Uninstalling: " + packageIdsToRemove));
        for (String pkgId : packageIdsToRemove) {
            if (this.pkgUninstall(pkgId) != null) continue;
            log.error((Object)("Unable to uninstall " + pkgId));
            return false;
        }
        return true;
    }

    public LocalPackage pkgUninstall(String pkgId) {
        if (this.env.getProperty(LAUNCHER_CHANGED_PROPERTY, "false").equals("true")) {
            System.exit(128);
        }
        CommandInfo cmdInfo = this.cset.newCommandInfo("uninstall");
        cmdInfo.param = pkgId;
        try {
            String realPkgId;
            LocalPackage pkg = this.service.getPackage(pkgId);
            if (pkg == null && (realPkgId = this.getInstalledPackageIdFromName(pkgId)) != null) {
                pkgId = realPkgId;
                pkg = this.service.getPackage(realPkgId);
            }
            if (pkg == null) {
                throw new PackageException("Package not found: " + pkgId);
            }
            log.info((Object)("Uninstalling " + pkgId));
            Task uninstallTask = pkg.getUninstallTask();
            try {
                this.performTask(uninstallTask);
            }
            catch (PackageException e) {
                uninstallTask.rollback();
                throw e;
            }
            pkg = this.service.getPackage(pkgId);
            cmdInfo.packages.add(new PackageInfo(pkg.getName(), pkg.getVersion().toString(), pkg.getId(), pkg.getState()));
            cmdInfo.exitCode = 0;
            return pkg;
        }
        catch (Exception e) {
            log.error((Object)("Failed to uninstall package: " + pkgId), (Throwable)e);
            cmdInfo.exitCode = 1;
            return null;
        }
    }

    public void pkgRemove(List<String> pkgsToRemove) {
        if (pkgsToRemove != null) {
            log.debug((Object)("Removing: " + pkgsToRemove));
            for (String pkgNameOrId : pkgsToRemove) {
                List<Object> allIds;
                if (this.isLocalPackageId(pkgNameOrId)) {
                    allIds = new ArrayList();
                    allIds.add(pkgNameOrId);
                } else {
                    allIds = this.getAllLocalPackageIdsFromName(pkgNameOrId);
                }
                for (String string : allIds) {
                    if (this.pkgRemove(string) != null) continue;
                    log.warn((Object)("Unable to remove " + string));
                }
            }
        }
    }

    public LocalPackage pkgRemove(String pkgId) {
        CommandInfo cmdInfo = this.cset.newCommandInfo("remove");
        cmdInfo.param = pkgId;
        try {
            String realPkgId;
            LocalPackage pkg = this.service.getPackage(pkgId);
            if (pkg == null && (realPkgId = this.getLocalPackageIdFromName(pkgId)) != null) {
                pkgId = realPkgId;
                pkg = this.service.getPackage(realPkgId);
            }
            if (pkg == null) {
                throw new PackageException("Package not found: " + pkgId);
            }
            if (pkg.getState() == 5 || pkg.getState() == 4) {
                this.pkgUninstall(pkgId);
                pkg = this.service.getPackage(pkgId);
            }
            if (pkg.getState() != 2) {
                throw new PackageException("Can only remove packages in DOWNLOADED, INSTALLED or STARTED state");
            }
            log.info((Object)("Removing " + pkgId));
            this.service.removePackage(pkgId);
            PackageInfo pkgInfo = new PackageInfo(pkg.getName(), pkg.getVersion().toString(), pkg.getId(), pkg.getState());
            pkgInfo.state = 0;
            cmdInfo.packages.add(pkgInfo);
            cmdInfo.exitCode = 0;
            return pkg;
        }
        catch (Exception e) {
            log.error((Object)("Failed to remove package: " + pkgId), (Throwable)e);
            cmdInfo.exitCode = 1;
            return null;
        }
    }

    public void pkgAdd(List<String> pkgsToAdd) {
        if (pkgsToAdd != null) {
            for (String pkgToAdd : pkgsToAdd) {
                this.pkgAdd(pkgToAdd);
            }
        }
    }

    public LocalPackage pkgAdd(String packageFileName) {
        CommandInfo cmdInfo = this.cset.newCommandInfo("add");
        cmdInfo.param = packageFileName;
        try {
            File fileToAdd = this.getLocalPackageFile(packageFileName);
            if (fileToAdd == null) {
                String pkgId = null;
                pkgId = this.isRemotePackageId(packageFileName) ? packageFileName : this.getRemotePackageIdFromName(packageFileName);
                if (pkgId == null) {
                    throw new FileNotFoundException("File not found");
                }
                ArrayList<String> downloadList = new ArrayList<String>();
                downloadList.add(pkgId);
                if (!this.downloadPackages(downloadList)) {
                    throw new PackageException("Failed to download package " + pkgId);
                }
                LocalPackage pkg = this.service.getPackage(pkgId);
                if (pkg == null) {
                    throw new PackageException("Failed to find downloaded package in cache " + pkgId);
                }
                return pkg;
            }
            log.info((Object)("Adding " + packageFileName));
            LocalPackage pkg = this.service.addPackage(fileToAdd);
            cmdInfo.packages.add(new PackageInfo(pkg.getName(), pkg.getVersion().toString(), pkg.getId(), pkg.getState()));
            cmdInfo.exitCode = 0;
            return pkg;
        }
        catch (FileNotFoundException e) {
            log.error((Object)("Cannot find " + packageFileName + " relative to current directory or to NUXEO_HOME"));
            cmdInfo.exitCode = 1;
            return null;
        }
        catch (PackageException e) {
            log.error((Object)("Failed to add package: " + packageFileName), (Throwable)e);
            cmdInfo.exitCode = 1;
            return null;
        }
    }

    public boolean pkgInstall(List<String> packageIdsToInstall) {
        log.debug((Object)("Installing: " + packageIdsToInstall));
        for (String pkgId : packageIdsToInstall) {
            if (this.pkgInstall(pkgId) != null) continue;
            log.error((Object)("Unable to install " + pkgId));
            return false;
        }
        return true;
    }

    public LocalPackage pkgInstall(String pkgId) {
        if (this.env.getProperty(LAUNCHER_CHANGED_PROPERTY, "false").equals("true")) {
            System.exit(128);
        }
        CommandInfo cmdInfo = this.cset.newCommandInfo("install");
        cmdInfo.param = pkgId;
        try {
            String realPkgId;
            LocalPackage pkg = this.service.getPackage(pkgId);
            if (pkg == null && (realPkgId = this.getLocalPackageIdFromName(pkgId)) != null) {
                pkg = this.service.getPackage(realPkgId);
            }
            if (pkg == null) {
                pkg = this.pkgAdd(pkgId);
            }
            if (pkg == null) {
                throw new PackageException("Package not found: " + pkgId);
            }
            cmdInfo.param = pkgId = pkg.getId();
            log.info((Object)("Installing " + pkgId));
            Task installTask = pkg.getInstallTask();
            try {
                this.performTask(installTask);
            }
            catch (PackageException e) {
                installTask.rollback();
                throw e;
            }
            pkg = this.service.getPackage(pkgId);
            cmdInfo.packages.add(new PackageInfo(pkg.getName(), pkg.getVersion().toString(), pkg.getId(), pkg.getState()));
            cmdInfo.exitCode = 0;
            return pkg;
        }
        catch (Exception e) {
            log.error((Object)("Failed to install package: " + pkgId), (Throwable)e);
            cmdInfo.exitCode = 1;
            return null;
        }
    }

    public boolean listPending(File commandsFile) {
        return this.executePending(commandsFile, false, false);
    }

    public boolean executePending(File commandsFile, boolean doExecute, boolean useResolver) {
        int errorValue = 0;
        if (!commandsFile.isFile()) {
            return false;
        }
        ArrayList<String> pkgsToAdd = new ArrayList<String>();
        ArrayList<String> pkgsToInstall = new ArrayList<String>();
        ArrayList<String> pkgsToUninstall = new ArrayList<String>();
        ArrayList<String> pkgsToRemove = new ArrayList<String>();
        try {
            List lines = FileUtils.readLines((File)commandsFile);
            for (String line : lines) {
                CommandInfo cmdInfo;
                String[] split = (line = line.trim()).split("\\s+", 2);
                if (split.length == 2) {
                    if (split[0].equals("install")) {
                        if (doExecute) {
                            if (useResolver) {
                                pkgsToInstall.add(split[1]);
                            } else {
                                this.pkgInstall(split[1]);
                            }
                        } else {
                            cmdInfo = this.cset.newCommandInfo("install");
                            cmdInfo.param = split[1];
                            cmdInfo.pending = true;
                            log.info((Object)("Pending action: install " + split[1]));
                        }
                    } else if (split[0].equals("add")) {
                        if (doExecute) {
                            if (useResolver) {
                                pkgsToAdd.add(split[1]);
                            } else {
                                this.pkgAdd(split[1]);
                            }
                        } else {
                            cmdInfo = this.cset.newCommandInfo("add");
                            cmdInfo.param = split[1];
                            cmdInfo.pending = true;
                            log.info((Object)("Pending action: add " + split[1]));
                        }
                    } else if (split[0].equals("uninstall")) {
                        if (doExecute) {
                            if (useResolver) {
                                pkgsToUninstall.add(split[1]);
                            } else {
                                this.pkgUninstall(split[1]);
                            }
                        } else {
                            cmdInfo = this.cset.newCommandInfo("uninstall");
                            cmdInfo.param = split[1];
                            cmdInfo.pending = true;
                            log.info((Object)("Pending action: uninstall " + split[1]));
                        }
                    } else if (split[0].equals("remove")) {
                        if (doExecute) {
                            if (useResolver) {
                                pkgsToRemove.add(split[1]);
                            } else {
                                this.pkgRemove(split[1]);
                            }
                        } else {
                            cmdInfo = this.cset.newCommandInfo("remove");
                            cmdInfo.param = split[1];
                            cmdInfo.pending = true;
                            log.info((Object)("Pending action: remove " + split[1]));
                        }
                    } else {
                        errorValue = 1;
                    }
                } else if (split.length == 1 && line.length() > 0 && !line.startsWith("#")) {
                    if (doExecute) {
                        if ("init".equals(line)) {
                            this.addDistributionPackages();
                        } else if (useResolver) {
                            pkgsToInstall.add(line);
                        } else {
                            this.pkgInstall(line);
                        }
                    } else {
                        cmdInfo = this.cset.newCommandInfo("install");
                        cmdInfo.param = line;
                        cmdInfo.pending = true;
                        log.info((Object)("Pending action: install " + line));
                    }
                }
                if (errorValue == 0) continue;
                log.error((Object)("Error processing pending package/command: " + line));
            }
            if (doExecute) {
                if (useResolver) {
                    String oldAccept = this.accept;
                    String oldRelax = this.relax;
                    this.accept = "true";
                    this.relax = "true";
                    boolean success = this.pkgRequest(pkgsToAdd, pkgsToInstall, pkgsToUninstall, pkgsToRemove);
                    this.accept = oldAccept;
                    this.relax = oldRelax;
                    if (!success) {
                        errorValue = 2;
                    }
                }
                if (errorValue != 0) {
                    File bak = new File(commandsFile.getPath() + ".bak");
                    bak.delete();
                    commandsFile.renameTo(bak);
                } else {
                    commandsFile.delete();
                }
            }
        }
        catch (IOException e) {
            log.error((Object)e.getMessage());
        }
        return errorValue == 0;
    }

    protected boolean downloadPackages(List<String> packagesToDownload) {
        if (packagesToDownload == null || packagesToDownload.isEmpty()) {
            return true;
        }
        log.info((Object)("Downloading " + packagesToDownload + "..."));
        for (String pkg : packagesToDownload) {
            try {
                this.getPackageManager().download(pkg);
            }
            catch (Exception e) {
                log.error((Object)"Cannot download packages", (Throwable)e);
                return false;
            }
        }
        ConnectDownloadManager cdm = NuxeoConnectClient.getDownloadManager();
        List pkgs = cdm.listDownloadingPackages();
        long startTime = new Date().getTime();
        long deltaTime = 0L;
        boolean downloadOk = true;
        do {
            ArrayList<DownloadingPackage> pkgsCompleted = new ArrayList<DownloadingPackage>();
            for (DownloadingPackage pkg : pkgs) {
                if (!pkg.isCompleted()) continue;
                pkgsCompleted.add(pkg);
                CommandInfo cmdInfo = this.cset.newCommandInfo("add");
                cmdInfo.param = pkg.getId();
                log.debug((Object)("Completed " + pkg));
                cmdInfo.exitCode = 0;
            }
            pkgs.removeAll(pkgsCompleted);
        } while ((deltaTime = (new Date().getTime() - startTime) / 1000L) < 300L && pkgs.size() > 0);
        for (DownloadingPackage pkg : pkgs) {
            CommandInfo cmdInfo = this.cset.newCommandInfo("add");
            cmdInfo.param = pkg.getId();
            cmdInfo.exitCode = 1;
        }
        if (pkgs.size() > 0) {
            log.error((Object)"Timeout while trying to download packages");
            downloadOk = false;
        }
        return downloadOk;
    }

    public boolean pkgRequest(List<String> pkgsToAdd, List<String> pkgsToInstall, List<String> pkgsToUninstall, List<String> pkgsToRemove) {
        this.pkgAdd(pkgsToAdd);
        ArrayList<String> solverInstall = new ArrayList<String>();
        ArrayList<String> solverRemove = new ArrayList<String>();
        ArrayList<String> solverUpgrade = new ArrayList<String>();
        if (pkgsToInstall != null) {
            ArrayList<String> namesOrIdsToInstall = new ArrayList<String>();
            for (String pkgToInstall : pkgsToInstall) {
                if (this.isLocalPackageFile(pkgToInstall)) {
                    LocalPackage addedPkg = this.pkgAdd(pkgToInstall);
                    namesOrIdsToInstall.add(addedPkg.getId());
                    continue;
                }
                namesOrIdsToInstall.add(pkgToInstall);
            }
            for (String pkgToInstall : namesOrIdsToInstall) {
                Map allPackagesByID = NuxeoConnectClient.getPackageManager().getAllPackagesByID();
                DownloadablePackage pkg = (DownloadablePackage)allPackagesByID.get(pkgToInstall);
                if (pkg != null) {
                    if (this.isInstalledPackageName(pkg.getName())) {
                        solverUpgrade.add(pkgToInstall);
                        continue;
                    }
                    solverInstall.add(pkgToInstall);
                    continue;
                }
                String id = this.getInstalledPackageIdFromName(pkgToInstall);
                if (id != null) {
                    solverUpgrade.add(id);
                    continue;
                }
                solverInstall.add(pkgToInstall);
            }
        }
        if (pkgsToUninstall != null) {
            solverRemove.addAll(pkgsToUninstall);
        }
        if (pkgsToRemove != null) {
            solverRemove.addAll(pkgsToRemove);
        }
        if (solverInstall.size() != 0 || solverRemove.size() != 0 || solverUpgrade.size() != 0) {
            String requestPlatform;
            block26: {
                requestPlatform = this.targetPlatform;
                ArrayList<String> requestPackages = new ArrayList<String>();
                requestPackages.addAll(solverInstall);
                requestPackages.addAll(solverRemove);
                requestPackages.addAll(solverUpgrade);
                try {
                    String nonCompliantPkg = this.getPackageManager().getNonCompliant(requestPackages, this.targetPlatform);
                    if (nonCompliantPkg == null) break block26;
                    requestPlatform = null;
                    if ("ask".equalsIgnoreCase(this.relax)) {
                        this.relax = this.readConsole("Package %s is not available on platform version %s.\nDo you want to relax the constraint (yes/no)? [no] ", "no", nonCompliantPkg, this.targetPlatform);
                    }
                    if (Boolean.parseBoolean(this.relax)) {
                        log.warn((Object)String.format("Relax restriction to target platform %s because of package %s", this.targetPlatform, nonCompliantPkg));
                        break block26;
                    }
                    throw new PackageException(String.format("Package %s is not available on platform version %s (relax is not allowed)", nonCompliantPkg, this.targetPlatform));
                }
                catch (PackageException e) {
                    log.error((Object)e);
                    return false;
                }
            }
            DependencyResolution resolution = this.getPackageManager().resolveDependencies(solverInstall, solverRemove, solverUpgrade, requestPlatform);
            log.info((Object)resolution);
            if (resolution.isFailed()) {
                return false;
            }
            if (resolution.isEmpty()) {
                this.pkgRemove(pkgsToRemove);
                return true;
            }
            if ("ask".equalsIgnoreCase(this.accept)) {
                this.accept = this.readConsole("Do you want to continue (yes/no)? [yes] ", "yes", new Object[0]);
            }
            if (!Boolean.parseBoolean(this.accept)) {
                log.warn((Object)"Exit");
                return false;
            }
            List packageIdsToRemove = resolution.getOrderedPackageIdsToRemove();
            Map packagesToUpgrade = resolution.getLocalPackagesToUpgrade();
            List packageIdsToUpgrade = resolution.getUpgradePackageIds();
            List packageIdsToInstall = resolution.getOrderedPackageIdsToInstall();
            List packagesIdsUninstalledBecauseOfUpgrade = new ArrayList();
            if (!this.downloadPackages(resolution.getDownloadPackageIds())) {
                log.error((Object)"Aborting packages change request");
                return false;
            }
            if (!packagesToUpgrade.isEmpty()) {
                ArrayList<String> uninstallList = new ArrayList<String>();
                ArrayList<String> uninstallIdsList = new ArrayList<String>();
                uninstallList.addAll(packageIdsToRemove);
                uninstallIdsList.addAll(packageIdsToRemove);
                for (String pkg : packagesToUpgrade.keySet()) {
                    uninstallList.add(pkg);
                    uninstallIdsList.add(this.getInstalledPackageIdFromName(pkg));
                }
                DependencyResolution uninstallResolution = this.getPackageManager().resolveDependencies(null, uninstallList, null, requestPlatform);
                log.debug((Object)("Sub-resolution (uninstall) " + uninstallResolution));
                if (uninstallResolution.isFailed()) {
                    return false;
                }
                packageIdsToRemove = uninstallResolution.getOrderedPackageIdsToRemove();
                packagesIdsUninstalledBecauseOfUpgrade = ListUtils.subtract((List)packageIdsToRemove, uninstallIdsList);
            }
            if (!this.pkgUninstall(packageIdsToRemove)) {
                return false;
            }
            if (!packagesToUpgrade.isEmpty()) {
                ArrayList<String> installList = new ArrayList<String>();
                installList.addAll(solverInstall);
                installList.addAll(packageIdsToUpgrade);
                installList.addAll(packagesIdsUninstalledBecauseOfUpgrade);
                DependencyResolution installResolution = this.getPackageManager().resolveDependencies(installList, null, null, requestPlatform);
                log.debug((Object)("Sub-resolution (install) " + installResolution));
                if (installResolution.isFailed()) {
                    return false;
                }
                packageIdsToInstall = installResolution.getOrderedPackageIdsToInstall();
            }
            if (!this.pkgInstall(packageIdsToInstall)) {
                return false;
            }
            this.pkgRemove(pkgsToRemove);
        }
        return true;
    }

    protected String readConsole(String message, String defaultValue, Object ... objects) {
        String answer;
        Console console = System.console();
        if (console == null || StringUtils.isEmpty((String)(answer = console.readLine(message, objects)))) {
            answer = defaultValue;
        }
        if ("yes".equals(answer = answer.trim().toLowerCase()) || "y".equals(answer)) {
            return "true";
        }
        return "false";
    }

    protected boolean pkgUpgradeByType(PackageType type) {
        List upgrades = NuxeoConnectClient.getPackageManager().listUpdatePackages(type, this.targetPlatform);
        ArrayList<String> upgradeIds = new ArrayList<String>();
        for (DownloadablePackage upgrade : upgrades) {
            upgradeIds.add(upgrade.getId());
        }
        return this.pkgRequest(null, upgradeIds, null, null);
    }

    public boolean pkgHotfix() {
        return this.pkgUpgradeByType(PackageType.HOT_FIX);
    }

    public boolean pkgUpgrade() {
        return this.pkgUpgradeByType(PackageType.ADDON);
    }

    public void setRelax(String relaxValue) {
        if (relaxValue != null) {
            this.relax = relaxValue;
        }
    }

    public void setAccept(String acceptValue) {
        if (acceptValue != null) {
            this.accept = acceptValue;
            if (!"false".equalsIgnoreCase(acceptValue)) {
                this.setRelax(acceptValue);
            }
        }
    }
}

