/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher.gui;

import java.awt.Color;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.rtf.RTFEditorKit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ColoredTextPane
extends JTextPane {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ColoredTextPane.class);
    private SimpleAttributeSet style = new SimpleAttributeSet();
    private Document doc;
    private int maxSize = 0;
    private boolean follow = true;

    public boolean isFollow() {
        return this.follow;
    }

    public void setFollow(boolean follow) {
        this.follow = follow;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public ColoredTextPane() {
        this.setContentType("text/rtf");
        this.setEditorKit(new RTFEditorKit());
        this.doc = this.getDocument();
    }

    public void append(String text, Color color, Color bgColor, boolean isBold) {
        StyleConstants.setForeground(this.style, color);
        StyleConstants.setBackground(this.style, bgColor);
        StyleConstants.setBold(this.style, isBold);
        int len = this.doc.getLength();
        try {
            this.doc.insertString(len, text + "\n", this.style);
            if (this.maxSize > 0 && len > this.maxSize) {
                this.doc.remove(0, len - this.maxSize);
            }
        }
        catch (BadLocationException e) {
            log.error((Object)e);
        }
        if (this.follow) {
            this.setCaretPosition(this.doc.getLength());
        }
    }

    public void append(String text) {
        this.append(text, Color.WHITE);
    }

    public void append(String text, Color color) {
        this.append(text, color, this.getBackground(), false);
    }

    public void append(String text, Color color, boolean isBold) {
        this.append(text, color, this.getBackground(), isBold);
    }
}

