/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher.gui;

import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.FileChangeEvent;
import org.apache.commons.vfs2.FileListener;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.impl.DefaultFileMonitor;
import org.artofsolving.jodconverter.util.PlatformUtils;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.launcher.NuxeoLauncher;
import org.nuxeo.launcher.config.ConfigurationGenerator;
import org.nuxeo.launcher.daemon.DaemonThreadFactory;
import org.nuxeo.launcher.gui.ColoredTextPane;
import org.nuxeo.launcher.gui.NuxeoFrame;
import org.nuxeo.launcher.gui.logs.LogsHandler;
import org.nuxeo.launcher.gui.logs.LogsSource;
import org.nuxeo.launcher.gui.logs.LogsSourceThread;

public class NuxeoLauncherGUI {
    static final Log log = LogFactory.getLog(NuxeoLauncherGUI.class);
    protected static final long UPDATE_FREQUENCY = 3000L;
    private ExecutorService executor = this.newExecutor();
    protected NuxeoLauncher launcher;
    protected NuxeoFrame nuxeoFrame;
    protected HashMap<String, LogsSourceThread> logsMap = new HashMap();
    private DefaultFileMonitor dumpedConfigMonitor;
    private Thread nuxeoFrameUpdater;

    protected ExecutorService newExecutor() {
        return Executors.newCachedThreadPool(new DaemonThreadFactory("NuxeoLauncherGUITask"));
    }

    public final HashMap<String, LogsSourceThread> getLogsMap() {
        return this.logsMap;
    }

    public NuxeoLauncherGUI(NuxeoLauncher aLauncher) {
        this.launcher = aLauncher;
        if (PlatformUtils.isMac()) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.growbox.intrudes", "false");
            System.setProperty("com.apple.mrj.application.live-resize", "true");
            System.setProperty("com.apple.macos.smallTabs", "true");
        }
        this.initFrame();
        this.dumpedConfigMonitor = new DefaultFileMonitor(new FileListener(){

            public void fileDeleted(FileChangeEvent event) {
            }

            public void fileCreated(FileChangeEvent event) {
                this.updateNuxeoFrame();
            }

            public void fileChanged(FileChangeEvent event) {
                this.updateNuxeoFrame();
            }

            private synchronized void updateNuxeoFrame() {
                NuxeoLauncherGUI.this.waitForFrameLoaded();
                log.debug((Object)"Configuration changed. Reloading frame...");
                NuxeoLauncherGUI.this.launcher.init();
                NuxeoLauncherGUI.this.updateServerStatus();
                try {
                    Properties props = new Properties();
                    props.load(new FileReader(NuxeoLauncherGUI.this.getConfigurationGenerator().getDumpedConfig()));
                    NuxeoLauncherGUI.this.nuxeoFrame.updateLogsTab(props.getProperty("log.id"));
                }
                catch (IOException e) {
                    log.error((Object)e);
                }
            }
        });
        try {
            this.dumpedConfigMonitor.setRecursive(false);
            FileObject dumpedConfig = VFS.getManager().resolveFile(this.getConfigurationGenerator().getDumpedConfig().getPath());
            this.dumpedConfigMonitor.addFile(dumpedConfig);
            this.dumpedConfigMonitor.start();
        }
        catch (FileSystemException e) {
            throw new RuntimeException("Couldn't find " + this.getConfigurationGenerator().getNuxeoConf(), e);
        }
    }

    protected void initFrame() {
        final NuxeoLauncherGUI controller = this;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    if (NuxeoLauncherGUI.this.nuxeoFrame != null) {
                        NuxeoLauncherGUI.this.executor.shutdownNow();
                        NuxeoLauncherGUI.this.nuxeoFrame.close();
                        NuxeoLauncherGUI.this.executor = NuxeoLauncherGUI.this.newExecutor();
                    }
                    NuxeoLauncherGUI.this.nuxeoFrame = NuxeoLauncherGUI.this.createNuxeoFrame(controller);
                    NuxeoLauncherGUI.this.nuxeoFrame.pack();
                    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                    NuxeoLauncherGUI.this.nuxeoFrame.setLocation(screenSize.width / 2 - NuxeoLauncherGUI.this.nuxeoFrame.getWidth() / 2, screenSize.height / 2 - NuxeoLauncherGUI.this.nuxeoFrame.getHeight() / 2);
                    NuxeoLauncherGUI.this.nuxeoFrame.setVisible(true);
                }
                catch (HeadlessException e) {
                    log.error((Object)e);
                }
            }
        });
        if (this.nuxeoFrameUpdater == null) {
            this.nuxeoFrameUpdater = new Thread(){

                @Override
                public void run() {
                    while (true) {
                        NuxeoLauncherGUI.this.updateServerStatus();
                        try {
                            Thread.sleep(3000L);
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                    }
                }
            };
            this.nuxeoFrameUpdater.start();
        }
    }

    protected NuxeoFrame createNuxeoFrame(NuxeoLauncherGUI controller) {
        return new NuxeoFrame(controller);
    }

    public void initLogsManagement(String logFile, ColoredTextPane textArea) {
        File file = new File(logFile);
        LogsSource logsSource = new LogsSource(file);
        logsSource.skip(file.length() - 200000L);
        logsSource.addObserver(new LogsHandler(textArea));
        LogsSourceThread logsSourceThread = new LogsSourceThread(logsSource);
        logsSourceThread.setDaemon(true);
        this.executor.execute(logsSourceThread);
        this.logsMap.put(logFile, logsSourceThread);
    }

    public void stop() {
        this.waitForFrameLoaded();
        this.nuxeoFrame.stopping = true;
        this.nuxeoFrame.mainButton.setText(NuxeoLauncherGUI.getMessage("mainbutton.stop.inprogress"));
        this.nuxeoFrame.mainButton.setToolTipText(NuxeoLauncherGUI.getMessage("mainbutton.stop.tooltip"));
        this.nuxeoFrame.mainButton.setIcon(this.nuxeoFrame.stopIcon);
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                NuxeoLauncherGUI.this.launcher.stop();
                NuxeoLauncherGUI.this.nuxeoFrame.stopping = false;
                NuxeoLauncherGUI.this.updateServerStatus();
            }
        });
    }

    public void updateServerStatus() {
        this.waitForFrameLoaded();
        this.nuxeoFrame.updateMainButton();
        this.nuxeoFrame.updateLaunchBrowserButton();
        this.nuxeoFrame.updateSummary();
    }

    public void waitForFrameLoaded() {
        while (this.nuxeoFrame == null) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                log.error((Object)e);
            }
        }
    }

    public void start() {
        this.waitForFrameLoaded();
        this.nuxeoFrame.stopping = false;
        this.nuxeoFrame.mainButton.setText(NuxeoLauncherGUI.getMessage("mainbutton.start.inprogress"));
        this.nuxeoFrame.mainButton.setToolTipText(NuxeoLauncherGUI.getMessage("mainbutton.stop.tooltip"));
        this.nuxeoFrame.mainButton.setIcon(this.nuxeoFrame.stopIcon);
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    NuxeoLauncherGUI.this.launcher.doStartAndWait();
                }
                catch (PackageException e) {
                    log.error((Object)"Could not initialize the packaging subsystem", (Throwable)e);
                    System.exit(1);
                }
                NuxeoLauncherGUI.this.updateServerStatus();
            }
        });
    }

    public void notifyLogsObserver(String logFile, boolean isActive) {
        LogsSourceThread logsSourceThread = this.logsMap.get(logFile);
        if (isActive) {
            logsSourceThread.getSource().resume();
        } else {
            logsSourceThread.getSource().pause();
        }
    }

    public ConfigurationGenerator getConfigurationGenerator() {
        return this.launcher.getConfigurationGenerator();
    }

    public static String getMessage(String key) {
        String message;
        try {
            message = ResourceBundle.getBundle("i18n/messages").getString(key);
        }
        catch (MissingResourceException e) {
            log.debug((Object)(NuxeoLauncherGUI.getMessage("missing.translation") + key));
            message = ResourceBundle.getBundle("i18n/messages", Locale.ENGLISH).getString(key);
        }
        return message;
    }

    public static String getMessage(String key, Object ... params) {
        return MessageFormat.format(NuxeoLauncherGUI.getMessage(key), params);
    }

    public NuxeoLauncher getLauncher() {
        return this.launcher;
    }
}

