/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher.process;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.nuxeo.launcher.process.ProcessManager;

public class UnixProcessManager
implements ProcessManager {
    protected static final boolean PID_ENABLED = true;
    private static final Pattern PS_OUTPUT_LINE = Pattern.compile("^\\s*(\\d+)\\s+(.*)$");

    protected String[] psCommand() {
        return new String[]{"/bin/ps", "-e", "-o", "pid,args"};
    }

    @Override
    public String findPid(String regex) throws IOException {
        Pattern commandPattern = Pattern.compile(regex);
        for (String line : this.execute(this.psCommand())) {
            String command;
            Matcher commandMatcher;
            Matcher lineMatcher = PS_OUTPUT_LINE.matcher(line);
            if (!lineMatcher.matches() || !(commandMatcher = commandPattern.matcher(command = lineMatcher.group(2))).find()) continue;
            return lineMatcher.group(1);
        }
        return null;
    }

    @Override
    public void kill(Process process, String pid) throws IOException {
        this.execute("/bin/kill", "-KILL", pid);
    }

    private List<String> execute(String ... command) throws IOException {
        Process process = new ProcessBuilder(command).start();
        List lines = IOUtils.readLines((InputStream)process.getInputStream());
        return lines;
    }

    @Override
    public boolean canFindPid() {
        return true;
    }
}

