/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.segment.io;

import com.github.segmentio.Analytics;
import com.github.segmentio.AnalyticsClient;
import com.github.segmentio.flush.Flusher;
import com.github.segmentio.models.BasePayload;
import com.github.segmentio.models.Group;
import com.github.segmentio.models.Options;
import com.github.segmentio.models.Props;
import com.github.segmentio.models.Traits;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.segment.io.SegmentIO;
import org.nuxeo.segment.io.SegmentIOConfig;
import org.nuxeo.segment.io.SegmentIODataWrapper;
import org.nuxeo.segment.io.SegmentIOIntegrations;
import org.nuxeo.segment.io.SegmentIOMapper;
import org.nuxeo.segment.io.SegmentIOUserFilter;
import org.osgi.framework.Bundle;

public class SegmentIOComponent
extends DefaultComponent
implements SegmentIO {
    protected static Log log = LogFactory.getLog(SegmentIOComponent.class);
    protected static final String DEFAULT_DEBUG_KEY = "FakeKey_ChangeMe";
    public static final String WRITE_KEY = "segment.io.write.key";
    public static final String CONFIG_EP = "config";
    public static final String MAPPER_EP = "mapper";
    public static final String INTEGRATIONS_EP = "integrations";
    public static final String FILTERS_EP = "filters";
    protected boolean debugMode = false;
    protected Map<String, SegmentIOMapper> mappers;
    protected Map<String, List<SegmentIOMapper>> event2Mappers = new HashMap<String, List<SegmentIOMapper>>();
    protected List<Map<String, Object>> testData = new LinkedList<Map<String, Object>>();
    protected SegmentIOConfig config;
    protected SegmentIOIntegrations integrationsConfig;
    protected SegmentIOUserFilter userFilters;
    protected Bundle bundle;
    protected Flusher flusher;

    public Bundle getBundle() {
        return this.bundle;
    }

    public void activate(ComponentContext context) {
        this.bundle = context.getRuntimeContext().getBundle();
        this.mappers = new HashMap<String, SegmentIOMapper>();
    }

    public void deactivate(ComponentContext context) {
        this.flush();
        this.bundle = null;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (CONFIG_EP.equalsIgnoreCase(extensionPoint)) {
            this.config = (SegmentIOConfig)contribution;
        } else if (MAPPER_EP.equalsIgnoreCase(extensionPoint)) {
            SegmentIOMapper mapper = (SegmentIOMapper)contribution;
            this.mappers.put(mapper.name, mapper);
        } else if (INTEGRATIONS_EP.equalsIgnoreCase(extensionPoint)) {
            this.integrationsConfig = (SegmentIOIntegrations)contribution;
        } else if (FILTERS_EP.equalsIgnoreCase(extensionPoint)) {
            this.userFilters = (SegmentIOUserFilter)contribution;
        }
    }

    public void applicationStarted(ComponentContext context) {
        String key = this.getWriteKey();
        if (DEFAULT_DEBUG_KEY.equals(key)) {
            log.info((Object)"Run Segment.io in debug mode : nothing will be sent to the server");
            this.debugMode = true;
        } else {
            Analytics.initialize((String)key);
        }
        this.computeEvent2Mappers();
    }

    protected void computeEvent2Mappers() {
        this.event2Mappers = new HashMap<String, List<SegmentIOMapper>>();
        for (SegmentIOMapper mapper : this.mappers.values()) {
            for (String event : mapper.events) {
                List<SegmentIOMapper> m4event = this.event2Mappers.get(event);
                if (m4event == null) {
                    this.event2Mappers.put(event, new ArrayList());
                    m4event = this.event2Mappers.get(event);
                }
                if (m4event.contains(mapper)) continue;
                m4event.add(mapper);
            }
        }
    }

    @Override
    public String getWriteKey() {
        if (this.config != null && this.config.writeKey != null) {
            return this.config.writeKey;
        }
        return Framework.getProperty((String)WRITE_KEY, (String)DEFAULT_DEBUG_KEY);
    }

    @Override
    public Map<String, String> getGlobalParameters() {
        if (this.config != null && this.config.parameters != null) {
            return this.config.parameters;
        }
        return new HashMap<String, String>();
    }

    protected Flusher getFlusher() {
        if (this.flusher == null) {
            try {
                AnalyticsClient client = Analytics.getDefaultClient();
                Field field = client.getClass().getDeclaredField("flusher");
                field.setAccessible(true);
                this.flusher = (Flusher)field.get(client);
            }
            catch (ReflectiveOperationException e) {
                log.error((Object)"Unable to access SegmentIO Flusher via reflection", (Throwable)e);
            }
        }
        return this.flusher;
    }

    @Override
    public void identify(NuxeoPrincipal principal) {
        this.identify(principal, null);
    }

    @Override
    public Map<String, Boolean> getIntegrations() {
        if (this.integrationsConfig != null && this.integrationsConfig.integrations != null) {
            return this.integrationsConfig.integrations;
        }
        return new HashMap<String, Boolean>();
    }

    protected Options buildOptions() {
        Options options = new Options();
        for (Map.Entry<String, Boolean> integration : this.getIntegrations().entrySet()) {
            options.setIntegration(integration.getKey(), integration.getValue().booleanValue());
        }
        return options.setTimestamp(new DateTime());
    }

    @Override
    public void identify(NuxeoPrincipal principal, Map<String, Serializable> metadata) {
        SegmentIODataWrapper wrapper = new SegmentIODataWrapper(principal, metadata);
        if (!this.mustTrackprincipal(wrapper.getUserId())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Skip user " + principal.getName()));
            }
            return;
        }
        if (this.debugMode) {
            if (log.isInfoEnabled()) {
                log.info((Object)("send identify for " + wrapper.getUserId() + " with meta : " + metadata.toString()));
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("send identify with " + metadata.toString()));
            }
            Traits traits = new Traits();
            traits.putAll(wrapper.getMetadata());
            Options options = this.buildOptions();
            if (Framework.isTestModeSet()) {
                this.pushForTest("identify", wrapper.getUserId(), (Map<String, Object>)traits, options);
            } else {
                Analytics.getDefaultClient().identify(wrapper.getUserId(), traits, options);
            }
            Map<String, Serializable> groupMeta = wrapper.getGroupMetadata();
            if (groupMeta.size() > 0 && groupMeta.containsKey("id")) {
                Traits gtraits = new Traits();
                gtraits.putAll(groupMeta);
                this.group((String)((Object)groupMeta.get("id")), wrapper.getUserId(), gtraits, options);
            } else if (principal.getCompany() != null) {
                this.group(principal.getCompany(), wrapper.getUserId(), null, options);
            } else if (wrapper.getMetadata().get("company") != null) {
                this.group((String)((Object)wrapper.getMetadata().get("company")), wrapper.getUserId(), null, options);
            }
        }
    }

    protected void group(String groupId, String userId, Traits traits, Options options) {
        if (groupId == null || groupId.isEmpty()) {
            return;
        }
        if (Framework.isTestModeSet()) {
            this.pushForTest("group", userId, (Map<String, Object>)traits, options);
        } else {
            Flusher flusher = this.getFlusher();
            if (flusher != null) {
                Group grp = new Group(userId, groupId, traits, options);
                flusher.enqueue((BasePayload)grp);
            } else {
                log.warn((Object)"Can not use Group API");
            }
        }
    }

    protected Map<String, Object> pushForTest(String action, String userId, Map<String, Object> metadata, Options options) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("action", action);
        data.put("principal", userId);
        if (metadata != null) {
            data.putAll(metadata);
        }
        if (options != null) {
            data.put("options", options);
        }
        this.testData.add(data);
        return data;
    }

    protected void pushForTest(String action, String userId, String eventName, Map<String, Object> metadata, Options options) {
        Map<String, Object> data = this.pushForTest(action, userId, metadata, options);
        data.put("eventName", eventName);
    }

    public List<Map<String, Object>> getTestData() {
        return this.testData;
    }

    protected boolean mustTrackprincipal(String principalName) {
        SegmentIOUserFilter filter = this.getUserFilters();
        if (filter == null) {
            return true;
        }
        return filter.canTrack(principalName);
    }

    @Override
    public void track(NuxeoPrincipal principal, String eventName) {
        this.track(principal, null);
    }

    @Override
    public void track(NuxeoPrincipal principal, String eventName, Map<String, Serializable> metadata) {
        SegmentIODataWrapper wrapper = new SegmentIODataWrapper(principal, metadata);
        if (!this.mustTrackprincipal(wrapper.getUserId())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Skip user " + principal.getName()));
            }
            return;
        }
        if (this.debugMode) {
            if (log.isInfoEnabled()) {
                log.info((Object)("send track for " + eventName + " user : " + wrapper.getUserId() + " with meta : " + metadata.toString()));
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("send track with " + metadata.toString()));
            }
            Props eventProperties = new Props();
            eventProperties.putAll(wrapper.getMetadata());
            if (Framework.isTestModeSet()) {
                this.pushForTest("track", wrapper.getUserId(), eventName, (Map<String, Object>)eventProperties, this.buildOptions());
            } else {
                Analytics.getDefaultClient().track(wrapper.getUserId(), eventName, eventProperties, this.buildOptions());
            }
        }
    }

    @Override
    public void flush() {
        if (!this.debugMode) {
            Analytics.flush();
        }
    }

    @Override
    public Map<String, List<SegmentIOMapper>> getMappers(List<String> events) {
        HashMap<String, List<SegmentIOMapper>> targetMappers = new HashMap<String, List<SegmentIOMapper>>();
        for (String event : events) {
            if (!this.event2Mappers.containsKey(event)) continue;
            targetMappers.put(event, this.event2Mappers.get(event));
        }
        return targetMappers;
    }

    @Override
    public Set<String> getMappedEvents() {
        return this.event2Mappers.keySet();
    }

    @Override
    public Map<String, List<SegmentIOMapper>> getAllMappers() {
        return this.event2Mappers;
    }

    @Override
    public SegmentIOUserFilter getUserFilters() {
        return this.userFilters;
    }

    @Override
    public boolean isDebugMode() {
        return this.debugMode;
    }
}

