/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.segment.io;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

@XObject(value="userFilter")
public class SegmentIOUserFilter {
    @XNode(value="enableAnonymous")
    protected boolean enableAnonymous = false;
    @XNodeList(value="blackListedUser", type=ArrayList.class, componentType=String.class)
    protected List<String> blackListedUsers;
    protected String anonymousUserId = null;

    public boolean isEnableAnonymous() {
        return this.enableAnonymous;
    }

    public List<String> getBlackListedUsers() {
        return this.blackListedUsers;
    }

    public String getAnonymousUserId() {
        if (this.anonymousUserId == null) {
            UserManager um = (UserManager)Framework.getService(UserManager.class);
            if (um == null && Framework.isTestModeSet()) {
                return "Guest";
            }
            this.anonymousUserId = um.getAnonymousUserId();
        }
        return this.anonymousUserId;
    }

    public boolean canTrack(String principalName) {
        if (!this.enableAnonymous && principalName.equals(this.getAnonymousUserId())) {
            return false;
        }
        return this.blackListedUsers == null || !this.blackListedUsers.contains(principalName);
    }
}

