# PS Estelle

GitHub repository used by Estelle for testing PS projects packaging


## Links

OpenShift Continuous Deployment: https://openshift.dev.nuxeo.io/console/project/ps-estelle/overview


## Requirements

This module requires Java 8 and Maven 3.

Also, make sure you are granted access to the Studio project and have provided your Github account with your SSH public key.


## Building

- Get the source code:

    `git clone git@github.com:nuxeo-projects/ps-estelle.git && cd ps-estelle`

- Make sure you entered your Nuxeo Studio credentials in `~/.m2/settings.xml` as described in the documentation [here](https://doc.nuxeo.com/studio/maven-integration/).

- Build using Maven:

    `mvn clean install`

(See Nuxeo [Core Developer Guide](http://doc.nuxeo.com/x/B4BH) for more instructions and guidelines).


## Getting started

- Download a Nuxeo Platform distribution 9.10 [here](http://community.nuxeo.com/static/releases/nuxeo-9.10/nuxeo-server-9.10-tomcat.zip).

- Set `$NUXEO_HOME` variable to this distribution:

    `export NUXEO_HOME={{path-to-distrib}} && export NUXEO_CONF=$NUXEO_HOME/bin/nuxeo.conf && cd $NUXEO_HOME`

- Install the hotfixes:

    `./bin/nuxeoctl mp-hotfix`

- Register the instance with your Nuxeo Connect account to the Nuxeo Studio project:

    `./bin/nuxeoctl register`

- Install the PS Estelle Marketplace package:

    `./bin/nuxeoctl mp-install ps-estelle-marketplace`

- Launch the server:

    `./bin/nuxeoctl start`

- Go to http://localhost:8080/nuxeo.

- Fill in the wizard with the wanted configuration. Your instance should already be registered to the Nuxeo Studio project.

You should now be able to browse the Nuxeo PS Estelle Application :-)

- To stop the server, run:

    `./bin/nuxeoctl stop`

- To start the server in a console mode and see the logs, run:

    `./bin/nuxeoctl console`


## Hierarchy of the project

- `ps-estelle-core`: The Nuxeo module for the core logic.

- `ps-estelle-marketplace`: The Nuxeo marketplace package .


## Licensing

(C) Copyright [Nuxeo SA](http://nuxeo.com/) and others.

All rights reserved.


## About Nuxeo

Nuxeo dramatically improves how content-based applications are built, managed and deployed, making customers more agile, innovative and successful. Nuxeo provides a next generation, enterprise ready platform for building traditional and cutting-edge content oriented applications. Combining a powerful application development environment with SaaS-based tools and a modular architecture, the Nuxeo Platform and Products provide clear business value to some of the most recognizable brands including Verizon, Electronic Arts, Sharp, FICO, the U.S. Navy, and Boeing. Nuxeo is headquartered in New York and Paris. More information is available at [www.nuxeo.com](http://www.nuxeo.com).
