/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.rss.reader;

import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.XmlReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.Base64;
import org.nuxeo.rss.reader.FeedUrlConfig;

public class FeedHelper {
    private static final Log log = LogFactory.getLog(FeedHelper.class);
    public static final int NO_LIMIT = -1;

    public static JSONObject getFeed(String feedUrl) throws Exception {
        return FeedHelper.getFeed(feedUrl, -1);
    }

    public static JSONObject getFeed(String feedUrl, int limit) throws Exception {
        SyndFeed feed = FeedHelper.parseFeed(feedUrl);
        return FeedHelper.buildJson(feed, limit);
    }

    public static JSONObject mergeFeeds(String[] urls) throws UnsupportedEncodingException {
        return FeedHelper.mergeFeeds(urls, -1);
    }

    public static JSONObject mergeFeeds(String[] urls, int limit) throws UnsupportedEncodingException {
        MergedEntries mergedEntries = new MergedEntries(urls, limit);
        JSONObject object = new JSONObject();
        FeedHelper.addProperty(object, Field.FEEDS, FeedHelper.buildFeedsInfoArray(mergedEntries.getFeeds()));
        FeedHelper.addProperty(object, Field.ENTRIES, FeedHelper.buildEntriesArray(mergedEntries.getEntries(), true));
        return object;
    }

    public static Map<String, Object> searchFeedEntry(String[] urls, String link) throws URISyntaxException, UnsupportedEncodingException {
        MergedEntries mergedEntries = new MergedEntries(urls, -1);
        List<SyndEntry> entries = mergedEntries.getEntries();
        HashMap<String, Object> foundEntry = new HashMap<String, Object>();
        for (int i = 0; i < entries.size(); ++i) {
            SyndEntry entry = entries.get(i);
            if (!link.equals(entry.getLink())) continue;
            foundEntry.put("entry", entry);
            if (i > 0) {
                foundEntry.put("previous", URLEncoder.encode(entries.get(i - 1).getLink(), "UTF-8"));
            }
            if (i >= entries.size() - 1) break;
            foundEntry.put("next", URLEncoder.encode(entries.get(i + 1).getLink(), "UTF-8"));
            break;
        }
        return foundEntry;
    }

    public static SyndFeed parseFeed(String feedUrl) throws Exception {
        URLConnection urlConnection;
        URL url = new URL(feedUrl);
        SyndFeedInput input = new SyndFeedInput();
        if (FeedUrlConfig.useProxy()) {
            InetSocketAddress addr = new InetSocketAddress(FeedUrlConfig.getProxyHost(), FeedUrlConfig.getProxyPort());
            Proxy proxy = new Proxy(Proxy.Type.HTTP, addr);
            urlConnection = url.openConnection(proxy);
            if (FeedUrlConfig.isProxyAuthenticated()) {
                String encoded = Base64.encodeBytes((byte[])new String(FeedUrlConfig.getProxyLogin() + ":" + FeedUrlConfig.getProxyPassword()).getBytes());
                urlConnection.setRequestProperty("Proxy-Authorization", "Basic " + encoded);
                urlConnection.connect();
            }
        } else {
            urlConnection = url.openConnection();
        }
        SyndFeed feed = input.build((Reader)new XmlReader(urlConnection));
        return feed;
    }

    private static JSONObject buildJson(SyndFeed feed, int limit) throws UnsupportedEncodingException {
        JSONObject object = new JSONObject();
        FeedHelper.addFeedInfo(object, feed);
        List entries = feed.getEntries();
        if (limit != -1 && entries.size() > limit) {
            entries = entries.subList(0, limit);
        }
        FeedHelper.addProperty(object, Field.ENTRIES, FeedHelper.buildEntriesArray(entries, false));
        return object;
    }

    private static JSONArray buildFeedsInfoArray(List<SyndFeed> feeds) {
        JSONArray array = new JSONArray();
        for (SyndFeed feed : feeds) {
            JSONObject o = new JSONObject();
            FeedHelper.addFeedInfo(o, feed);
            array.add((Object)o);
        }
        return array;
    }

    private static JSONArray buildEntriesArray(List<SyndEntry> entries, boolean addFeedInfo) throws UnsupportedEncodingException {
        JSONArray array = new JSONArray();
        for (SyndEntry entry : entries) {
            JSONObject o = new JSONObject();
            FeedHelper.addProperty(o, Field.TITLE, entry.getTitle());
            FeedHelper.addProperty(o, Field.LINK, URLEncoder.encode(entry.getLink(), "UTF-8"));
            SyndContent description = entry.getDescription();
            if (description != null) {
                String text = description.getValue();
                if ("text/html".equals(description.getType())) {
                    text = FeedHelper.extractText(text);
                }
                FeedHelper.addProperty(o, Field.DESCRIPTION, text);
            }
            if (entry.getPublishedDate() != null) {
                FeedHelper.addProperty(o, Field.PUBDATE, entry.getPublishedDate());
            }
            if (addFeedInfo) {
                FeedHelper.addFeedInfo(o, entry.getSource());
            }
            array.add((Object)o);
        }
        return array;
    }

    private static JSONObject addFeedInfo(JSONObject object, SyndFeed feed) {
        FeedHelper.addProperty(object, Field.FEED_TITLE, feed.getTitle());
        FeedHelper.addProperty(object, Field.FEED_LINK, feed.getLink());
        FeedHelper.addProperty(object, Field.FEED_DESCRIPTION, feed.getDescription());
        if (feed.getPublishedDate() != null) {
            FeedHelper.addProperty(object, Field.FEED_PUBDATE, feed.getPublishedDate());
        }
        return object;
    }

    private static void addProperty(JSONObject object, Field field, Object value) {
        object.element(field.name(), value);
    }

    private static String extractText(String html) {
        char[] characters = html.toCharArray();
        int level = 0;
        StringBuilder sb = new StringBuilder();
        block4: for (char c : characters) {
            switch (c) {
                case '<': {
                    ++level;
                    continue block4;
                }
                case '>': {
                    --level;
                    continue block4;
                }
                default: {
                    if (level != 0) continue block4;
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static class MergedEntries {
        protected List<SyndFeed> feeds = new ArrayList<SyndFeed>();
        protected List<SyndEntry> entries = new ArrayList<SyndEntry>();

        public MergedEntries(String[] urls, int limit) {
            for (String url : urls) {
                try {
                    SyndFeed feed = FeedHelper.parseFeed(url);
                    this.feeds.add(feed);
                    List list = feed.getEntries();
                    if (limit != -1 && limit < list.size()) {
                        list = list.subList(0, limit);
                    }
                    for (SyndEntry entry : list) {
                        if (entry.getSource() != null) continue;
                        entry.setSource(feed);
                    }
                    this.entries.addAll(list);
                }
                catch (Exception e) {
                    log.warn((Object)("failed to retrieve feed " + url), (Throwable)e);
                }
            }
            Collections.sort(this.entries, new Comparator<SyndEntry>(){

                @Override
                public int compare(SyndEntry o1, SyndEntry o2) {
                    Date publishedDate1 = o1.getPublishedDate();
                    Date publishedDate2 = o2.getPublishedDate();
                    if (publishedDate1 == null || publishedDate2 == null) {
                        return 0;
                    }
                    Calendar c1 = Calendar.getInstance();
                    Calendar c2 = Calendar.getInstance();
                    c1.setTime(publishedDate1);
                    c2.setTime(publishedDate2);
                    return -c1.compareTo(c2);
                }
            });
            if (limit != -1 && limit < this.entries.size()) {
                this.entries = this.entries.subList(0, limit);
            }
        }

        public List<SyndFeed> getFeeds() {
            return this.feeds;
        }

        public List<SyndEntry> getEntries() {
            return this.entries;
        }
    }

    public static enum Field {
        FEED_TITLE,
        FEED_LINK,
        FEED_DESCRIPTION,
        FEED_PUBDATE,
        TITLE,
        DESCRIPTION,
        LINK,
        PUBDATE,
        ENTRIES,
        FEEDS;

    }
}

