/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.rss.reader;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import net.sf.json.JSONObject;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.impl.blob.InputStreamBlob;
import org.nuxeo.rss.reader.FeedHelper;
import org.nuxeo.rss.reader.service.RSSFeedService;

@Operation(id="Feed.Provider", category="Execution Context", label="Parse Feed Operation", description="Parse a feed and return a JSON array with feed entries.")
public class FeedProviderOperation {
    public static final String ID = "Feed.Provider";
    public static final JSONObject EMPTY_FEED = new JSONObject();
    @Param(name="domain", required=false)
    protected String domain = "/default-domain";
    @Param(name="urls", required=false)
    protected StringList urls = null;
    @Context
    protected CoreSession session;
    @Context
    protected RSSFeedService rssFeedService;

    @OperationMethod
    public Blob run() throws Exception {
        if (this.urls == null) {
            this.urls = new StringList(this.rssFeedService.getCurrentUserRssFeedAddresses(this.session));
        }
        if (this.urls.size() == 0) {
            return this.buildBlob(EMPTY_FEED.toString());
        }
        int limit = this.rssFeedService.getDisplayedArticleCount(this.session);
        if (this.urls.size() == 1) {
            JSONObject feed = FeedHelper.getFeed((String)this.urls.get(0), limit);
            return this.buildBlob(feed.toString());
        }
        JSONObject feed = FeedHelper.mergeFeeds((String[])this.urls.toArray((Object[])new String[this.urls.size()]), limit);
        return this.buildBlob(feed.toString());
    }

    protected Blob buildBlob(String text) throws UnsupportedEncodingException {
        return new InputStreamBlob((InputStream)new ByteArrayInputStream(text.getBytes("UTF-8")), "application/json");
    }
}

