/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.rss.reader.service;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.platform.userworkspace.api.UserWorkspaceService;
import org.nuxeo.rss.reader.runner.UnrestrictedRssReaderManagementRootGenerator;
import org.nuxeo.rss.reader.service.RSSFeedService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.DefaultComponent;

public class RSSFeedComponent
extends DefaultComponent
implements RSSFeedService {
    @Override
    public DocumentModel getRssReaderManagementContainer(CoreSession session) throws ClientException {
        if (!session.exists((DocumentRef)new PathRef("/management/rssFeeds"))) {
            new UnrestrictedRssReaderManagementRootGenerator(session, "/management").runUnrestricted();
        }
        return session.getDocument((DocumentRef)new PathRef("/management/rssFeeds"));
    }

    @Override
    public DocumentModel getCurrentUserRssFeedsContainer(CoreSession session) throws ClientException {
        String userWorkspace = this.getCurrentUserWorkspace(session);
        String userRssFeedPath = userWorkspace + "/" + "rssFeeds";
        if (!session.exists((DocumentRef)new PathRef(userRssFeedPath))) {
            new UnrestrictedRssReaderManagementRootGenerator(session, userWorkspace).willSetRightsForAdminitrators(false).runUnrestricted();
            session.copy(this.getDefaultRssFeedModels(session), (DocumentRef)new PathRef(userRssFeedPath));
        }
        return session.getDocument((DocumentRef)new PathRef(userRssFeedPath));
    }

    protected String getCurrentUserWorkspace(CoreSession session) throws ClientException {
        UserWorkspaceService uws;
        String userName = session.getPrincipal().getName();
        DocumentModel root = session.getRootDocument();
        DocumentModelList list = session.getChildren(root.getRef());
        if (list.size() == 0) {
            throw new ClientException("No domain detected, we can't create or get the current UserWorkspace.");
        }
        DocumentModel currentDomain = (DocumentModel)list.get(0);
        try {
            uws = (UserWorkspaceService)Framework.getService(UserWorkspaceService.class);
        }
        catch (Exception e) {
            throw new ClientException("Can't fetch the UserWorkspace service, please check", (Throwable)e);
        }
        String userWorkspace = uws.getCurrentUserPersonalWorkspace(userName, currentDomain).getPathAsString();
        return userWorkspace;
    }

    @Override
    public int getDisplayedArticleCount(CoreSession session) throws ClientException {
        DocumentModel adminContainer = this.getRssReaderManagementContainer(session);
        return ((Long)adminContainer.getPropertyValue("rg:article_count")).intValue();
    }

    @Override
    public int getMaximumFeedsCount(CoreSession session) throws ClientException {
        DocumentModel adminContainer = this.getRssReaderManagementContainer(session);
        return ((Long)adminContainer.getPropertyValue("rg:max_feed_count")).intValue();
    }

    @Override
    public DocumentModelList getGlobalFeedsDocumentModelList(CoreSession session) throws ClientException {
        return session.getChildren(this.getRssReaderManagementContainer(session).getRef(), "RssFeed");
    }

    @Override
    public DocumentModelList getCurrentUserRssFeedDocumentModelList(CoreSession session) throws ClientException {
        return session.getChildren(this.getCurrentUserRssFeedsContainer(session).getRef());
    }

    @Override
    public List<String> getCurrentUserRssFeedAddresses(CoreSession session) throws ClientException {
        ArrayList<String> addresses = new ArrayList<String>();
        for (DocumentModel dc : this.getCurrentUserRssFeedDocumentModelList(session)) {
            addresses.add(dc.getPropertyValue("rf:rss_address").toString());
        }
        return addresses;
    }

    protected List<DocumentRef> getDefaultRssFeedModels(CoreSession session) throws ClientException {
        ArrayList<DocumentRef> defaultFeeds = new ArrayList<DocumentRef>();
        DocumentModelList docs = this.getGlobalFeedsDocumentModelList(session);
        for (DocumentModel doc : docs) {
            if (!Boolean.TRUE.equals(doc.getPropertyValue("rf:is_default_feed"))) continue;
            defaultFeeds.add(doc.getRef());
        }
        return defaultFeeds;
    }
}

