/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.rss.reader.manager.seam;

import java.io.Serializable;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.core.Events;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.webapp.base.InputController;
import org.nuxeo.ecm.webapp.helpers.EventManager;
import org.nuxeo.rss.reader.service.RSSFeedService;

@Name(value="rssGadgetPreferenceActions")
@Scope(value=ScopeType.PAGE)
@Install(precedence=10)
public class RssGadgetPreferenceActions
extends InputController
implements Serializable {
    private static final long serialVersionUID = -1L;
    @In(create=true)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected transient RSSFeedService rssFeed;
    protected DocumentModel preference = null;
    protected boolean showForm = false;

    public boolean isShowForm() {
        return this.showForm;
    }

    public void toggleForm() {
        this.showForm = !this.showForm;
        this.preference = null;
    }

    public DocumentModel getPreference() throws ClientException {
        if (this.preference == null) {
            this.preference = this.rssFeed.getRssReaderManagementContainer(this.documentManager);
        }
        return this.preference;
    }

    public String getRssReaderManagementContainerPath() throws ClientException {
        return this.rssFeed.getRssReaderManagementContainer(this.documentManager).getPathAsString();
    }

    public void saveDocument() throws ClientException {
        Events.instance().raiseEvent("beforeDocumentChanged", new Object[]{this.getPreference()});
        this.preference = this.documentManager.saveDocument(this.getPreference());
        this.documentManager.save();
        this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get("document_modified"), new Object[]{this.resourcesAccessor.getMessages().get(this.getPreference().getType())});
        EventManager.raiseEventsOnDocumentChange((DocumentModel)this.getPreference());
        this.toggleForm();
    }

    public void reset() {
        this.preference = null;
    }
}

