/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.rss.reader;

import org.nuxeo.runtime.api.Framework;

public class FeedUrlConfig {
    public static final String FEED_PROXY_HOST_PROPERTY = "org.nuxeo.rss.reader.proxy.host";
    public static final String FEED_PROXY_PORT_PROPERTY = "org.nuxeo.rss.reader.proxy.port";
    public static final String FEED_PROXY_LOGIN_PROPERTY = "org.nuxeo.rss.reader.proxy.login";
    public static final String FEED_PROXY_PASSWORD_PROPERTY = "org.nuxeo.rss.reader.proxy.password";
    public static final String NUXEO_PROXY_HOST_PROPERTY = "nuxeo.http.proxy.host";
    public static final String NUXEO_PROXY_PORT_PROPERTY = "nuxeo.http.proxy.port";
    public static final String NUXEO_PROXY_LOGIN_PROPERTY = "nuxeo.http.proxy.login";
    public static final String NUXEO_PROXY_PASSWORD_PROPERTY = "nuxeo.http.proxy.password";
    protected static Boolean useProxy = null;
    protected static Boolean isProxyAuthenticated = null;

    public static boolean useProxy() {
        if (useProxy == null) {
            String host = FeedUrlConfig.getProxyHost();
            useProxy = host == null || host.isEmpty() || host.startsWith("$") ? Boolean.valueOf(false) : Boolean.valueOf(true);
        }
        return useProxy;
    }

    public static boolean isProxyAuthenticated() {
        if (isProxyAuthenticated == null) {
            String login = FeedUrlConfig.getProxyLogin();
            isProxyAuthenticated = login == null || login.isEmpty() || login.startsWith("$") ? Boolean.valueOf(false) : Boolean.valueOf(true);
        }
        return isProxyAuthenticated;
    }

    public static String getProxyHost() {
        return Framework.getProperty((String)FEED_PROXY_HOST_PROPERTY, (String)Framework.getProperty((String)NUXEO_PROXY_HOST_PROPERTY, null));
    }

    public static int getProxyPort() {
        String portAsString = Framework.getProperty((String)FEED_PROXY_PORT_PROPERTY, (String)Framework.getProperty((String)NUXEO_PROXY_PORT_PROPERTY, null));
        if (portAsString == null || portAsString.isEmpty() || portAsString.startsWith("$")) {
            return 80;
        }
        try {
            return Integer.parseInt(portAsString);
        }
        catch (NumberFormatException e) {
            return 80;
        }
    }

    public static String getProxyLogin() {
        return Framework.getProperty((String)FEED_PROXY_LOGIN_PROPERTY, (String)Framework.getProperty((String)NUXEO_PROXY_LOGIN_PROPERTY, null));
    }

    public static String getProxyPassword() {
        return Framework.getProperty((String)FEED_PROXY_PASSWORD_PROPERTY, (String)Framework.getProperty((String)NUXEO_PROXY_PASSWORD_PROPERTY, null));
    }
}

