/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.task.update;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.nuxeo.common.utils.FileVersion;
import org.nuxeo.connect.update.task.update.UpdateOptions;
import org.nuxeo.connect.update.task.update.Version;
import org.nuxeo.connect.update.task.update.VersionAlreadyExistException;

public class Entry
implements Iterable<Version> {
    protected String key;
    protected Version baseVersion;
    protected List<Version> versions;

    public Entry(String key) {
        this.key = key;
        this.versions = new ArrayList<Version>();
    }

    public final boolean isEmpty() {
        return this.versions.isEmpty();
    }

    public final Version getFirstVersion() {
        return this.versions.isEmpty() ? null : this.versions.get(0);
    }

    public final Version getLastVersion() {
        return this.versions.isEmpty() ? null : this.versions.get(this.versions.size() - 1);
    }

    public Version getLastVersion(boolean includeUpgradeOnly) {
        if (includeUpgradeOnly) {
            return this.getLastVersion();
        }
        for (int i = this.versions.size() - 1; i >= 0; --i) {
            for (UpdateOptions opt : this.versions.get((int)i).packages.values()) {
                if (opt.upgradeOnly) continue;
                return this.versions.get(i);
            }
        }
        return null;
    }

    public final String getKey() {
        return this.key;
    }

    public final void setBaseVersion(Version baseVersion) {
        this.baseVersion = baseVersion;
    }

    public final boolean hasBaseVersion() {
        return this.baseVersion != null;
    }

    public final Version getBaseVersion() {
        return this.baseVersion;
    }

    public final boolean isLastVersion(Version v) {
        return v == this.getLastVersion();
    }

    public boolean removeVersion(Version version) {
        return this.versions.remove(version);
    }

    public Version addVersion(Version version) {
        if (this.versions.contains(version)) {
            throw new VersionAlreadyExistException(version.getVersion());
        }
        this.versions.add(version);
        return version;
    }

    public Version getVersion(String version) {
        for (Version v : this.versions) {
            String ov = v.getVersion();
            if ((ov == null || !ov.equals(version)) && (ov != null || version != null)) continue;
            return v;
        }
        return null;
    }

    public Version getGreatestVersion() {
        Version result = null;
        FileVersion fv = null;
        for (Version v : this.versions) {
            if (result == null) {
                result = v;
                fv = v.getFileVersion();
                continue;
            }
            FileVersion fv2 = v.getFileVersion();
            if (!fv.lessThan(fv2)) continue;
            result = v;
            fv = fv2;
        }
        return result;
    }

    public Version getOrCreateVersion(String version) {
        Version v = this.getVersion(version);
        if (v == null) {
            return this.addVersion(new Version(version));
        }
        return v;
    }

    public List<Version> getVersions() {
        return this.versions;
    }

    @Override
    public Iterator<Version> iterator() {
        return this.versions.iterator();
    }

    public String toString() {
        return this.key;
    }
}

