/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.standalone.commands;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Before;
import org.nuxeo.common.Environment;
import org.nuxeo.connect.update.standalone.commands.AbstractCommandTest;
import org.nuxeo.connect.update.task.Task;

public class TestUpdate
extends AbstractCommandTest {
    private File oldJar;
    private File expectedJar;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        File bundles = new File(Environment.getDefault().getHome(), "bundles");
        this.oldJar = new File(bundles, "foo-1.0.jar");
        FileUtils.writeStringToFile((File)this.oldJar, (String)"old JAR content");
        this.expectedJar = new File(bundles, "foo-1.1.jar");
    }

    @Override
    protected File createPackage() throws IOException, URISyntaxException {
        return this.getTestPackageZip("test-update");
    }

    @Override
    protected void installDone(Task task, Throwable error) throws Exception {
        super.installDone(task, error);
        Assert.assertFalse((boolean)this.oldJar.exists());
        Assert.assertTrue((boolean)this.expectedJar.exists());
    }

    @Override
    protected void uninstallDone(Task task, Throwable error) throws Exception {
        super.uninstallDone(task, error);
        Assert.assertTrue((boolean)this.oldJar.exists());
        Assert.assertFalse((boolean)this.expectedJar.exists());
    }
}

