/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher.connect;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.AbstractHandler;
import org.nuxeo.common.Environment;
import org.nuxeo.common.utils.ZipUtils;
import org.nuxeo.connect.NuxeoConnectClient;
import org.nuxeo.connect.connector.ConnectConnector;
import org.nuxeo.connect.update.PackageState;
import org.nuxeo.launcher.connect.ConnectBroker;
import org.nuxeo.launcher.connect.StandaloneCallbackHolder;
import org.nuxeo.launcher.connect.fake.LocalConnectFakeConnector;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.Jetty;
import org.nuxeo.runtime.test.runner.JettyFeature;
import org.nuxeo.runtime.test.runner.LogCaptureFeature;

@RunWith(value=FeaturesRunner.class)
@Features(value={LogCaptureFeature.class, JettyFeature.class})
@Jetty(port=8082)
public class TestConnectBroker {
    final String TEST_STORE_PATH = "src/test/resources/packages/store";
    final String TEST_LOCAL_ONLY_PATH = "src/test/resources/packages/store/local-only";
    final File testStore = new File("src/test/resources/packages/store");
    final File nuxeoHome = new File("target/launcher");
    @Inject
    Server server;
    @Inject
    LogCaptureFeature.Result logCaptureResult;

    @Before
    public void beforeEach() throws Exception {
        String addonJSON = FileUtils.readFileToString((File)new File(this.testStore, "addon_remote.json"));
        String hotfixJSON = FileUtils.readFileToString((File)new File(this.testStore, "hotfix_remote.json"));
        String studioJSON = FileUtils.readFileToString((File)new File(this.testStore, "studio_remote.json"));
        NuxeoConnectClient.getConnectGatewayComponent().setTestConnector((ConnectConnector)new LocalConnectFakeConnector(addonJSON, hotfixJSON, studioJSON));
        Environment.setDefault(null);
        FileUtils.deleteQuietly((File)this.nuxeoHome);
        this.nuxeoHome.mkdirs();
        System.setProperty("nuxeo.home", this.nuxeoHome.getPath());
        System.setProperty("tomcat.home", Environment.getDefault().getServerHome().getPath());
        this.buildInitialPackageStore();
        this.server.setHandler((Handler)new FakeConnectDownloadHandler());
    }

    private void buildInitialPackageStore() throws IOException {
        File nuxeoPackages = new File(this.nuxeoHome, "packages");
        File nuxeoStrore = new File(nuxeoPackages, "store");
        File uninstallFile = new File(this.testStore, "uninstall.xml");
        FileUtils.iterateFiles((File)this.testStore, (String[])new String[]{"zip"}, (boolean)false).forEachRemaining(pkgZip -> {
            try {
                File pkgDir = new File(nuxeoStrore, pkgZip.getName().replace(".zip", ""));
                ZipUtils.unzip((File)pkgZip, (File)pkgDir);
                FileUtils.copyFileToDirectory((File)uninstallFile, (File)pkgDir);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        FileUtils.copyFileToDirectory((File)new File(this.testStore, ".packages"), (File)nuxeoPackages);
    }

    @After
    public void afterEach() {
        System.clearProperty("nuxeo.home");
        System.clearProperty("tomcat.home");
    }

    @Test
    @LogCaptureFeature.FilterWith(value=PkgRequestLogFilter.class)
    public void testInstallPackageRequest() throws Exception {
        Environment.getDefault().setProperty("org.nuxeo.distribution.name", "server");
        Environment.getDefault().setProperty("org.nuxeo.distribution.version", "8.3");
        ConnectBroker connectBrocker = new ConnectBroker(Environment.getDefault());
        ((StandaloneCallbackHolder)NuxeoConnectClient.getCallBackHolder()).setTestMode(true);
        connectBrocker.setAllowSNAPSHOT(false);
        this.checkPackagesState(connectBrocker, Arrays.asList("studioA-1.0.0", "hfA-1.0.0", "A-1.0.0", "B-1.0.1-SNAPSHOT", "C-1.0.0", "D-1.0.2-SNAPSHOT"), PackageState.STARTED);
        this.checkPackagesState(connectBrocker, Arrays.asList("studioA-1.0.1", "studioA-1.0.2-SNAPSHOT", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.2.0", "A-1.2.1-SNAPSHOT", "A-1.2.2-SNAPSHOT", "A-1.2.2", "A-1.2.3-SNAPSHOT", "B-1.0.1", "B-1.0.2", "C-1.0.1-SNAPSHOT", "C-1.0.2-SNAPSHOT", "D-1.0.3-SNAPSHOT", "D-1.0.4-SNAPSHOT"), PackageState.DOWNLOADED);
        Assertions.assertThat((boolean)connectBrocker.pkgRequest(null, Arrays.asList("A-1.2.0", "B-1.0.2"), null, null, true, false)).isFalse();
        this.checkPackagesState(connectBrocker, Arrays.asList("studioA-1.0.0", "hfA-1.0.0", "A-1.0.0", "B-1.0.1-SNAPSHOT", "C-1.0.0", "D-1.0.2-SNAPSHOT"), PackageState.STARTED);
        this.checkPackagesState(connectBrocker, Arrays.asList("studioA-1.0.1", "studioA-1.0.2-SNAPSHOT", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.2.0", "A-1.2.1-SNAPSHOT", "A-1.2.2-SNAPSHOT", "A-1.2.2", "A-1.2.3-SNAPSHOT", "B-1.0.1", "B-1.0.2", "C-1.0.1-SNAPSHOT", "C-1.0.2-SNAPSHOT", "D-1.0.3-SNAPSHOT", "D-1.0.4-SNAPSHOT"), PackageState.DOWNLOADED);
        List<String> expectedLogs = Arrays.asList("org.nuxeo.connect.update.PackageException: Package(s) B-1.0.2 not available on platform version server-8.3 (relax is not allowed)");
        this.checkLogEvents(expectedLogs, this.logCaptureResult.getCaughtEvents());
        this.logCaptureResult.clear();
        connectBrocker.setRelax("true");
        Assertions.assertThat((boolean)connectBrocker.pkgRequest(null, Arrays.asList("A-1.2.0", "B-1.0.2"), null, null, true, false)).isTrue();
        this.checkPackagesState(connectBrocker, Arrays.asList("studioA-1.0.0", "hfA-1.0.0", "A-1.2.0", "B-1.0.2", "C-1.0.0", "D-1.0.2-SNAPSHOT"), PackageState.STARTED);
        this.checkPackagesState(connectBrocker, Arrays.asList("studioA-1.0.1", "studioA-1.0.2-SNAPSHOT", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.0.0", "A-1.2.1-SNAPSHOT", "A-1.2.2-SNAPSHOT", "A-1.2.2", "A-1.2.3-SNAPSHOT", "B-1.0.1-SNAPSHOT", "B-1.0.1", "C-1.0.1-SNAPSHOT", "C-1.0.2-SNAPSHOT", "D-1.0.3-SNAPSHOT", "D-1.0.4-SNAPSHOT"), PackageState.DOWNLOADED);
        expectedLogs = Arrays.asList("Relax restriction to target platform server-8.3 because of package(s) B-1.0.2", "\nDependency resolution:\n  Installation order (2):        B-1.0.2/A-1.2.0\n  Unchanged packages (7):        hfA:1.0.0, C:1.0.0, D:1.0.2-SNAPSHOT, studioA:1.0.0, G:1.0.1-SNAPSHOT, H:1.0.1-SNAPSHOT, J:1.0.1\n  Packages to upgrade (2):       A:1.0.0, B:1.0.1-SNAPSHOT\n  Local packages to install (2): A:1.2.0, B:1.0.2\n", "Uninstalling B-1.0.1-SNAPSHOT", "Uninstalling A-1.0.0", "Installing B-1.0.2", "Installing A-1.2.0");
        this.checkLogEvents(expectedLogs, this.logCaptureResult.getCaughtEvents());
        this.logCaptureResult.clear();
        Assertions.assertThat((boolean)connectBrocker.pkgRequest(null, Arrays.asList("A-1.2.2-SNAPSHOT", "C-1.0.2-SNAPSHOT", "D-1.0.4-SNAPSHOT"), null, null, true, false)).isTrue();
        this.checkPackagesState(connectBrocker, Arrays.asList("studioA-1.0.0", "hfA-1.0.0", "A-1.2.2-SNAPSHOT", "B-1.0.2", "C-1.0.2-SNAPSHOT", "D-1.0.4-SNAPSHOT"), PackageState.STARTED);
        this.checkPackagesState(connectBrocker, Arrays.asList("studioA-1.0.1", "studioA-1.0.2-SNAPSHOT", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.0.0", "A-1.2.1-SNAPSHOT", "A-1.2.0", "A-1.2.2", "A-1.2.3-SNAPSHOT", "B-1.0.1-SNAPSHOT", "B-1.0.1", "C-1.0.1-SNAPSHOT", "C-1.0.0", "D-1.0.2-SNAPSHOT", "D-1.0.3-SNAPSHOT"), PackageState.DOWNLOADED);
        expectedLogs = Arrays.asList("The following SNAPSHOT package(s) will be replaced in local cache : [A-1.2.2-SNAPSHOT, C-1.0.2-SNAPSHOT, D-1.0.4-SNAPSHOT]", "Download of 'A-1.2.2-SNAPSHOT' will replace the one already in local cache.", "Downloading [A-1.2.2-SNAPSHOT]...", "Replacement of A-1.2.2-SNAPSHOT in local cache...", "Added A-1.2.2-SNAPSHOT", "Download of 'C-1.0.2-SNAPSHOT' will replace the one already in local cache.", "Downloading [C-1.0.2-SNAPSHOT]...", "Replacement of C-1.0.2-SNAPSHOT in local cache...", "Added C-1.0.2-SNAPSHOT", "Download of 'D-1.0.4-SNAPSHOT' will replace the one already in local cache.", "Downloading [D-1.0.4-SNAPSHOT]...", "Replacement of D-1.0.4-SNAPSHOT in local cache...", "Added D-1.0.4-SNAPSHOT", "Relax restriction to target platform server-8.3 because of package(s) A-1.2.2-SNAPSHOT, C-1.0.2-SNAPSHOT, D-1.0.4-SNAPSHOT", "\nDependency resolution:\n  Installation order (3):        A-1.2.2-SNAPSHOT/D-1.0.4-SNAPSHOT/C-1.0.2-SNAPSHOT\n  Unchanged packages (6):        B:1.0.2, hfA:1.0.0, studioA:1.0.0, G:1.0.1-SNAPSHOT, H:1.0.1-SNAPSHOT, J:1.0.1\n  Packages to upgrade (3):       A:1.2.0, C:1.0.0, D:1.0.2-SNAPSHOT\n  Local packages to install (3): A:1.2.2-SNAPSHOT, C:1.0.2-SNAPSHOT, D:1.0.4-SNAPSHOT\n", "Uninstalling C-1.0.0", "Uninstalling D-1.0.2-SNAPSHOT", "Uninstalling A-1.2.0", "Installing A-1.2.2-SNAPSHOT", "Installing D-1.0.4-SNAPSHOT", "Installing C-1.0.2-SNAPSHOT");
        this.checkLogEvents(expectedLogs, this.logCaptureResult.getCaughtEvents());
    }

    @Test
    @LogCaptureFeature.FilterWith(value=PkgRequestLogFilter.class)
    public void testInstallLocalPackageRequest() throws Exception {
        Environment.getDefault().setProperty("org.nuxeo.distribution.name", "server");
        Environment.getDefault().setProperty("org.nuxeo.distribution.version", "8.3");
        ConnectBroker connectBrocker = new ConnectBroker(Environment.getDefault());
        ((StandaloneCallbackHolder)NuxeoConnectClient.getCallBackHolder()).setTestMode(true);
        connectBrocker.setAllowSNAPSHOT(false);
        this.checkPackagesState(connectBrocker, Arrays.asList("studioA-1.0.0", "hfA-1.0.0", "A-1.0.0", "B-1.0.1-SNAPSHOT", "C-1.0.0", "D-1.0.2-SNAPSHOT"), PackageState.STARTED);
        this.checkPackagesState(connectBrocker, Arrays.asList("studioA-1.0.1", "studioA-1.0.2-SNAPSHOT", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.2.0", "A-1.2.1-SNAPSHOT", "A-1.2.2-SNAPSHOT", "A-1.2.2", "A-1.2.3-SNAPSHOT", "B-1.0.1", "B-1.0.2", "C-1.0.1-SNAPSHOT", "C-1.0.2-SNAPSHOT", "D-1.0.3-SNAPSHOT", "D-1.0.4-SNAPSHOT"), PackageState.DOWNLOADED);
        Assertions.assertThat((boolean)connectBrocker.pkgRequest(null, Arrays.asList("src/test/resources/packages/store/local-only/F-1.0.0-SNAPSHOT.zip", "src/test/resources/packages/store/local-only/E-1.0.1"), null, null, true, false)).isFalse();
        this.checkPackagesState(connectBrocker, Arrays.asList("studioA-1.0.0", "hfA-1.0.0", "A-1.0.0", "B-1.0.1-SNAPSHOT", "C-1.0.0", "D-1.0.2-SNAPSHOT"), PackageState.STARTED);
        this.checkPackagesState(connectBrocker, Arrays.asList("studioA-1.0.1", "studioA-1.0.2-SNAPSHOT", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.2.0", "A-1.2.1-SNAPSHOT", "A-1.2.2-SNAPSHOT", "A-1.2.2", "A-1.2.3-SNAPSHOT", "B-1.0.1", "B-1.0.2", "C-1.0.1-SNAPSHOT", "C-1.0.2-SNAPSHOT", "D-1.0.3-SNAPSHOT", "D-1.0.4-SNAPSHOT", "E-1.0.1", "F-1.0.0-SNAPSHOT"), PackageState.DOWNLOADED);
        Assertions.assertThat((boolean)new File("src/test/resources/packages/store/local-only/F-1.0.0-SNAPSHOT.zip").exists()).isTrue();
        Assertions.assertThat((boolean)new File("src/test/resources/packages/store/local-only/E-1.0.1").exists()).isTrue();
        List<String> expectedLogs = Arrays.asList("Added src/test/resources/packages/store/local-only/F-1.0.0-SNAPSHOT.zip", "Added src/test/resources/packages/store/local-only/E-1.0.1", "org.nuxeo.connect.update.PackageException: Package(s) F-1.0.0-SNAPSHOT not available on platform version server-8.3 (relax is not allowed)");
        this.checkLogEvents(expectedLogs, this.logCaptureResult.getCaughtEvents());
        this.logCaptureResult.clear();
        connectBrocker.setRelax("true");
        Assertions.assertThat((boolean)connectBrocker.pkgRequest(null, Arrays.asList("src/test/resources/packages/store/local-only/F-1.0.0-SNAPSHOT.zip", "src/test/resources/packages/store/local-only/E-1.0.1"), null, null, true, false)).isTrue();
        this.checkPackagesState(connectBrocker, Arrays.asList("studioA-1.0.0", "hfA-1.0.0", "A-1.0.0", "B-1.0.1-SNAPSHOT", "C-1.0.0", "D-1.0.2-SNAPSHOT", "E-1.0.1", "F-1.0.0-SNAPSHOT"), PackageState.STARTED);
        this.checkPackagesState(connectBrocker, Arrays.asList("studioA-1.0.1", "studioA-1.0.2-SNAPSHOT", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.2.0", "A-1.2.1-SNAPSHOT", "A-1.2.2-SNAPSHOT", "A-1.2.2", "A-1.2.3-SNAPSHOT", "B-1.0.1", "B-1.0.2", "C-1.0.1-SNAPSHOT", "C-1.0.2-SNAPSHOT", "D-1.0.3-SNAPSHOT", "D-1.0.4-SNAPSHOT"), PackageState.DOWNLOADED);
        expectedLogs = Arrays.asList("The following SNAPSHOT package(s) will be replaced in local cache : [src/test/resources/packages/store/local-only/F-1.0.0-SNAPSHOT.zip]", "Replacement of F-1.0.0-SNAPSHOT in local cache...", "Added src/test/resources/packages/store/local-only/F-1.0.0-SNAPSHOT.zip", "Relax restriction to target platform server-8.3 because of package(s) F-1.0.0-SNAPSHOT", "\nDependency resolution:\n  Installation order (2):        E-1.0.1/F-1.0.0-SNAPSHOT\n  Unchanged packages (9):        A:1.0.0, B:1.0.1-SNAPSHOT, hfA:1.0.0, C:1.0.0, D:1.0.2-SNAPSHOT, studioA:1.0.0, G:1.0.1-SNAPSHOT, H:1.0.1-SNAPSHOT, J:1.0.1\n  Local packages to install (2): E:1.0.1, F:1.0.0-SNAPSHOT\n", "Installing E-1.0.1", "Installing F-1.0.0-SNAPSHOT");
        this.checkLogEvents(expectedLogs, this.logCaptureResult.getCaughtEvents());
    }

    @Test
    @LogCaptureFeature.FilterWith(value=PkgRequestLogFilter.class)
    public void testReInstallPackageRequest() throws Exception {
        Environment.getDefault().setProperty("org.nuxeo.distribution.name", "server");
        Environment.getDefault().setProperty("org.nuxeo.distribution.version", "8.3");
        ConnectBroker connectBrocker = new ConnectBroker(Environment.getDefault());
        ((StandaloneCallbackHolder)NuxeoConnectClient.getCallBackHolder()).setTestMode(true);
        connectBrocker.setAllowSNAPSHOT(false);
        this.checkPackagesState(connectBrocker, Arrays.asList("studioA-1.0.0", "hfA-1.0.0", "A-1.0.0", "B-1.0.1-SNAPSHOT", "C-1.0.0", "D-1.0.2-SNAPSHOT"), PackageState.STARTED);
        this.checkPackagesState(connectBrocker, Arrays.asList("studioA-1.0.1", "studioA-1.0.2-SNAPSHOT", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.2.0", "A-1.2.1-SNAPSHOT", "A-1.2.2-SNAPSHOT", "A-1.2.2", "A-1.2.3-SNAPSHOT", "B-1.0.1", "B-1.0.2", "C-1.0.1-SNAPSHOT", "C-1.0.2-SNAPSHOT", "D-1.0.3-SNAPSHOT", "D-1.0.4-SNAPSHOT"), PackageState.DOWNLOADED);
        Assertions.assertThat((boolean)connectBrocker.pkgRequest(null, Arrays.asList("A-1.0.0", "C"), null, null, true, false)).isTrue();
        this.checkPackagesState(connectBrocker, Arrays.asList("studioA-1.0.0", "hfA-1.0.0", "A-1.0.0", "B-1.0.1-SNAPSHOT", "C-1.0.0", "D-1.0.2-SNAPSHOT"), PackageState.STARTED);
        this.checkPackagesState(connectBrocker, Arrays.asList("studioA-1.0.1", "studioA-1.0.2-SNAPSHOT", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.2.0", "A-1.2.1-SNAPSHOT", "A-1.2.2-SNAPSHOT", "A-1.2.2", "A-1.2.3-SNAPSHOT", "B-1.0.1", "B-1.0.2", "C-1.0.1-SNAPSHOT", "C-1.0.2-SNAPSHOT", "D-1.0.3-SNAPSHOT", "D-1.0.4-SNAPSHOT"), PackageState.DOWNLOADED);
        List<String> expectedLogs = Arrays.asList("\nDependency resolution:\n  Unchanged packages (9):        A:1.0.0, B:1.0.1-SNAPSHOT, hfA:1.0.0, C:1.0.0, D:1.0.2-SNAPSHOT, studioA:1.0.0, G:1.0.1-SNAPSHOT, H:1.0.1-SNAPSHOT, J:1.0.1\n");
        this.checkLogEvents(expectedLogs, this.logCaptureResult.getCaughtEvents());
        this.logCaptureResult.clear();
        Assertions.assertThat((boolean)connectBrocker.pkgRequest(null, Arrays.asList("B-1.0.1-SNAPSHOT", "D"), null, null, true, false)).isTrue();
        this.checkPackagesState(connectBrocker, Arrays.asList("studioA-1.0.0", "hfA-1.0.0", "A-1.0.0", "B-1.0.1-SNAPSHOT", "C-1.0.0", "D-1.0.2-SNAPSHOT"), PackageState.STARTED);
        this.checkPackagesState(connectBrocker, Arrays.asList("studioA-1.0.1", "studioA-1.0.2-SNAPSHOT", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.2.0", "A-1.2.1-SNAPSHOT", "A-1.2.2-SNAPSHOT", "A-1.2.2", "A-1.2.3-SNAPSHOT", "B-1.0.1", "B-1.0.2", "C-1.0.1-SNAPSHOT", "C-1.0.2-SNAPSHOT", "D-1.0.3-SNAPSHOT", "D-1.0.4-SNAPSHOT"), PackageState.DOWNLOADED);
        expectedLogs = Arrays.asList("The following SNAPSHOT package(s) will be replaced in local cache : [D-1.0.2-SNAPSHOT, B-1.0.1-SNAPSHOT]", "Uninstalling D-1.0.2-SNAPSHOT", "Uninstalling B-1.0.1-SNAPSHOT", "Download of 'D-1.0.2-SNAPSHOT' will replace the one already in local cache.", "Downloading [D-1.0.2-SNAPSHOT]...", "Replacement of D-1.0.2-SNAPSHOT in local cache...", "Added D-1.0.2-SNAPSHOT", "Download of 'B-1.0.1-SNAPSHOT' will replace the one already in local cache.", "Downloading [B-1.0.1-SNAPSHOT]...", "Replacement of B-1.0.1-SNAPSHOT in local cache...", "Added B-1.0.1-SNAPSHOT", "\nAs package 'C-1.0.0' has an optional dependency on package(s) [D-1.0.2-SNAPSHOT] currently being installed, it will be reinstalled.\nDependency resolution:\n  Installation order (3):        B-1.0.1-SNAPSHOT/D-1.0.2-SNAPSHOT/C-1.0.0\n  Uninstallation order (1):      C-1.0.0\n  Unchanged packages (6):        A:1.0.0, hfA:1.0.0, studioA:1.0.0, G:1.0.1-SNAPSHOT, H:1.0.1-SNAPSHOT, J:1.0.1\n  Local packages to install (3): B:1.0.1-SNAPSHOT, C:1.0.0, D:1.0.2-SNAPSHOT\n  Local packages to remove (1):  C:1.0.0\n", "Uninstalling C-1.0.0", "Installing B-1.0.1-SNAPSHOT", "Installing D-1.0.2-SNAPSHOT", "Installing C-1.0.0");
        this.checkLogEvents(expectedLogs, this.logCaptureResult.getCaughtEvents());
    }

    @Test
    @LogCaptureFeature.FilterWith(value=PkgRequestLogFilter.class)
    public void testReInstallLocalPackageRequest() throws Exception {
        Environment.getDefault().setProperty("org.nuxeo.distribution.name", "server");
        Environment.getDefault().setProperty("org.nuxeo.distribution.version", "8.3");
        ConnectBroker connectBrocker = new ConnectBroker(Environment.getDefault());
        ((StandaloneCallbackHolder)NuxeoConnectClient.getCallBackHolder()).setTestMode(true);
        connectBrocker.setAllowSNAPSHOT(false);
        this.checkPackagesState(connectBrocker, Arrays.asList("studioA-1.0.0", "hfA-1.0.0", "A-1.0.0", "B-1.0.1-SNAPSHOT", "C-1.0.0", "D-1.0.2-SNAPSHOT"), PackageState.STARTED);
        this.checkPackagesState(connectBrocker, Arrays.asList("studioA-1.0.1", "studioA-1.0.2-SNAPSHOT", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.2.0", "A-1.2.1-SNAPSHOT", "A-1.2.2-SNAPSHOT", "A-1.2.2", "A-1.2.3-SNAPSHOT", "B-1.0.1", "B-1.0.2", "C-1.0.1-SNAPSHOT", "C-1.0.2-SNAPSHOT", "D-1.0.3-SNAPSHOT", "D-1.0.4-SNAPSHOT"), PackageState.DOWNLOADED);
        Assertions.assertThat((boolean)connectBrocker.pkgRequest(null, Arrays.asList("src/test/resources/packages/store/A-1.0.0.zip"), null, null, true, false)).isTrue();
        this.checkPackagesState(connectBrocker, Arrays.asList("studioA-1.0.0", "hfA-1.0.0", "A-1.0.0", "B-1.0.1-SNAPSHOT", "C-1.0.0", "D-1.0.2-SNAPSHOT"), PackageState.STARTED);
        this.checkPackagesState(connectBrocker, Arrays.asList("studioA-1.0.1", "studioA-1.0.2-SNAPSHOT", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.2.0", "A-1.2.1-SNAPSHOT", "A-1.2.2-SNAPSHOT", "A-1.2.2", "A-1.2.3-SNAPSHOT", "B-1.0.1", "B-1.0.2", "C-1.0.1-SNAPSHOT", "C-1.0.2-SNAPSHOT", "D-1.0.3-SNAPSHOT", "D-1.0.4-SNAPSHOT"), PackageState.DOWNLOADED);
        List<String> expectedLogs = Arrays.asList("\nDependency resolution:\n  Unchanged packages (9):        A:1.0.0, B:1.0.1-SNAPSHOT, hfA:1.0.0, C:1.0.0, D:1.0.2-SNAPSHOT, studioA:1.0.0, G:1.0.1-SNAPSHOT, H:1.0.1-SNAPSHOT, J:1.0.1\n");
        this.checkLogEvents(expectedLogs, this.logCaptureResult.getCaughtEvents());
        this.logCaptureResult.clear();
        Assertions.assertThat((boolean)connectBrocker.pkgRequest(null, Arrays.asList("src/test/resources/packages/store/B-1.0.1-SNAPSHOT.zip"), null, null, true, false)).isTrue();
        this.checkPackagesState(connectBrocker, Arrays.asList("studioA-1.0.0", "hfA-1.0.0", "A-1.0.0", "B-1.0.1-SNAPSHOT", "C-1.0.0", "D-1.0.2-SNAPSHOT"), PackageState.STARTED);
        this.checkPackagesState(connectBrocker, Arrays.asList("studioA-1.0.1", "studioA-1.0.2-SNAPSHOT", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.2.0", "A-1.2.1-SNAPSHOT", "A-1.2.2-SNAPSHOT", "A-1.2.2", "A-1.2.3-SNAPSHOT", "B-1.0.1", "B-1.0.2", "C-1.0.1-SNAPSHOT", "C-1.0.2-SNAPSHOT", "D-1.0.3-SNAPSHOT", "D-1.0.4-SNAPSHOT"), PackageState.DOWNLOADED);
        expectedLogs = Arrays.asList("The following SNAPSHOT package(s) will be replaced in local cache : [src/test/resources/packages/store/B-1.0.1-SNAPSHOT.zip]", "Uninstalling B-1.0.1-SNAPSHOT", "Replacement of B-1.0.1-SNAPSHOT in local cache...", "Added src/test/resources/packages/store/B-1.0.1-SNAPSHOT.zip", "\nDependency resolution:\n  Installation order (1):        B-1.0.1-SNAPSHOT\n  Unchanged packages (8):        A:1.0.0, hfA:1.0.0, C:1.0.0, D:1.0.2-SNAPSHOT, studioA:1.0.0, G:1.0.1-SNAPSHOT, H:1.0.1-SNAPSHOT, J:1.0.1\n  Local packages to install (1): B:1.0.1-SNAPSHOT\n", "Installing B-1.0.1-SNAPSHOT");
        this.checkLogEvents(expectedLogs, this.logCaptureResult.getCaughtEvents());
    }

    @Test
    @LogCaptureFeature.FilterWith(value=PkgRequestLogFilter.class)
    public void testUpgradePackageRequestWithRelax() throws Exception {
        ConnectBroker connectBrocker = new ConnectBroker(Environment.getDefault());
        ((StandaloneCallbackHolder)NuxeoConnectClient.getCallBackHolder()).setTestMode(true);
        connectBrocker.setAllowSNAPSHOT(false);
        connectBrocker.setRelax("true");
        this.checkPackagesState(connectBrocker, Arrays.asList("studioA-1.0.0", "hfA-1.0.0", "A-1.0.0", "B-1.0.1-SNAPSHOT", "C-1.0.0", "D-1.0.2-SNAPSHOT", "G-1.0.1-SNAPSHOT", "H-1.0.1-SNAPSHOT", "J-1.0.1"), PackageState.STARTED);
        this.checkPackagesState(connectBrocker, Arrays.asList("studioA-1.0.1", "studioA-1.0.2-SNAPSHOT", "hfA-1.0.8", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.2.0", "A-1.2.1-SNAPSHOT", "A-1.2.2-SNAPSHOT", "A-1.2.2", "A-1.2.3-SNAPSHOT", "B-1.0.1", "B-1.0.2", "C-1.0.1-SNAPSHOT", "C-1.0.2-SNAPSHOT", "D-1.0.3-SNAPSHOT", "D-1.0.4-SNAPSHOT"), PackageState.DOWNLOADED);
        Assertions.assertThat((boolean)connectBrocker.pkgUpgrade()).isTrue();
        this.checkPackagesState(connectBrocker, Arrays.asList("studioA-1.0.2-SNAPSHOT", "hfA-1.0.8", "A-1.2.2", "B-1.0.2", "C-1.0.0", "D-1.0.4-SNAPSHOT", "G-1.0.1-SNAPSHOT", "H-1.0.1-SNAPSHOT", "J-1.0.1"), PackageState.STARTED);
        this.checkPackagesState(connectBrocker, Arrays.asList("studioA-1.0.0", "studioA-1.0.1", "hfA-1.0.0", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.0.0", "A-1.2.1-SNAPSHOT", "A-1.2.2-SNAPSHOT", "A-1.2.0", "A-1.2.3-SNAPSHOT", "B-1.0.1-SNAPSHOT", "B-1.0.1", "C-1.0.1-SNAPSHOT", "C-1.0.2-SNAPSHOT", "D-1.0.2-SNAPSHOT", "D-1.0.3-SNAPSHOT"), PackageState.DOWNLOADED);
        List<String> expectedLogs = Arrays.asList("Relax restriction to target platform null-null because of package(s) studioA, hfA, A, B, C, D, G, H, J", "\nDependency resolution:\n  Installation order (7):        A-1.2.2/B-1.0.2/D-1.0.4-SNAPSHOT/G-1.0.1-SNAPSHOT/H-1.0.1-SNAPSHOT/hfA-1.0.8/studioA-1.0.2-SNAPSHOT\n  Unchanged packages (4):        C:1.0.0, G:1.0.1-SNAPSHOT, H:1.0.1-SNAPSHOT, J:1.0.1\n  Packages to upgrade (5):       A:1.0.0, B:1.0.1-SNAPSHOT, hfA:1.0.0, D:1.0.2-SNAPSHOT, studioA:1.0.0\n  Local packages to install (5): A:1.2.2, B:1.0.2, hfA:1.0.8, D:1.0.4-SNAPSHOT, studioA:1.0.2-SNAPSHOT\n", "Uninstalling studioA-1.0.0", "Uninstalling hfA-1.0.0", "Uninstalling D-1.0.2-SNAPSHOT", "Uninstalling B-1.0.1-SNAPSHOT", "Uninstalling A-1.0.0", "Installing A-1.2.2", "Installing B-1.0.2", "Installing D-1.0.4-SNAPSHOT", "Updating package G-1.0.1-SNAPSHOT...", "Uninstalling G-1.0.1-SNAPSHOT", "Removed G-1.0.1-SNAPSHOT", "Downloading [G-1.0.1-SNAPSHOT]...", "Added G-1.0.1-SNAPSHOT", "Installing G-1.0.1-SNAPSHOT", "Updating package H-1.0.1-SNAPSHOT...", "Uninstalling H-1.0.1-SNAPSHOT", "Removed H-1.0.1-SNAPSHOT", "Downloading [H-1.0.1-SNAPSHOT]...", "Added H-1.0.1-SNAPSHOT", "Installing H-1.0.1-SNAPSHOT", "Installing hfA-1.0.8", "Installing studioA-1.0.2-SNAPSHOT");
        this.checkLogEvents(expectedLogs, this.logCaptureResult.getCaughtEvents());
    }

    @Test
    @LogCaptureFeature.FilterWith(value=PkgRequestLogFilter.class)
    public void testUpgradePackageRequestWithRelaxAndSnapshot() throws Exception {
        ConnectBroker connectBrocker = new ConnectBroker(Environment.getDefault());
        ((StandaloneCallbackHolder)NuxeoConnectClient.getCallBackHolder()).setTestMode(true);
        connectBrocker.setAllowSNAPSHOT(true);
        connectBrocker.setRelax("true");
        this.checkPackagesState(connectBrocker, Arrays.asList("studioA-1.0.0", "hfA-1.0.0", "A-1.0.0", "B-1.0.1-SNAPSHOT", "C-1.0.0", "D-1.0.2-SNAPSHOT", "G-1.0.1-SNAPSHOT", "H-1.0.1-SNAPSHOT", "J-1.0.1"), PackageState.STARTED);
        this.checkPackagesState(connectBrocker, Arrays.asList("studioA-1.0.1", "studioA-1.0.2-SNAPSHOT", "hfA-1.0.8", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.2.0", "A-1.2.1-SNAPSHOT", "A-1.2.2-SNAPSHOT", "A-1.2.2", "A-1.2.3-SNAPSHOT", "B-1.0.1", "B-1.0.2", "C-1.0.1-SNAPSHOT", "C-1.0.2-SNAPSHOT", "D-1.0.3-SNAPSHOT", "D-1.0.4-SNAPSHOT"), PackageState.DOWNLOADED);
        Assertions.assertThat((boolean)connectBrocker.pkgUpgrade()).isTrue();
        this.checkPackagesState(connectBrocker, Arrays.asList("studioA-1.0.2-SNAPSHOT", "hfA-1.0.8", "A-1.2.3-SNAPSHOT", "B-1.0.2", "C-1.0.2-SNAPSHOT", "D-1.0.4-SNAPSHOT", "G-1.0.1-SNAPSHOT", "H-1.0.1-SNAPSHOT", "J-1.0.1"), PackageState.STARTED);
        this.checkPackagesState(connectBrocker, Arrays.asList("studioA-1.0.0", "studioA-1.0.1", "hfA-1.0.0", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.0.0", "A-1.2.1-SNAPSHOT", "A-1.2.2-SNAPSHOT", "A-1.2.2", "A-1.2.0", "B-1.0.1-SNAPSHOT", "B-1.0.1", "C-1.0.1-SNAPSHOT", "C-1.0.0", "D-1.0.2-SNAPSHOT", "D-1.0.3-SNAPSHOT"), PackageState.DOWNLOADED);
        List<String> expectedLogs = Arrays.asList("Relax restriction to target platform null-null because of package(s) studioA, hfA, A, B, C, D, G, H, J", "\nDependency resolution:\n  Installation order (8):        A-1.2.3-SNAPSHOT/B-1.0.2/D-1.0.4-SNAPSHOT/G-1.0.1-SNAPSHOT/H-1.0.1-SNAPSHOT/hfA-1.0.8/studioA-1.0.2-SNAPSHOT/C-1.0.2-SNAPSHOT\n  Unchanged packages (3):        G:1.0.1-SNAPSHOT, H:1.0.1-SNAPSHOT, J:1.0.1\n  Packages to upgrade (6):       A:1.0.0, B:1.0.1-SNAPSHOT, hfA:1.0.0, C:1.0.0, D:1.0.2-SNAPSHOT, studioA:1.0.0\n  Local packages to install (6): A:1.2.3-SNAPSHOT, B:1.0.2, hfA:1.0.8, C:1.0.2-SNAPSHOT, D:1.0.4-SNAPSHOT, studioA:1.0.2-SNAPSHOT\n", "Uninstalling C-1.0.0", "Uninstalling studioA-1.0.0", "Uninstalling hfA-1.0.0", "Uninstalling D-1.0.2-SNAPSHOT", "Uninstalling B-1.0.1-SNAPSHOT", "Uninstalling A-1.0.0", "Installing A-1.2.3-SNAPSHOT", "Installing B-1.0.2", "Installing D-1.0.4-SNAPSHOT", "Updating package G-1.0.1-SNAPSHOT...", "Uninstalling G-1.0.1-SNAPSHOT", "Removed G-1.0.1-SNAPSHOT", "Downloading [G-1.0.1-SNAPSHOT]...", "Added G-1.0.1-SNAPSHOT", "Installing G-1.0.1-SNAPSHOT", "Updating package H-1.0.1-SNAPSHOT...", "Uninstalling H-1.0.1-SNAPSHOT", "Removed H-1.0.1-SNAPSHOT", "Downloading [H-1.0.1-SNAPSHOT]...", "Added H-1.0.1-SNAPSHOT", "Installing H-1.0.1-SNAPSHOT", "Installing hfA-1.0.8", "Installing studioA-1.0.2-SNAPSHOT", "Installing C-1.0.2-SNAPSHOT");
        this.checkLogEvents(expectedLogs, this.logCaptureResult.getCaughtEvents());
    }

    @Test
    @LogCaptureFeature.FilterWith(value=PkgRequestLogFilter.class)
    public void testUpgradePackageRequestWithTargetPlatform() throws Exception {
        Environment.getDefault().setProperty("org.nuxeo.distribution.name", "server");
        Environment.getDefault().setProperty("org.nuxeo.distribution.version", "8.3");
        ConnectBroker connectBrocker = new ConnectBroker(Environment.getDefault());
        ((StandaloneCallbackHolder)NuxeoConnectClient.getCallBackHolder()).setTestMode(true);
        connectBrocker.setAllowSNAPSHOT(false);
        this.checkPackagesState(connectBrocker, Arrays.asList("studioA-1.0.0", "hfA-1.0.0", "A-1.0.0", "B-1.0.1-SNAPSHOT", "C-1.0.0", "D-1.0.2-SNAPSHOT", "G-1.0.1-SNAPSHOT", "H-1.0.1-SNAPSHOT", "J-1.0.1"), PackageState.STARTED);
        this.checkPackagesState(connectBrocker, Arrays.asList("studioA-1.0.1", "studioA-1.0.2-SNAPSHOT", "hfA-1.0.8", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.2.0", "A-1.2.1-SNAPSHOT", "A-1.2.2-SNAPSHOT", "A-1.2.2", "A-1.2.3-SNAPSHOT", "B-1.0.1", "B-1.0.2", "C-1.0.1-SNAPSHOT", "C-1.0.2-SNAPSHOT", "D-1.0.3-SNAPSHOT", "D-1.0.4-SNAPSHOT"), PackageState.DOWNLOADED);
        Assertions.assertThat((boolean)connectBrocker.pkgUpgrade()).isTrue();
        this.checkPackagesState(connectBrocker, Arrays.asList("studioA-1.0.2-SNAPSHOT", "hfA-1.0.8", "A-1.2.0", "B-1.0.1", "C-1.0.0", "D-1.0.3-SNAPSHOT", "G-1.0.1-SNAPSHOT", "H-1.0.1-SNAPSHOT", "J-1.0.1"), PackageState.STARTED);
        this.checkPackagesState(connectBrocker, Arrays.asList("studioA-1.0.0", "studioA-1.0.1", "hfA-1.0.0", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.0.0", "A-1.2.1-SNAPSHOT", "A-1.2.2-SNAPSHOT", "A-1.2.2", "A-1.2.3-SNAPSHOT", "B-1.0.1-SNAPSHOT", "B-1.0.2", "C-1.0.1-SNAPSHOT", "C-1.0.2-SNAPSHOT", "D-1.0.2-SNAPSHOT", "D-1.0.4-SNAPSHOT"), PackageState.DOWNLOADED);
        List<String> expectedLogs = Arrays.asList("Optional dependencies [B:1.0.2] will be ignored for 'A-1.2.0'.", "\nDependency resolution:\n  Installation order (7):        A-1.2.0/B-1.0.1/D-1.0.3-SNAPSHOT/G-1.0.1-SNAPSHOT/H-1.0.1-SNAPSHOT/hfA-1.0.8/studioA-1.0.2-SNAPSHOT\n  Unchanged packages (4):        C:1.0.0, G:1.0.1-SNAPSHOT, H:1.0.1-SNAPSHOT, J:1.0.1\n  Packages to upgrade (5):       A:1.0.0, B:1.0.1-SNAPSHOT, hfA:1.0.0, D:1.0.2-SNAPSHOT, studioA:1.0.0\n  Local packages to install (5): A:1.2.0, B:1.0.1, hfA:1.0.8, D:1.0.3-SNAPSHOT, studioA:1.0.2-SNAPSHOT\n", "Uninstalling studioA-1.0.0", "Uninstalling hfA-1.0.0", "Uninstalling D-1.0.2-SNAPSHOT", "Uninstalling B-1.0.1-SNAPSHOT", "Uninstalling A-1.0.0", "Installing A-1.2.0", "Installing B-1.0.1", "Installing D-1.0.3-SNAPSHOT", "Updating package G-1.0.1-SNAPSHOT...", "Uninstalling G-1.0.1-SNAPSHOT", "Removed G-1.0.1-SNAPSHOT", "Downloading [G-1.0.1-SNAPSHOT]...", "Added G-1.0.1-SNAPSHOT", "Installing G-1.0.1-SNAPSHOT", "Updating package H-1.0.1-SNAPSHOT...", "Uninstalling H-1.0.1-SNAPSHOT", "Removed H-1.0.1-SNAPSHOT", "Downloading [H-1.0.1-SNAPSHOT]...", "Added H-1.0.1-SNAPSHOT", "Installing H-1.0.1-SNAPSHOT", "Installing hfA-1.0.8", "Installing studioA-1.0.2-SNAPSHOT");
        this.checkLogEvents(expectedLogs, this.logCaptureResult.getCaughtEvents());
    }

    @Test
    @LogCaptureFeature.FilterWith(value=PkgRequestLogFilter.class)
    public void testUpgradePackageRequestWithTargetPlatformAndSnapshot() throws Exception {
        Environment.getDefault().setProperty("org.nuxeo.distribution.name", "server");
        Environment.getDefault().setProperty("org.nuxeo.distribution.version", "8.3");
        ConnectBroker connectBrocker = new ConnectBroker(Environment.getDefault());
        ((StandaloneCallbackHolder)NuxeoConnectClient.getCallBackHolder()).setTestMode(true);
        connectBrocker.setAllowSNAPSHOT(true);
        this.checkPackagesState(connectBrocker, Arrays.asList("studioA-1.0.0", "hfA-1.0.0", "A-1.0.0", "B-1.0.1-SNAPSHOT", "C-1.0.0", "D-1.0.2-SNAPSHOT", "G-1.0.1-SNAPSHOT", "H-1.0.1-SNAPSHOT", "J-1.0.1"), PackageState.STARTED);
        this.checkPackagesState(connectBrocker, Arrays.asList("studioA-1.0.1", "studioA-1.0.2-SNAPSHOT", "hfA-1.0.8", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.2.0", "A-1.2.1-SNAPSHOT", "A-1.2.2-SNAPSHOT", "A-1.2.2", "A-1.2.3-SNAPSHOT", "B-1.0.1", "B-1.0.2", "C-1.0.1-SNAPSHOT", "C-1.0.2-SNAPSHOT", "D-1.0.3-SNAPSHOT", "D-1.0.4-SNAPSHOT"), PackageState.DOWNLOADED);
        Assertions.assertThat((boolean)connectBrocker.pkgUpgrade()).isTrue();
        this.checkPackagesState(connectBrocker, Arrays.asList("studioA-1.0.2-SNAPSHOT", "hfA-1.0.8", "A-1.2.1-SNAPSHOT", "B-1.0.1", "C-1.0.1-SNAPSHOT", "D-1.0.3-SNAPSHOT", "G-1.0.1-SNAPSHOT", "H-1.0.1-SNAPSHOT", "J-1.0.1"), PackageState.STARTED);
        this.checkPackagesState(connectBrocker, Arrays.asList("studioA-1.0.0", "studioA-1.0.1", "hfA-1.0.0", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.0.0", "A-1.2.0", "A-1.2.2-SNAPSHOT", "A-1.2.2", "A-1.2.3-SNAPSHOT", "B-1.0.1-SNAPSHOT", "B-1.0.2", "C-1.0.0", "C-1.0.2-SNAPSHOT", "D-1.0.2-SNAPSHOT", "D-1.0.4-SNAPSHOT"), PackageState.DOWNLOADED);
        List<String> expectedLogs = Arrays.asList("\nDependency resolution:\n  Installation order (8):        A-1.2.1-SNAPSHOT/B-1.0.1/D-1.0.3-SNAPSHOT/G-1.0.1-SNAPSHOT/H-1.0.1-SNAPSHOT/hfA-1.0.8/studioA-1.0.2-SNAPSHOT/C-1.0.1-SNAPSHOT\n  Unchanged packages (3):        G:1.0.1-SNAPSHOT, H:1.0.1-SNAPSHOT, J:1.0.1\n  Packages to upgrade (6):       A:1.0.0, B:1.0.1-SNAPSHOT, hfA:1.0.0, C:1.0.0, D:1.0.2-SNAPSHOT, studioA:1.0.0\n  Local packages to install (6): A:1.2.1-SNAPSHOT, B:1.0.1, hfA:1.0.8, C:1.0.1-SNAPSHOT, D:1.0.3-SNAPSHOT, studioA:1.0.2-SNAPSHOT\n", "Uninstalling C-1.0.0", "Uninstalling studioA-1.0.0", "Uninstalling hfA-1.0.0", "Uninstalling D-1.0.2-SNAPSHOT", "Uninstalling B-1.0.1-SNAPSHOT", "Uninstalling A-1.0.0", "Installing A-1.2.1-SNAPSHOT", "Installing B-1.0.1", "Installing D-1.0.3-SNAPSHOT", "Updating package G-1.0.1-SNAPSHOT...", "Uninstalling G-1.0.1-SNAPSHOT", "Removed G-1.0.1-SNAPSHOT", "Downloading [G-1.0.1-SNAPSHOT]...", "Added G-1.0.1-SNAPSHOT", "Installing G-1.0.1-SNAPSHOT", "Updating package H-1.0.1-SNAPSHOT...", "Uninstalling H-1.0.1-SNAPSHOT", "Removed H-1.0.1-SNAPSHOT", "Downloading [H-1.0.1-SNAPSHOT]...", "Added H-1.0.1-SNAPSHOT", "Installing H-1.0.1-SNAPSHOT", "Installing hfA-1.0.8", "Installing studioA-1.0.2-SNAPSHOT", "Installing C-1.0.1-SNAPSHOT");
        this.checkLogEvents(expectedLogs, this.logCaptureResult.getCaughtEvents());
    }

    @Test
    @LogCaptureFeature.FilterWith(value=PkgRequestLogFilter.class)
    public void testHotfixPackageRequest() throws Exception {
        Environment.getDefault().setProperty("org.nuxeo.distribution.name", "server");
        Environment.getDefault().setProperty("org.nuxeo.distribution.version", "8.3");
        ConnectBroker connectBrocker = new ConnectBroker(Environment.getDefault());
        ((StandaloneCallbackHolder)NuxeoConnectClient.getCallBackHolder()).setTestMode(true);
        connectBrocker.setAllowSNAPSHOT(false);
        this.checkPackagesState(connectBrocker, Arrays.asList("studioA-1.0.0", "hfA-1.0.0", "A-1.0.0", "B-1.0.1-SNAPSHOT", "C-1.0.0", "D-1.0.2-SNAPSHOT"), PackageState.STARTED);
        this.checkPackagesState(connectBrocker, Arrays.asList("studioA-1.0.1", "studioA-1.0.2-SNAPSHOT", "hfA-1.0.8", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.2.0", "A-1.2.1-SNAPSHOT", "A-1.2.2-SNAPSHOT", "A-1.2.2", "A-1.2.3-SNAPSHOT", "B-1.0.1", "B-1.0.2", "C-1.0.1-SNAPSHOT", "C-1.0.2-SNAPSHOT", "D-1.0.3-SNAPSHOT", "D-1.0.4-SNAPSHOT"), PackageState.DOWNLOADED);
        Assertions.assertThat((boolean)connectBrocker.pkgHotfix()).isTrue();
        this.checkPackagesState(connectBrocker, Arrays.asList("studioA-1.0.0", "hfA-1.0.0", "hfB-1.0.0", "A-1.0.0", "B-1.0.1-SNAPSHOT", "C-1.0.0", "D-1.0.2-SNAPSHOT"), PackageState.STARTED);
        this.checkPackagesState(connectBrocker, Arrays.asList("studioA-1.0.1", "studioA-1.0.2-SNAPSHOT", "hfA-1.0.8", "hfC-1.0.0-SNAPSHOT", "A-1.2.0", "A-1.2.1-SNAPSHOT", "A-1.2.2-SNAPSHOT", "A-1.2.2", "A-1.2.3-SNAPSHOT", "B-1.0.1", "B-1.0.2", "C-1.0.1-SNAPSHOT", "C-1.0.2-SNAPSHOT", "D-1.0.3-SNAPSHOT", "D-1.0.4-SNAPSHOT"), PackageState.DOWNLOADED);
        List<String> expectedLogs = Arrays.asList("\nDependency resolution:\n  Installation order (1):        hfB-1.0.0\n  Unchanged packages (9):        A:1.0.0, B:1.0.1-SNAPSHOT, hfA:1.0.0, C:1.0.0, D:1.0.2-SNAPSHOT, studioA:1.0.0, G:1.0.1-SNAPSHOT, H:1.0.1-SNAPSHOT, J:1.0.1\n  Local packages to install (1): hfB:1.0.0\n", "Installing hfB-1.0.0");
        this.checkLogEvents(expectedLogs, this.logCaptureResult.getCaughtEvents());
        this.logCaptureResult.clear();
        connectBrocker.setAllowSNAPSHOT(true);
        Assertions.assertThat((boolean)connectBrocker.pkgHotfix()).isTrue();
        this.checkPackagesState(connectBrocker, Arrays.asList("studioA-1.0.0", "hfA-1.0.0", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.0.0", "B-1.0.1-SNAPSHOT", "C-1.0.0", "D-1.0.2-SNAPSHOT"), PackageState.STARTED);
        this.checkPackagesState(connectBrocker, Arrays.asList("studioA-1.0.1", "studioA-1.0.2-SNAPSHOT", "hfA-1.0.8", "A-1.2.0", "A-1.2.1-SNAPSHOT", "A-1.2.2-SNAPSHOT", "A-1.2.2", "A-1.2.3-SNAPSHOT", "B-1.0.1", "B-1.0.2", "C-1.0.1-SNAPSHOT", "C-1.0.2-SNAPSHOT", "D-1.0.3-SNAPSHOT", "D-1.0.4-SNAPSHOT"), PackageState.DOWNLOADED);
        expectedLogs = Arrays.asList("\nDependency resolution:\n  Installation order (1):        hfC-1.0.0-SNAPSHOT\n  Unchanged packages (10):       A:1.0.0, B:1.0.1-SNAPSHOT, hfA:1.0.0, C:1.0.0, D:1.0.2-SNAPSHOT, hfB:1.0.0, studioA:1.0.0, G:1.0.1-SNAPSHOT, H:1.0.1-SNAPSHOT, J:1.0.1\n  Local packages to install (1): hfC:1.0.0-SNAPSHOT\n", "Download of 'hfC-1.0.0-SNAPSHOT' will replace the one already in local cache.", "Downloading [hfC-1.0.0-SNAPSHOT]...", "Replacement of hfC-1.0.0-SNAPSHOT in local cache...", "Added hfC-1.0.0-SNAPSHOT", "Installing hfC-1.0.0-SNAPSHOT");
        this.checkLogEvents(expectedLogs, this.logCaptureResult.getCaughtEvents());
    }

    @Test
    @LogCaptureFeature.FilterWith(value=PkgRequestLogFilter.class)
    public void testReInstallPackageRequestWithOptionalDependencies() throws Exception {
        Environment.getDefault().setProperty("org.nuxeo.distribution.name", "server");
        Environment.getDefault().setProperty("org.nuxeo.distribution.version", "8.3");
        ConnectBroker connectBrocker = new ConnectBroker(Environment.getDefault());
        ((StandaloneCallbackHolder)NuxeoConnectClient.getCallBackHolder()).setTestMode(true);
        connectBrocker.setAllowSNAPSHOT(false);
        this.checkPackagesState(connectBrocker, Arrays.asList("studioA-1.0.0", "hfA-1.0.0", "A-1.0.0", "B-1.0.1-SNAPSHOT", "C-1.0.0", "D-1.0.2-SNAPSHOT", "G-1.0.1-SNAPSHOT", "H-1.0.1-SNAPSHOT", "J-1.0.1"), PackageState.STARTED);
        this.checkPackagesState(connectBrocker, Arrays.asList("studioA-1.0.1", "studioA-1.0.2-SNAPSHOT", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.2.0", "A-1.2.1-SNAPSHOT", "A-1.2.2-SNAPSHOT", "A-1.2.2", "A-1.2.3-SNAPSHOT", "B-1.0.1", "B-1.0.2", "C-1.0.1-SNAPSHOT", "C-1.0.2-SNAPSHOT", "D-1.0.3-SNAPSHOT", "D-1.0.4-SNAPSHOT"), PackageState.DOWNLOADED);
        Assertions.assertThat((boolean)connectBrocker.pkgRequest(null, Arrays.asList("H", "G"), null, null, true, false)).isTrue();
        this.checkPackagesState(connectBrocker, Arrays.asList("studioA-1.0.0", "hfA-1.0.0", "A-1.0.0", "B-1.0.1-SNAPSHOT", "C-1.0.0", "D-1.0.2-SNAPSHOT", "G-1.0.1-SNAPSHOT", "H-1.0.1-SNAPSHOT", "J-1.0.1"), PackageState.STARTED);
        this.checkPackagesState(connectBrocker, Arrays.asList("studioA-1.0.1", "studioA-1.0.2-SNAPSHOT", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.2.0", "A-1.2.1-SNAPSHOT", "A-1.2.2-SNAPSHOT", "A-1.2.2", "A-1.2.3-SNAPSHOT", "B-1.0.1", "B-1.0.2", "C-1.0.1-SNAPSHOT", "C-1.0.2-SNAPSHOT", "D-1.0.3-SNAPSHOT", "D-1.0.4-SNAPSHOT"), PackageState.DOWNLOADED);
        List<String> expectedLogs = Arrays.asList("The following SNAPSHOT package(s) will be replaced in local cache : [G-1.0.1-SNAPSHOT, H-1.0.1-SNAPSHOT]", "Uninstalling G-1.0.1-SNAPSHOT", "Uninstalling H-1.0.1-SNAPSHOT", "Download of 'G-1.0.1-SNAPSHOT' will replace the one already in local cache.", "Downloading [G-1.0.1-SNAPSHOT]...", "Replacement of G-1.0.1-SNAPSHOT in local cache...", "Added G-1.0.1-SNAPSHOT", "Download of 'H-1.0.1-SNAPSHOT' will replace the one already in local cache.", "Downloading [H-1.0.1-SNAPSHOT]...", "Replacement of H-1.0.1-SNAPSHOT in local cache...", "Added H-1.0.1-SNAPSHOT", "\nAs package 'J-1.0.1' has an optional dependency on package(s) [G-1.0.1-SNAPSHOT, H-1.0.1-SNAPSHOT] currently being installed, it will be reinstalled.\nDependency resolution:\n  Installation order (3):        G-1.0.1-SNAPSHOT/H-1.0.1-SNAPSHOT/J-1.0.1\n  Uninstallation order (1):      J-1.0.1\n  Unchanged packages (6):        A:1.0.0, B:1.0.1-SNAPSHOT, hfA:1.0.0, C:1.0.0, D:1.0.2-SNAPSHOT, studioA:1.0.0\n  Local packages to install (3): G:1.0.1-SNAPSHOT, H:1.0.1-SNAPSHOT, J:1.0.1\n  Local packages to remove (1):  J:1.0.1\n", "Uninstalling J-1.0.1", "Installing G-1.0.1-SNAPSHOT", "Installing H-1.0.1-SNAPSHOT", "Installing J-1.0.1");
        this.checkLogEvents(expectedLogs, this.logCaptureResult.getCaughtEvents());
    }

    @Test
    @LogCaptureFeature.FilterWith(value=PkgRequestLogFilter.class)
    public void testUninstallPackageRequestWithOptionalDependencies() throws Exception {
        Environment.getDefault().setProperty("org.nuxeo.distribution.name", "server");
        Environment.getDefault().setProperty("org.nuxeo.distribution.version", "8.3");
        ConnectBroker connectBrocker = new ConnectBroker(Environment.getDefault());
        ((StandaloneCallbackHolder)NuxeoConnectClient.getCallBackHolder()).setTestMode(true);
        connectBrocker.setAllowSNAPSHOT(false);
        this.checkPackagesState(connectBrocker, Arrays.asList("studioA-1.0.0", "hfA-1.0.0", "A-1.0.0", "B-1.0.1-SNAPSHOT", "C-1.0.0", "D-1.0.2-SNAPSHOT", "G-1.0.1-SNAPSHOT", "H-1.0.1-SNAPSHOT", "J-1.0.1"), PackageState.STARTED);
        this.checkPackagesState(connectBrocker, Arrays.asList("studioA-1.0.1", "studioA-1.0.2-SNAPSHOT", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.2.0", "A-1.2.1-SNAPSHOT", "A-1.2.2-SNAPSHOT", "A-1.2.2", "A-1.2.3-SNAPSHOT", "B-1.0.1", "B-1.0.2", "C-1.0.1-SNAPSHOT", "C-1.0.2-SNAPSHOT", "D-1.0.3-SNAPSHOT", "D-1.0.4-SNAPSHOT"), PackageState.DOWNLOADED);
        Assertions.assertThat((boolean)connectBrocker.pkgRequest(null, null, Arrays.asList("H", "G"), null, true, false)).isTrue();
        this.checkPackagesState(connectBrocker, Arrays.asList("studioA-1.0.0", "hfA-1.0.0", "A-1.0.0", "B-1.0.1-SNAPSHOT", "C-1.0.0", "D-1.0.2-SNAPSHOT", "J-1.0.1"), PackageState.STARTED);
        this.checkPackagesState(connectBrocker, Arrays.asList("studioA-1.0.1", "studioA-1.0.2-SNAPSHOT", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.2.0", "A-1.2.1-SNAPSHOT", "A-1.2.2-SNAPSHOT", "A-1.2.2", "A-1.2.3-SNAPSHOT", "B-1.0.1", "B-1.0.2", "C-1.0.1-SNAPSHOT", "C-1.0.2-SNAPSHOT", "D-1.0.3-SNAPSHOT", "D-1.0.4-SNAPSHOT", "G-1.0.1-SNAPSHOT", "H-1.0.1-SNAPSHOT"), PackageState.DOWNLOADED);
        List<String> expectedLogs = Arrays.asList("\nAs package 'J-1.0.1' has an optional dependency on package(s) [G-1.0.1-SNAPSHOT, H-1.0.1-SNAPSHOT] currently being uninstalled, it will be reinstalled.\nDependency resolution:\n  Installation order (1):        J-1.0.1\n  Uninstallation order (3):      J-1.0.1/H-1.0.1-SNAPSHOT/G-1.0.1-SNAPSHOT\n  Unchanged packages (6):        A:1.0.0, B:1.0.1-SNAPSHOT, hfA:1.0.0, C:1.0.0, D:1.0.2-SNAPSHOT, studioA:1.0.0\n  Local packages to install (1): J:1.0.1\n  Local packages to remove (3):  G:1.0.1-SNAPSHOT, H:1.0.1-SNAPSHOT, J:1.0.1\n", "Uninstalling J-1.0.1", "Uninstalling H-1.0.1-SNAPSHOT", "Uninstalling G-1.0.1-SNAPSHOT", "Installing J-1.0.1");
        this.checkLogEvents(expectedLogs, this.logCaptureResult.getCaughtEvents());
    }

    private void checkPackagesState(ConnectBroker connectBrocker, List<String> packageIdList, PackageState expectedState) {
        Map states = connectBrocker.getUpdateService().getPersistence().getStates();
        for (String pkgId : packageIdList) {
            ((AbstractComparableAssert)Assertions.assertThat((Comparable)((Comparable)states.get(pkgId))).as("Checking state of %s", new Object[]{pkgId})).isEqualTo((Object)expectedState);
        }
    }

    private void checkLogEvents(List<String> expectedLogs, List<LoggingEvent> caughtEvents) {
        Assert.assertEquals((long)expectedLogs.size(), (long)caughtEvents.size());
        for (int i = 0; i < caughtEvents.size(); ++i) {
            Assert.assertEquals((Object)expectedLogs.get(i), (Object)caughtEvents.get(i).getRenderedMessage());
        }
    }

    public class FakeConnectDownloadHandler
    extends AbstractHandler {
        public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
            block26: {
                if (target.startsWith("/test")) {
                    String pkgId = target.substring(target.lastIndexOf("/") + 1);
                    File pkgZip = new File(TestConnectBroker.this.testStore, pkgId + ".zip");
                    if (pkgZip.exists()) {
                        response.setContentLength((int)pkgZip.length());
                        response.setStatus(200);
                        try (ServletOutputStream os = response.getOutputStream();
                             FileInputStream is = new FileInputStream(pkgZip);){
                            IOUtils.copy((InputStream)is, (OutputStream)os);
                            break block26;
                        }
                    }
                    response.setStatus(404);
                }
            }
        }
    }

    public static class PkgRequestLogFilter
    implements LogCaptureFeature.Filter {
        public boolean accept(LoggingEvent event) {
            return event.getLevel().isGreaterOrEqual((Priority)Level.INFO) && (event.getLoggerName().contains("ConnectBroker") || event.getLoggerName().contains("PackagePersistence") || event.getLoggerName().contains("PackageManagerImpl") || event.getLoggerName().contains("LocalDownloadingPackage"));
        }
    }
}

