/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher.connect.fake;

import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.nuxeo.connect.connector.fake.AbstractFakeConnector;
import org.nuxeo.connect.data.AbstractJSONSerializableData;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.data.PackageDescriptor;
import org.nuxeo.connect.update.PackageType;

public class LocalConnectFakeConnector
extends AbstractFakeConnector {
    protected String addonJSON;
    protected String hotfixJSON;
    protected String studioJSON;

    public LocalConnectFakeConnector(String addonJSON, String hotfixJSON, String studioJSON) {
        this.addonJSON = addonJSON;
        this.hotfixJSON = hotfixJSON;
        this.studioJSON = studioJSON;
    }

    protected String getJSONDataForStatus() {
        return "{ contractStatus : 'active', endDate : '10/12/2020'}";
    }

    protected String getJSONDataForDownloads(String type) {
        String data = null;
        data = PackageType.ADDON.getValue().equals(type) ? this.addonJSON : (PackageType.HOT_FIX.getValue().equals(type) ? this.hotfixJSON : (PackageType.STUDIO.getValue().equals(type) ? this.studioJSON : "[]"));
        return data;
    }

    protected String getJSONDataForDownload(String pkgId) {
        HashMap<DownloadablePackage, String> jsonByPackage = new HashMap<DownloadablePackage, String>();
        jsonByPackage.putAll(this.getJSONbyPackageFromJSON(this.addonJSON));
        jsonByPackage.putAll(this.getJSONbyPackageFromJSON(this.hotfixJSON));
        jsonByPackage.putAll(this.getJSONbyPackageFromJSON(this.studioJSON));
        DownloadablePackage foundPkg = jsonByPackage.keySet().stream().filter(pkg -> pkg.getId().equals(pkgId)).findFirst().orElse(null);
        return (String)jsonByPackage.get(foundPkg);
    }

    private Map<DownloadablePackage, String> getJSONbyPackageFromJSON(String json) {
        HashMap<DownloadablePackage, String> result = new HashMap<DownloadablePackage, String>();
        try {
            JSONArray array = new JSONArray(json);
            for (int i = 0; i < array.length(); ++i) {
                JSONObject ob = (JSONObject)array.get(i);
                result.put((DownloadablePackage)AbstractJSONSerializableData.loadFromJSON(PackageDescriptor.class, (JSONObject)ob), ob.toString());
            }
        }
        catch (JSONException e) {
            throw new RuntimeException("Unable to parse json", e);
        }
        return result;
    }
}

