/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher.connect;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.connect.NuxeoConnectClient;
import org.nuxeo.connect.connector.NuxeoClientInstanceType;
import org.nuxeo.connect.data.ConnectProject;
import org.nuxeo.connect.identity.LogicalInstanceIdentifier;
import org.nuxeo.connect.registration.ConnectRegistrationService;
import org.nuxeo.connect.registration.RegistrationException;
import org.nuxeo.connect.registration.RegistrationHelper;
import org.nuxeo.launcher.config.ConfigurationException;

public class ConnectRegistrationBroker {
    public static final String REGISTRATION_EMAIL = "email";
    public static final String REGISTRATION_COMPANY = "company";
    public static final String REGISTRATION_PROJECT = "connectreg:projectName";
    public static final String REGISTRATION_DESCRIPTION = "description";
    public static final String REGISTRATION_PASSWORD = "password";
    public static final String REGISTRATION_PASSWORDND = "password_verif";
    public static final String REGISTRATION_TERMSNCONDITIONS = "termsAndConditions";
    public static final String REGISTRATION_COMPANY_REGEX = "^\\w+$";
    public static final String REGISTRATION_USERNAME_REGEX = "^\\w+$";
    public static final String REGISTRATION_PROJECT_REGEX = "^(?:[-\\w]+|)$";
    private static final Log log = LogFactory.getLog(ConnectRegistrationBroker.class);

    protected static ConnectRegistrationService registration() {
        return NuxeoConnectClient.getConnectRegistrationService();
    }

    public void registerTrial(Map<String, String> parameters) throws IOException, RegistrationException, ConfigurationException {
        try {
            ConnectRegistrationBroker.registration().remoteTrialInstanceRegistration(parameters);
        }
        catch (LogicalInstanceIdentifier.InvalidCLID e) {
            log.debug((Object)e, (Throwable)e);
            throw new ConfigurationException("Instance registration failed.", (Throwable)e);
        }
    }

    public void registerLocal(String strCLID, String description) throws IOException, ConfigurationException {
        try {
            ConnectRegistrationBroker.registration().localRegisterInstance(strCLID, description);
        }
        catch (LogicalInstanceIdentifier.InvalidCLID e) {
            log.debug((Object)e, (Throwable)e);
            throw new ConfigurationException("Instance registration failed.", (Throwable)e);
        }
    }

    public void registerRemote(String username, char[] password, String projectId, NuxeoClientInstanceType type, String description) throws IOException, ConfigurationException {
        String strCLID = RegistrationHelper.remoteRegisterInstance((String)username, (String)new String(password), (String)projectId, (NuxeoClientInstanceType)type, (String)description);
        this.registerLocal(strCLID, description);
    }

    public ConnectProject getProjectByName(String projectName, List<ConnectProject> availableProjects) {
        Stream projectStream = availableProjects.stream();
        Optional<ConnectProject> pkg = projectStream.filter(availProject -> projectName.equalsIgnoreCase(availProject.getSymbolicName())).findFirst();
        if (!pkg.isPresent()) {
            return null;
        }
        return pkg.get();
    }

    public List<ConnectProject> getAvailableProjects(String username, char[] password) throws ConfigurationException {
        List studioProjects = ConnectRegistrationBroker.registration().getAvailableProjectsForRegistration(username, new String(password));
        if (studioProjects.isEmpty()) {
            throw new ConfigurationException("Wrong login or password.");
        }
        return studioProjects;
    }
}

