/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.javaagent;

import com.sun.tools.attach.VirtualMachine;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.javaagent.AgentHandler;
import org.nuxeo.runtime.javaagent.ObjectSizer;

public class AgentLoader {
    public static final AgentLoader INSTANCE = new AgentLoader();
    protected Object agent = this.load();
    protected ObjectSizer sizer = AgentHandler.newHandler(ObjectSizer.class, this.agent);

    public ObjectSizer getSizer() {
        return this.sizer;
    }

    protected <I> I getAgent(Class<I> type) {
        return AgentHandler.newHandler(type, this.agent);
    }

    protected Object load() {
        try {
            this.loadAgentIfNeeded();
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException | MalformedURLException | URISyntaxException cause) {
            throw new RuntimeException("Cannot load nuxeo agent jar in virtual machine", cause);
        }
        try {
            return this.loadInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException cause) {
            throw new RuntimeException("Cannot load nuxeo agent", cause);
        }
    }

    protected Object loadInstance() throws ClassNotFoundException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Class<?> clazz = AgentLoader.class.getClassLoader().loadClass("org.nuxeo.runtime.javaagent.NuxeoAgent");
        Field agentField = clazz.getDeclaredField("agent");
        agentField.setAccessible(true);
        return agentField.get(null);
    }

    protected void loadAgentIfNeeded() throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, MalformedURLException, URISyntaxException {
        try {
            AgentLoader.class.getClassLoader().loadClass("org.nuxeo.runtime.javaagent.NuxeoAgent");
        }
        catch (ClassNotFoundException e) {
            this.loadAgent();
        }
    }

    protected void loadAgent() throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, MalformedURLException, URISyntaxException {
        File home;
        String nameOfRunningVM = ManagementFactory.getRuntimeMXBean().getName();
        int p = nameOfRunningVM.indexOf(64);
        String pid = nameOfRunningVM.substring(0, p);
        try {
            home = Framework.getRuntime().getHome().getCanonicalFile();
        }
        catch (IOException cause) {
            throw new RuntimeException("cannot normalize runtime home path", cause);
        }
        File jarParentFolder = new File(home.getParentFile(), "bin");
        String jarLocation = this.locateAgentJar(jarParentFolder);
        if (jarLocation == null) {
            boolean isUnderTest = Boolean.parseBoolean(Framework.getProperty((String)"org.nuxeo.runtime.testing", (String)"false"));
            if (!isUnderTest) {
                throw new RuntimeException("Cannot locate nuxeo agent jar in bin folder");
            }
            URL testResource = AgentLoader.class.getResource("/");
            File testClasses = Paths.get(testResource.toURI()).toFile();
            File mainProject = new File(testClasses.getParentFile().getParentFile().getParentFile(), "main");
            File target = new File(mainProject, "target");
            jarLocation = this.locateAgentJar(target);
            if (jarLocation == null) {
                throw new RuntimeException("Cannot locate nuxeo agent jar in target folder " + target + ", did you forgot to run package target");
            }
        }
        try {
            VirtualMachine vm = VirtualMachine.attach(pid);
            vm.loadAgent(jarLocation, "");
            vm.detach();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String locateAgentJar(File dir) {
        File[] jars = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("nuxeo-javaagent-main") && name.endsWith(".jar");
            }
        });
        if (jars.length == 0) {
            return null;
        }
        return jars[0].getPath();
    }
}

