/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.javaagent;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;

public class AgentHandler
implements InvocationHandler {
    protected final Class<?> type;
    protected final Object agent;
    protected static String[] units = new String[]{"b", "Kb", "Mb"};
    protected final Map<Method, Method> agentMethods = new HashMap<Method, Method>();

    public static <I> I newHandler(Class<I> type, Object agent) {
        return type.cast(Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{type}, (InvocationHandler)new AgentHandler(agent)));
    }

    protected AgentHandler(Object agent) {
        this.agent = agent;
        this.type = agent.getClass();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if ("humanReadable".equals(method.getName())) {
            return this.humanReadable((Long)args[0]);
        }
        return this.agentMethod(method).invoke(this.agent, args);
    }

    protected String humanReadable(long size) {
        String unit = "b";
        double dSize = size;
        String[] arr$ = units;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String eachUnit;
            unit = eachUnit = arr$[i$];
            if (dSize < 1024.0) break;
            dSize /= 1024.0;
        }
        return dSize + unit;
    }

    protected Method agentMethod(Method bridgeMethod) throws NoSuchMethodException, SecurityException {
        Method agentMethod = this.agentMethods.get(bridgeMethod);
        if (agentMethod == null) {
            agentMethod = this.type.getDeclaredMethod(bridgeMethod.getName(), bridgeMethod.getParameterTypes());
            this.agentMethods.put(bridgeMethod, agentMethod);
        }
        return agentMethod;
    }
}

