/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.javaagent;

import java.lang.instrument.Instrumentation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.IdentityHashMap;
import java.util.Map;

public class NuxeoAgent {
    protected static NuxeoAgent agent = new NuxeoAgent();
    protected Instrumentation instrumentation;

    public static void premain(String args, Instrumentation inst) {
        NuxeoAgent.agent.instrumentation = inst;
    }

    public static void agentmain(String args, Instrumentation inst) {
        NuxeoAgent.agent.instrumentation = inst;
    }

    public long sizeOf(Object o) {
        return this.instrumentation.getObjectSize(o);
    }

    public long deepSizeOf(final Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
        return AccessController.doPrivileged(new PrivilegedAction<Long>(){

            @Override
            public Long run() {
                return new GraphSizeProfiler().visit(o);
            }
        });
    }

    protected class GraphSizeProfiler {
        protected final Map<Object, Object> visited = new IdentityHashMap<Object, Object>();

        protected GraphSizeProfiler() {
        }

        protected long visit(Object each) {
            if (each == null) {
                return 0L;
            }
            if (this.visited.containsKey(each)) {
                return 0L;
            }
            this.visited.put(each, each);
            long size = NuxeoAgent.this.instrumentation.getObjectSize(each);
            Class<?> eachType = each.getClass();
            if (eachType.isArray()) {
                if (eachType.getComponentType().isPrimitive()) {
                    return 0L;
                }
                for (int i = 0; i < Array.getLength(each); ++i) {
                    size += this.visit(Array.get(each, i));
                }
            } else {
                size += this.visit(each, eachType);
            }
            return size;
        }

        protected long visit(Object each, Class<?> eachType) {
            if (eachType.equals(Object.class)) {
                return 0L;
            }
            long size = 0L;
            for (Field eachField : eachType.getDeclaredFields()) {
                size += this.visit(each, eachField);
            }
            return size + this.visit(each, eachType.getSuperclass());
        }

        protected long visit(Object each, Field eachField) {
            if ((eachField.getModifiers() & 8) != 0) {
                return 0L;
            }
            if (eachField.getType().isPrimitive()) {
                return 0L;
            }
            boolean oldAccessible = eachField.isAccessible();
            eachField.setAccessible(true);
            try {
                long l = this.visit(eachField.get(each));
                return l;
            }
            catch (Exception e) {
                throw new RuntimeException("Exception trying to access field " + eachField, e);
            }
            finally {
                eachField.setAccessible(oldAccessible);
            }
        }
    }
}

