/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.jboss.deployer.structure;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileFilter;

public abstract class PathPattern {
    protected final String path;
    protected PathPattern next;

    protected PathPattern(String path) {
        this.path = path;
    }

    public void setNext(PathPattern next) {
        this.next = next;
    }

    public PathPattern getNext() {
        return this.next;
    }

    public boolean isExactMatch() {
        return false;
    }

    public String getPath() {
        return this.path;
    }

    public VirtualFile findFile(VirtualFile root) throws IOException {
        VirtualFile dir;
        VirtualFile virtualFile = dir = this.path.length() == 0 ? root : root.getChild(this.path);
        if (dir == null) {
            return null;
        }
        List result = dir.getChildren(new VirtualFileFilter(){

            public boolean accepts(VirtualFile file) {
                return PathPattern.this.match(file.getName());
            }
        });
        if (result.isEmpty()) {
            return null;
        }
        return (VirtualFile)result.get(0);
    }

    public String findFirstMatchingPath(VirtualFile root) throws IOException {
        VirtualFile file = this.findFile(root);
        if (file != null) {
            return this.path + "/" + file.getName();
        }
        return null;
    }

    public boolean match(String name) {
        if (this.doMatch(name)) {
            return true;
        }
        if (this.next != null) {
            return this.next.match(name);
        }
        return false;
    }

    public abstract boolean doMatch(String var1);

    public static PathPattern parse(String pattern) {
        String name;
        String prefix;
        int i = pattern.lastIndexOf(47);
        if (i == -1) {
            prefix = "";
            name = pattern;
        } else {
            prefix = pattern.substring(0, i);
            name = pattern.substring(i + 1);
        }
        i = name.indexOf(42);
        if (i == -1) {
            return new ExactMatchPattern(pattern, name);
        }
        if (i == pattern.length() - 1) {
            return new SuffixPattern(prefix, name.substring(0, i));
        }
        if (i == 0) {
            return new PrefixPattern(prefix, name.substring(1));
        }
        return new WildcardPattern(prefix, name.substring(0, i), name.substring(i + 1));
    }

    public static class CompositePattern
    extends PathPattern {
        protected final List<PathPattern> patterns = new ArrayList<PathPattern>();

        public CompositePattern(String path) {
            super(path);
        }

        public void add(PathPattern pattern) {
            this.patterns.add(pattern);
        }

        @Override
        public boolean doMatch(String name) {
            for (PathPattern pattern : this.patterns) {
                if (!pattern.doMatch(name)) continue;
                return true;
            }
            return false;
        }
    }

    public static class WildcardPattern
    extends PathPattern {
        protected final String prefix;
        protected final String suffix;

        public WildcardPattern(String path, String prefix, String suffix) {
            super(path);
            this.suffix = suffix;
            this.prefix = prefix;
        }

        @Override
        public boolean doMatch(String name) {
            return this.prefix.length() + this.suffix.length() <= name.length() && name.startsWith(this.prefix) && name.endsWith(this.suffix);
        }
    }

    public static class PrefixPattern
    extends PathPattern {
        protected final String suffix;

        public PrefixPattern(String path, String name) {
            super(path);
            this.suffix = name;
        }

        @Override
        public boolean doMatch(String name) {
            return name.endsWith(this.suffix);
        }
    }

    public static class SuffixPattern
    extends PathPattern {
        protected final String prefix;

        public SuffixPattern(String path, String name) {
            super(path);
            this.prefix = name;
        }

        @Override
        public boolean doMatch(String name) {
            return name.startsWith(this.prefix);
        }
    }

    public static class ExactMatchPattern
    extends PathPattern {
        protected final String name;

        public ExactMatchPattern(String path, String name) {
            super(path);
            this.name = name;
        }

        @Override
        public boolean isExactMatch() {
            return true;
        }

        @Override
        public boolean doMatch(String name) {
            return this.name.equals(name);
        }
    }
}

