/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.log4j;

import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Enumeration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Hierarchy;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.DefaultRepositorySelector;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.RootLogger;
import org.apache.log4j.xml.DOMConfigurator;

public class Log4JHelper {
    private static final Log log = LogFactory.getLog(Log4JHelper.class);

    public static ArrayList<String> getFileAppendersFiles(LoggerRepository loggerRepository) {
        ArrayList<String> logFiles = new ArrayList<String>();
        Enumeration appenders = loggerRepository.getRootLogger().getAllAppenders();
        while (appenders.hasMoreElements()) {
            Appender appender = (Appender)appenders.nextElement();
            if (!(appender instanceof FileAppender)) continue;
            FileAppender fileAppender = (FileAppender)appender;
            logFiles.add(fileAppender.getFile());
        }
        return logFiles;
    }

    public static LoggerRepository getNewLoggerRepository(File log4jConfigurationFile) {
        LoggerRepository loggerRepository = null;
        try {
            loggerRepository = new DefaultRepositorySelector((LoggerRepository)new Hierarchy((Logger)new RootLogger(Level.DEBUG))).getLoggerRepository();
            new DOMConfigurator().doConfigure(log4jConfigurationFile.toURI().toURL(), loggerRepository);
            log.debug((Object)("Log4j configuration " + log4jConfigurationFile + " succesfully loaded."));
        }
        catch (MalformedURLException e) {
            log.error((Object)("Could not load " + log4jConfigurationFile), (Throwable)e);
        }
        return loggerRepository;
    }

    public static ArrayList<String> getFileAppendersFiles(File log4jConfigurationFile) {
        return Log4JHelper.getFileAppendersFiles(Log4JHelper.getNewLoggerRepository(log4jConfigurationFile));
    }
}

