/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher.config;

import java.io.File;
import org.nuxeo.launcher.config.ConfigurationException;
import org.nuxeo.launcher.config.ConfigurationGenerator;
import org.nuxeo.launcher.config.ServerConfigurator;

public class JettyConfigurator
extends ServerConfigurator {
    public static final String JETTY_CONFIG = "config/sql.properties";
    public static final String DEFAULT_DATA_DIR = "data";
    public static final String DEFAULT_TMP_DIR = "tmp";
    public static final String LAUNCHER_CLASS = "org.nuxeo.runtime.launcher.Main";
    public static final String STARTUP_CLASS = "org.nuxeo.osgi.application.Main";

    public JettyConfigurator(ConfigurationGenerator configurationGenerator) {
        super(configurationGenerator);
    }

    @Override
    protected boolean isConfigured() {
        log.info((Object)"Detected Jetty server.");
        return new File(this.generator.getNuxeoHome(), JETTY_CONFIG).exists();
    }

    @Override
    protected File getOutputDirectory() {
        return this.generator.getNuxeoHome();
    }

    @Override
    protected String getDefaultDataDir() {
        return DEFAULT_DATA_DIR;
    }

    @Override
    public void checkPaths() throws ConfigurationException {
        super.checkPaths();
    }

    @Override
    public String getDefaultTmpDir() {
        return DEFAULT_TMP_DIR;
    }

    @Override
    public File getLogConfFile() {
        return new File(this.getConfigDir(), "log4j.xml");
    }

    @Override
    public File getConfigDir() {
        return new File(this.generator.getNuxeoHome(), "config");
    }

    @Override
    public void prepareWizardStart() {
    }

    @Override
    public void cleanupPostWizard() {
    }

    @Override
    public boolean isWizardAvailable() {
        return false;
    }

    @Override
    protected String getRuntimeHome() {
        return null;
    }
}

