/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher.config;

import freemarker.template.TemplateException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.UUID;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Logger;
import org.apache.log4j.helpers.NullEnumeration;
import org.nuxeo.common.Environment;
import org.nuxeo.launcher.commons.DatabaseDriverException;
import org.nuxeo.launcher.commons.text.TextTemplate;
import org.nuxeo.launcher.config.ConfigurationException;
import org.nuxeo.launcher.config.JBossConfigurator;
import org.nuxeo.launcher.config.JettyConfigurator;
import org.nuxeo.launcher.config.ServerConfigurator;
import org.nuxeo.launcher.config.TomcatConfigurator;
import org.nuxeo.log4j.Log4JHelper;

public class ConfigurationGenerator {
    protected static final String CONFIGURATION_PROPERTIES = "configuration.properties";
    private static final Log log = LogFactory.getLog(ConfigurationGenerator.class);
    @Deprecated
    public static final String NUXEO_HOME = "nuxeo.home";
    public static final String NUXEO_CONF = "nuxeo.conf";
    public static final String TEMPLATES = "templates";
    protected static final String NUXEO_DEFAULT_CONF = "nuxeo.defaults";
    @Deprecated
    public static final String PARAM_TEMPLATE_NAME = "nuxeo.template";
    public static final String PARAM_TEMPLATES_NAME = "nuxeo.templates";
    public static final String PARAM_TEMPLATE_DBNAME = "nuxeo.dbtemplate";
    public static final String PARAM_TEMPLATE_DBTYPE = "nuxeo.db.type";
    public static final String PARAM_TEMPLATES_NODB = "nuxeo.nodbtemplates";
    public static final String OLD_PARAM_TEMPLATES_PARSING_EXTENSIONS = "nuxeo.templates.parsing.extensions";
    public static final String PARAM_TEMPLATES_PARSING_EXTENSIONS = "nuxeo.plaintext_parsing_extensions";
    public static final String PARAM_TEMPLATES_FREEMARKER_EXTENSIONS = "nuxeo.freemarker_parsing_extensions";
    protected static final String PARAM_INCLUDED_TEMPLATES = "nuxeo.template.includes";
    public static final String PARAM_FORCE_GENERATION = "nuxeo.force.generation";
    public static final String BOUNDARY_BEGIN = "### BEGIN - DO NOT EDIT BETWEEN BEGIN AND END ###";
    public static final String BOUNDARY_END = "### END - DO NOT EDIT BETWEEN BEGIN AND END ###";
    public static final List<String> DB_LIST = Arrays.asList("default", "postgresql", "oracle", "mysql", "mssql");
    public static final String PARAM_WIZARD_DONE = "nuxeo.wizard.done";
    public static final String PARAM_WIZARD_RESTART_PARAMS = "wizard.restart.params";
    public static final String PARAM_FAKE_WINDOWS = "org.nuxeo.fake.vindoz";
    public static final String PARAM_LOOPBACK_URL = "nuxeo.loopback.url";
    public static final int MIN_PORT = 1;
    public static final int MAX_PORT = 65535;
    public static final int ADDRESS_PING_TIMEOUT = 1000;
    public static final String PARAM_BIND_ADDRESS = "nuxeo.bind.address";
    public static final String PARAM_HTTP_PORT = "nuxeo.server.http.port";
    public static final String PARAM_STATUS_KEY = "server.status.key";
    public static final String PARAM_CONTEXT_PATH = "org.nuxeo.ecm.contextPath";
    public static final String PARAM_MP_DIR = "nuxeo.distribution.marketplace.dir";
    public static final String DISTRIBUTION_MP_DIR = "setupWizardDownloads";
    public static final String INSTALL_AFTER_RESTART = "installAfterRestart.log";
    public static final String PARAM_DB_DRIVER = "nuxeo.db.driver";
    public static final String PARAM_DB_JDBC_URL = "nuxeo.db.jdbc.url";
    public static final String PARAM_DB_HOST = "nuxeo.db.host";
    public static final String PARAM_DB_PORT = "nuxeo.db.port";
    public static final String PARAM_DB_NAME = "nuxeo.db.name";
    public static final String PARAM_DB_USER = "nuxeo.db.user";
    public static final String PARAM_DB_PWD = "nuxeo.db.password";
    public static final String PARAM_PRODUCT_NAME = "org.nuxeo.ecm.product.name";
    public static final String PARAM_PRODUCT_VERSION = "org.nuxeo.ecm.product.version";
    public static final String PARAM_NUXEO_URL = "nuxeo.url";
    public static final String NUXEO_DEV_SYSTEM_PROP = "org.nuxeo.dev";
    public static final String SEAM_DEBUG_SYSTEM_PROP = "org.nuxeo.seam.debug";
    @Deprecated
    public static final String SEAM_HOT_RELOAD_GLOBAL_CONFIG_FILE = "seam-debug.properties";
    private final File nuxeoHome;
    private final File nuxeoConf;
    private final List<File> includedTemplates = new ArrayList<File>();
    private File nuxeoDefaultConf;
    public boolean isJBoss;
    public boolean isJetty;
    public boolean isTomcat;
    private ServerConfigurator serverConfigurator;
    private boolean forceGeneration;
    private Properties defaultConfig;
    private Properties userConfig;
    private boolean configurable = false;
    private boolean onceGeneration = false;
    private String templates;
    private boolean setOnceToFalse = true;
    private boolean setFalseToOnce = false;
    private boolean quiet = false;
    private boolean debug = false;
    private static boolean hideDeprecationWarnings = false;
    private Environment env;
    private static Map<String, String> parametersMigration;

    public boolean isConfigurable() {
        return this.configurable;
    }

    public ConfigurationGenerator() {
        this(true, false);
    }

    public ConfigurationGenerator(boolean quiet, boolean debug) {
        File userDir;
        this.quiet = quiet;
        this.debug = debug;
        String nuxeoHomePath = System.getProperty(NUXEO_HOME);
        this.nuxeoHome = nuxeoHomePath != null ? new File(nuxeoHomePath) : ("bin".equalsIgnoreCase((userDir = new File(System.getProperty("user.dir"))).getName()) ? userDir.getParentFile() : userDir);
        String nuxeoConfPath = System.getProperty(NUXEO_CONF);
        this.nuxeoConf = nuxeoConfPath != null ? new File(nuxeoConfPath).getAbsoluteFile() : new File(this.nuxeoHome, "bin" + File.separator + NUXEO_CONF).getAbsoluteFile();
        System.setProperty(NUXEO_CONF, this.nuxeoConf.getPath());
        this.nuxeoDefaultConf = new File(this.nuxeoHome, TEMPLATES + File.separator + NUXEO_DEFAULT_CONF);
        this.isJBoss = System.getProperty("jboss.home.dir") != null;
        this.isJetty = System.getProperty("jetty.home") != null;
        boolean bl = this.isTomcat = System.getProperty("tomcat.home") != null;
        if (!(this.isJBoss || this.isJetty || this.isTomcat)) {
            String[] files;
            this.isJBoss = new File(this.nuxeoHome, "bin/run.jar").exists();
            this.isTomcat = new File(this.nuxeoHome, "bin/bootstrap.jar").exists();
            for (String file : files = this.nuxeoHome.list()) {
                if (!file.startsWith("nuxeo-runtime-launcher")) continue;
                this.isJetty = true;
                break;
            }
        }
        if (this.isJBoss) {
            this.serverConfigurator = new JBossConfigurator(this);
        } else if (this.isTomcat) {
            this.serverConfigurator = new TomcatConfigurator(this);
        } else if (this.isJetty) {
            this.serverConfigurator = new JettyConfigurator(this);
        }
        if (Logger.getRootLogger().getAllAppenders() instanceof NullEnumeration) {
            this.serverConfigurator.initLogs();
        }
        String homeInfo = "Nuxeo home:          " + this.nuxeoHome.getPath();
        String confInfo = "Nuxeo configuration: " + this.nuxeoConf.getPath();
        if (quiet) {
            log.debug((Object)homeInfo);
            log.debug((Object)confInfo);
        } else {
            log.info((Object)homeInfo);
            log.info((Object)confInfo);
        }
    }

    public void hideDeprecationWarnings(boolean hide) {
        hideDeprecationWarnings = hide;
    }

    public void setForceGeneration(boolean forceGeneration) {
        this.forceGeneration = forceGeneration;
    }

    public boolean isForceGeneration() {
        return this.forceGeneration;
    }

    public Properties getUserConfig() {
        return this.userConfig;
    }

    public final ServerConfigurator getServerConfigurator() {
        return this.serverConfigurator;
    }

    public void run() throws ConfigurationException {
        if (this.init()) {
            if (!this.serverConfigurator.isConfigured()) {
                log.info((Object)"No current configuration, generating files...");
                this.generateFiles();
            } else if (this.forceGeneration) {
                log.info((Object)("Configuration files generation (nuxeo.force.generation=" + this.userConfig.getProperty(PARAM_FORCE_GENERATION, "false") + ")..."));
                this.generateFiles();
            } else {
                log.info((Object)"Server already configured (set nuxeo.force.generation=true to force configuration files generation).");
            }
        }
    }

    public boolean init() {
        return this.init(false);
    }

    public boolean init(boolean forceReload) {
        if (this.serverConfigurator == null) {
            log.warn((Object)"Unrecognized server. Considered as already configured.");
            this.configurable = false;
        } else if (!this.nuxeoConf.exists()) {
            log.info((Object)("Missing " + this.nuxeoConf));
            this.configurable = false;
        } else if (this.userConfig == null || forceReload) {
            try {
                this.setBasicConfiguration();
                this.configurable = true;
            }
            catch (ConfigurationException e) {
                log.warn((Object)"Error reading basic configuration.", (Throwable)e);
                this.configurable = false;
            }
        } else {
            this.configurable = true;
        }
        return this.configurable;
    }

    public void changeTemplates(String newTemplates) {
        try {
            this.templates = newTemplates;
            this.setBasicConfiguration();
            this.configurable = true;
        }
        catch (ConfigurationException e) {
            log.warn((Object)"Error reading basic configuration.", (Throwable)e);
            this.configurable = false;
        }
    }

    public void changeDBTemplate(String dbTemplate) {
        this.changeTemplates(this.rebuildTemplatesStr(dbTemplate));
    }

    private void setBasicConfiguration() throws ConfigurationException {
        boolean isSeamDebugSet;
        String debugPropValue;
        boolean isDebugSet;
        try {
            this.defaultConfig = ConfigurationGenerator.loadTrimmedProperties(this.nuxeoDefaultConf);
            this.userConfig = new Properties(this.defaultConfig);
            if (System.getProperty("os.name").toLowerCase().startsWith("win")) {
                this.replaceBackslashes();
            }
            this.userConfig.putAll((Map<?, ?>)System.getProperties());
            this.userConfig.putAll((Map<?, ?>)ConfigurationGenerator.loadTrimmedProperties(this.nuxeoConf));
            this.onceGeneration = "once".equals(this.userConfig.getProperty(PARAM_FORCE_GENERATION));
            this.forceGeneration = this.onceGeneration || Boolean.parseBoolean(this.userConfig.getProperty(PARAM_FORCE_GENERATION, "false"));
            this.checkForDeprecatedParameters(this.userConfig);
            this.setDirectoryWithProperty("nuxeo.data.dir");
            this.setDirectoryWithProperty("nuxeo.log.dir");
            this.setDirectoryWithProperty("nuxeo.pid.dir");
            this.setDirectoryWithProperty("nuxeo.tmp.dir");
        }
        catch (NullPointerException e) {
            throw new ConfigurationException("Missing file", e);
        }
        catch (FileNotFoundException e) {
            throw new ConfigurationException("Missing file: " + this.nuxeoDefaultConf + " or " + this.nuxeoConf, e);
        }
        catch (IOException e) {
            throw new ConfigurationException("Error reading " + this.nuxeoConf, e);
        }
        try {
            this.includeTemplates();
            this.checkForDeprecatedParameters(this.defaultConfig);
            this.extractDatabaseTemplateName();
        }
        catch (FileNotFoundException e) {
            throw new ConfigurationException("Missing file", e);
        }
        catch (IOException e) {
            throw new ConfigurationException("Error reading " + this.nuxeoConf, e);
        }
        HashMap<String, String> newParametersToSave = this.evalDynamicProperties();
        if (newParametersToSave != null && !newParametersToSave.isEmpty()) {
            this.saveConfiguration(newParametersToSave, false, false);
        }
        if (isDebugSet = Boolean.TRUE.equals(Boolean.valueOf(debugPropValue = this.userConfig.getProperty(NUXEO_DEV_SYSTEM_PROP, "false")))) {
            log.debug((Object)"Nuxeo Dev mode enabled");
        } else {
            log.debug((Object)"Nuxeo Dev mode is not enabled");
        }
        String seamDebugPropValue = this.userConfig.getProperty(SEAM_DEBUG_SYSTEM_PROP, "false");
        boolean bl = isSeamDebugSet = Boolean.TRUE.equals(Boolean.valueOf(seamDebugPropValue)) || this.hasSeamDebugFile();
        if (isSeamDebugSet) {
            log.debug((Object)"Nuxeo Seam HotReload is enabled");
            System.setProperty(SEAM_DEBUG_SYSTEM_PROP, "true");
        } else {
            log.debug((Object)"Nuxeo Seam HotReload is not enabled");
        }
    }

    protected void includeTemplates() throws IOException {
        if (this.templates == null) {
            this.templates = this.getUserTemplates();
        }
        this.includedTemplates.clear();
        List<File> orderedTemplates = this.includeTemplates(this.templates);
        this.includedTemplates.clear();
        this.includedTemplates.addAll(orderedTemplates);
        log.debug(this.includedTemplates);
    }

    @Deprecated
    protected boolean hasSeamDebugFile() {
        File f = new File(this.getServerConfigurator().getConfigDir(), SEAM_HOT_RELOAD_GLOBAL_CONFIG_FILE);
        return f.exists();
    }

    protected HashMap<String, String> evalDynamicProperties() throws ConfigurationException {
        HashMap<String, String> newParametersToSave = new HashMap<String, String>();
        this.evalLoopbackURL();
        this.evalServerStatusKey(newParametersToSave);
        return newParametersToSave;
    }

    private void evalServerStatusKey(Map<String, String> newParametersToSave) throws ConfigurationException {
        if (this.userConfig.getProperty(PARAM_STATUS_KEY) == null) {
            newParametersToSave.put(PARAM_STATUS_KEY, UUID.randomUUID().toString().substring(0, 8));
        }
    }

    private void evalLoopbackURL() throws ConfigurationException {
        String loopbackURL = this.userConfig.getProperty(PARAM_LOOPBACK_URL);
        if (loopbackURL != null) {
            log.debug((Object)("Using configured loop back url: " + loopbackURL));
            return;
        }
        InetAddress bindAddress = this.getBindAddress();
        try {
            if (bindAddress.isAnyLocalAddress()) {
                boolean preferIPv6 = "false".equals(System.getProperty("java.net.preferIPv4Stack")) && "true".equals(System.getProperty("java.net.preferIPv6Addresses"));
                bindAddress = preferIPv6 ? Inet6Address.getByName("::1") : Inet4Address.getByName("127.0.0.1");
                log.debug((Object)("Bind address is \"ANY\", using local address instead: " + bindAddress));
            }
        }
        catch (UnknownHostException e) {
            log.error((Object)e);
        }
        String httpPort = this.userConfig.getProperty(PARAM_HTTP_PORT);
        String contextPath = this.userConfig.getProperty(PARAM_CONTEXT_PATH);
        loopbackURL = bindAddress instanceof Inet6Address ? "http://[" + bindAddress.getHostAddress() + "]:" + httpPort + contextPath : "http://" + bindAddress.getHostAddress() + ":" + httpPort + contextPath;
        log.debug((Object)("Set as loop back URL: " + loopbackURL));
        this.userConfig.setProperty(PARAM_LOOPBACK_URL, loopbackURL);
    }

    protected void replaceBackslashes() throws ConfigurationException {
        StringBuffer sb = new StringBuffer();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(this.nuxeoConf));
            while ((line = reader.readLine()) != null) {
                if (line.matches(".*:\\\\.*")) {
                    line = line.replaceAll("\\\\", "/");
                }
                sb.append(line + System.getProperty("line.separator"));
            }
            reader.close();
        }
        catch (IOException e) {
            throw new ConfigurationException("Error reading " + this.nuxeoConf, e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    throw new ConfigurationException(e);
                }
            }
        }
        FileWriter writer = null;
        try {
            writer = new FileWriter(this.nuxeoConf, false);
            writer.append(sb.toString());
        }
        catch (IOException e) {
            throw new ConfigurationException("Error writing in " + this.nuxeoConf, e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    throw new ConfigurationException(e);
                }
            }
        }
    }

    public void setDirectoryWithProperty(String key) {
        String directory = this.userConfig.getProperty(key);
        if (directory == null) {
            this.userConfig.setProperty(key, this.serverConfigurator.getDirectory(key).getPath());
        } else {
            this.serverConfigurator.setDirectory(key, directory);
        }
    }

    public String getUserTemplates() {
        String userTemplatesList = this.userConfig.getProperty(PARAM_TEMPLATES_NAME);
        if (userTemplatesList == null) {
            userTemplatesList = this.userConfig.getProperty(PARAM_TEMPLATE_NAME);
        }
        if (userTemplatesList == null) {
            log.warn((Object)"No template found in configuration! Fallback on 'default'.");
            userTemplatesList = "default";
        }
        return userTemplatesList;
    }

    protected void generateFiles() throws ConfigurationException {
        try {
            this.serverConfigurator.parseAndCopy(this.userConfig);
            this.serverConfigurator.dumpProperties(this.userConfig);
            log.info((Object)"Configuration files generated.");
            if (this.onceGeneration) {
                this.setOnceToFalse = true;
                this.writeConfiguration(this.loadConfiguration());
            }
        }
        catch (FileNotFoundException e) {
            throw new ConfigurationException("Missing file: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ConfigurationException("Configuration failure: " + e.getMessage(), e);
        }
        catch (TemplateException e) {
            throw new ConfigurationException("Could not process FreeMarker template: " + e.getMessage(), e);
        }
    }

    private StringBuffer loadConfiguration() throws ConfigurationException {
        return this.loadConfiguration(null);
    }

    private void writeConfiguration(StringBuffer configuration) throws ConfigurationException {
        this.writeConfiguration(configuration, null);
    }

    private List<File> includeTemplates(String templatesList) throws IOException {
        ArrayList<File> orderedTemplates = new ArrayList<File>();
        StringTokenizer st = new StringTokenizer(templatesList, ",");
        while (st.hasMoreTokens()) {
            String nextToken = st.nextToken();
            File chosenTemplate = new File(nextToken);
            if (!chosenTemplate.exists() || !chosenTemplate.getPath().equals(chosenTemplate.getAbsolutePath())) {
                chosenTemplate = new File(this.nuxeoDefaultConf.getParentFile(), nextToken);
            }
            if (this.includedTemplates.contains(chosenTemplate)) {
                log.debug((Object)("Already included " + nextToken));
                continue;
            }
            if (!chosenTemplate.exists()) {
                log.error((Object)String.format("Template '%s' not found with relative or absolute path (%s). Check your %s parameter, and %s for included files.", nextToken, chosenTemplate, PARAM_TEMPLATES_NAME, PARAM_INCLUDED_TEMPLATES));
                continue;
            }
            File chosenTemplateConf = new File(chosenTemplate, NUXEO_DEFAULT_CONF);
            this.includedTemplates.add(chosenTemplate);
            if (!chosenTemplateConf.exists()) {
                log.warn((Object)("Ignore template (no default configuration): " + nextToken));
                continue;
            }
            Properties subTemplateConf = ConfigurationGenerator.loadTrimmedProperties(chosenTemplateConf);
            String subTemplatesList = subTemplateConf.getProperty(PARAM_INCLUDED_TEMPLATES);
            if (subTemplatesList != null && subTemplatesList.length() > 0) {
                orderedTemplates.addAll(this.includeTemplates(subTemplatesList));
            }
            this.defaultConfig.putAll((Map<?, ?>)subTemplateConf);
            orderedTemplates.add(chosenTemplate);
            String templateInfo = "Include template: " + chosenTemplate.getPath();
            if (this.quiet) {
                log.debug((Object)templateInfo);
                continue;
            }
            log.info((Object)templateInfo);
        }
        return orderedTemplates;
    }

    protected void checkForDeprecatedParameters(Properties properties) {
        Enumeration<?> userEnum = properties.propertyNames();
        while (userEnum.hasMoreElements()) {
            String key = (String)userEnum.nextElement();
            if (!parametersMigration.containsKey(key)) continue;
            String value = properties.getProperty(key);
            properties.setProperty(parametersMigration.get(key), value);
            if (hideDeprecationWarnings) continue;
            log.warn((Object)("Parameter " + key + " is deprecated - please use " + parametersMigration.get(key) + " instead"));
        }
    }

    public File getNuxeoHome() {
        return this.nuxeoHome;
    }

    public File getNuxeoDefaultConf() {
        return this.nuxeoDefaultConf;
    }

    public List<File> getIncludedTemplates() {
        return this.includedTemplates;
    }

    public static void main(String[] args) throws ConfigurationException {
        new ConfigurationGenerator().run();
    }

    public void saveConfiguration(Map<String, String> changedParameters) throws ConfigurationException {
        this.saveConfiguration(changedParameters, false, true);
    }

    public void saveConfiguration(Map<String, String> changedParameters, boolean setGenerationOnceToFalse, boolean setGenerationFalseToOnce) throws ConfigurationException {
        this.setOnceToFalse = setGenerationOnceToFalse;
        this.setFalseToOnce = setGenerationFalseToOnce;
        this.writeConfiguration(this.loadConfiguration(changedParameters), changedParameters);
        for (String key : changedParameters.keySet()) {
            if (changedParameters.get(key) == null) continue;
            this.userConfig.setProperty(key, changedParameters.get(key));
        }
    }

    public void saveFilteredConfiguration(Map<String, String> changedParameters) throws ConfigurationException {
        String newDbTemplate = changedParameters.remove(PARAM_TEMPLATE_DBNAME);
        if (newDbTemplate != null) {
            changedParameters.put(PARAM_TEMPLATES_NAME, this.rebuildTemplatesStr(newDbTemplate));
        }
        this.saveConfiguration(this.getChangedParameters(changedParameters));
    }

    public Map<String, String> getChangedParameters(Map<String, String> changedParameters) {
        HashMap<String, String> filteredChangedParameters = new HashMap<String, String>();
        for (String key : changedParameters.keySet()) {
            String oldParam = this.userConfig.getProperty(key);
            String newParam = changedParameters.get(key);
            if (newParam != null) {
                newParam = newParam.trim();
            }
            if ((oldParam != null || newParam == null || newParam.isEmpty()) && (oldParam == null || oldParam.trim().equals(newParam))) continue;
            filteredChangedParameters.put(key, newParam);
        }
        return filteredChangedParameters;
    }

    private void writeConfiguration(StringBuffer newContent, Map<String, String> changedParameters) throws ConfigurationException {
        FileWriter writer = null;
        try {
            writer = new FileWriter(this.nuxeoConf, false);
            writer.append(newContent.toString());
            if (changedParameters != null && !changedParameters.isEmpty()) {
                writer.write("### BEGIN - DO NOT EDIT BETWEEN BEGIN AND END ### " + new Date().toString() + System.getProperty("line.separator"));
                for (String key : changedParameters.keySet()) {
                    writer.write("#" + key + "=" + this.userConfig.getProperty(key, "") + System.getProperty("line.separator"));
                    if (changedParameters.get(key) == null) continue;
                    writer.write(key + "=" + changedParameters.get(key) + System.getProperty("line.separator"));
                }
                writer.write(BOUNDARY_END + System.getProperty("line.separator"));
            }
        }
        catch (IOException e) {
            throw new ConfigurationException("Error writing in " + this.nuxeoConf, e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    throw new ConfigurationException(e);
                }
            }
        }
    }

    private StringBuffer loadConfiguration(Map<String, String> changedParameters) throws ConfigurationException {
        String wizardParam = null;
        String templatesParam = null;
        Integer generationIndex = null;
        Integer wizardIndex = null;
        Integer templatesIndex = null;
        if (changedParameters != null) {
            wizardParam = changedParameters.remove(PARAM_WIZARD_DONE);
            templatesParam = changedParameters.remove(PARAM_TEMPLATES_NAME);
        }
        ArrayList<String> newLines = new ArrayList<String>();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(this.nuxeoConf));
            boolean onConfiguratorContent = false;
            while ((line = reader.readLine()) != null) {
                if (!onConfiguratorContent) {
                    if (!line.startsWith(BOUNDARY_BEGIN)) {
                        if (line.startsWith(PARAM_FORCE_GENERATION)) {
                            if (this.setOnceToFalse && this.onceGeneration) {
                                line = "nuxeo.force.generation=false";
                            }
                            if (this.setFalseToOnce && !this.forceGeneration) {
                                line = "nuxeo.force.generation=once";
                            }
                            if (generationIndex == null) {
                                newLines.add(line);
                                generationIndex = newLines.size() - 1;
                                continue;
                            }
                            newLines.set(generationIndex, line);
                            continue;
                        }
                        if (line.startsWith(PARAM_WIZARD_DONE)) {
                            if (wizardParam != null) {
                                line = "nuxeo.wizard.done=" + wizardParam;
                            }
                            if (wizardIndex == null) {
                                newLines.add(line);
                                wizardIndex = newLines.size() - 1;
                                continue;
                            }
                            newLines.set(wizardIndex, line);
                            continue;
                        }
                        if (line.startsWith(PARAM_TEMPLATES_NAME)) {
                            if (templatesParam != null) {
                                line = "nuxeo.templates=" + templatesParam;
                            }
                            if (templatesIndex == null) {
                                newLines.add(line);
                                templatesIndex = newLines.size() - 1;
                                continue;
                            }
                            newLines.set(templatesIndex, line);
                            continue;
                        }
                        newLines.add(line);
                        continue;
                    }
                    if (templatesIndex == null && templatesParam != null) {
                        newLines.add("nuxeo.templates=" + templatesParam);
                        templatesIndex = newLines.size() - 1;
                    }
                    if (wizardIndex == null && wizardParam != null) {
                        newLines.add("nuxeo.wizard.done=" + wizardParam);
                        wizardIndex = newLines.size() - 1;
                    }
                    onConfiguratorContent = true;
                    continue;
                }
                if (!line.startsWith(BOUNDARY_END)) {
                    String value;
                    String key;
                    if (changedParameters == null) {
                        newLines.add(line);
                        continue;
                    }
                    int equalIdx = line.indexOf("=");
                    if (line.startsWith("#nuxeo.templates") || line.startsWith(PARAM_TEMPLATES_NAME) || equalIdx < 1) continue;
                    if (line.trim().startsWith("#")) {
                        key = line.substring(1, equalIdx).trim();
                        value = line.substring(equalIdx + 1).trim();
                        this.userConfig.setProperty(key, value);
                        continue;
                    }
                    key = line.substring(0, equalIdx).trim();
                    value = line.substring(equalIdx + 1).trim();
                    if (!changedParameters.containsKey(key)) {
                        changedParameters.put(key, value);
                        continue;
                    }
                    if (value.equals(changedParameters.get(key))) continue;
                    this.userConfig.setProperty(key, value);
                    continue;
                }
                onConfiguratorContent = false;
            }
            reader.close();
        }
        catch (IOException e) {
            throw new ConfigurationException("Error reading " + this.nuxeoConf, e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    throw new ConfigurationException(e);
                }
            }
        }
        StringBuffer newContent = new StringBuffer();
        for (int i = 0; i < newLines.size(); ++i) {
            newContent.append(((String)newLines.get(i)).trim() + System.getProperty("line.separator"));
        }
        return newContent;
    }

    public String extractDatabaseTemplateName() {
        String dbTemplate = "unknown";
        String nodbTemplates = "";
        StringTokenizer st = new StringTokenizer(this.templates, ",");
        while (st.hasMoreTokens()) {
            String template = st.nextToken();
            if (DB_LIST.contains(template)) {
                dbTemplate = template;
                continue;
            }
            nodbTemplates = nodbTemplates + "," + template;
        }
        if (nodbTemplates.startsWith(",")) {
            nodbTemplates = nodbTemplates.substring(1);
        }
        this.userConfig.put(PARAM_TEMPLATES_NODB, nodbTemplates);
        this.userConfig.put(PARAM_TEMPLATE_DBNAME, dbTemplate);
        return dbTemplate;
    }

    public File getNuxeoConf() {
        return this.nuxeoConf;
    }

    public void initLogs() {
        this.serverConfigurator.initLogs();
    }

    public File getLogDir() {
        return this.serverConfigurator.getLogDir();
    }

    public File getPidDir() {
        return this.serverConfigurator.getPidDir();
    }

    public File getDataDir() {
        return this.serverConfigurator.getDataDir();
    }

    public void verifyInstallation() throws ConfigurationException {
        this.checkJavaVersion();
        this.ifNotExistsAndIsDirectoryThenCreate(this.getLogDir());
        this.ifNotExistsAndIsDirectoryThenCreate(this.getPidDir());
        this.ifNotExistsAndIsDirectoryThenCreate(this.getDataDir());
        this.ifNotExistsAndIsDirectoryThenCreate(this.getTmpDir());
        this.serverConfigurator.checkPaths();
        this.serverConfigurator.removeExistingLocks();
        this.checkAddressesAndPorts();
        if (!"default".equals(this.userConfig.getProperty(PARAM_TEMPLATE_DBTYPE))) {
            try {
                this.checkDatabaseConnection(this.userConfig.getProperty(PARAM_TEMPLATE_DBNAME), this.userConfig.getProperty(PARAM_DB_NAME), this.userConfig.getProperty(PARAM_DB_USER), this.userConfig.getProperty(PARAM_DB_PWD), this.userConfig.getProperty(PARAM_DB_HOST), this.userConfig.getProperty(PARAM_DB_PORT));
            }
            catch (FileNotFoundException e) {
                throw new ConfigurationException(e);
            }
            catch (IOException e) {
                throw new ConfigurationException(e);
            }
            catch (DatabaseDriverException e) {
                log.error((Object)e);
                throw new ConfigurationException("Could not find database driver: " + e.getMessage());
            }
            catch (SQLException e) {
                log.error((Object)e);
                throw new ConfigurationException("Failed to connect on database: " + e.getMessage());
            }
        }
    }

    public void checkJavaVersion() throws ConfigurationException {
        String version = System.getProperty("java.version");
        if (!version.startsWith("1.6") && !version.startsWith("1.7")) {
            String message = "Nuxeo requires Java 6 or 7 (detected " + version + ").";
            if ("nofail".equalsIgnoreCase(System.getProperty("jvmcheck", "fail"))) {
                log.error((Object)message);
            } else {
                throw new ConfigurationException(message);
            }
        }
    }

    public void checkAddressesAndPorts() throws ConfigurationException {
        InetAddress bindAddress = this.getBindAddress();
        if (bindAddress.isMulticastAddress()) {
            throw new ConfigurationException("Multicast address won't work: " + bindAddress);
        }
        ConfigurationGenerator.checkAddressReachable(bindAddress);
        ConfigurationGenerator.checkPortAvailable(bindAddress, Integer.parseInt(this.userConfig.getProperty(PARAM_HTTP_PORT)));
    }

    private InetAddress getBindAddress() throws ConfigurationException {
        InetAddress bindAddress;
        try {
            bindAddress = InetAddress.getByName(this.userConfig.getProperty(PARAM_BIND_ADDRESS));
            log.debug((Object)("Configured bind address: " + bindAddress));
        }
        catch (UnknownHostException e) {
            throw new ConfigurationException(e);
        }
        return bindAddress;
    }

    public static void checkAddressReachable(InetAddress address) throws ConfigurationException {
        try {
            log.debug((Object)("Checking availability of " + address));
            address.isReachable(1000);
        }
        catch (IOException e) {
            throw new ConfigurationException("Unreachable bind address " + address);
        }
    }

    public static void checkPortAvailable(InetAddress address, int port) throws ConfigurationException {
        if (port < 1 || port > 65535) {
            throw new IllegalArgumentException("Invalid port: " + port);
        }
        ServerSocket socketTCP = null;
        try {
            log.debug((Object)("Checking availability of port " + port + " on address " + address));
            socketTCP = new ServerSocket(port, 0, address);
            socketTCP.setReuseAddress(true);
        }
        catch (IOException e) {
            throw new ConfigurationException("Port is unavailable: " + port + " on address " + address + " (" + e.getMessage() + ")", e);
        }
        finally {
            if (socketTCP != null) {
                try {
                    socketTCP.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public File getTmpDir() {
        return this.serverConfigurator.getTmpDir();
    }

    private void ifNotExistsAndIsDirectoryThenCreate(File directory) {
        if (!directory.isDirectory()) {
            directory.mkdirs();
        }
    }

    public ArrayList<String> getLogFiles() {
        File log4jConfFile = this.serverConfigurator.getLogConfFile();
        System.setProperty("nuxeo.log.dir", this.getLogDir().getPath());
        return Log4JHelper.getFileAppendersFiles(log4jConfFile);
    }

    public boolean isWizardRequired() {
        return !"true".equalsIgnoreCase(this.getUserConfig().getProperty(PARAM_WIZARD_DONE, "true")) && this.serverConfigurator.isWizardAvailable();
    }

    public String rebuildTemplatesStr(String dbTemplate) {
        String nodbTemplates = this.userConfig.getProperty(PARAM_TEMPLATES_NODB);
        if (nodbTemplates == null) {
            this.extractDatabaseTemplateName();
            nodbTemplates = this.userConfig.getProperty(PARAM_TEMPLATES_NODB);
        }
        String newTemplates = nodbTemplates.isEmpty() ? dbTemplate : dbTemplate + "," + nodbTemplates;
        return newTemplates;
    }

    public File getConfigDir() {
        return this.serverConfigurator.getConfigDir();
    }

    public void prepareWizardStart() {
        this.serverConfigurator.prepareWizardStart();
    }

    public void cleanupPostWizard() {
        this.serverConfigurator.cleanupPostWizard();
    }

    public File getRuntimeHome() {
        return this.serverConfigurator.getRuntimeHome();
    }

    public boolean isInstallInProgress() {
        return this.getInstallFile().exists();
    }

    public File getDistributionMPDir() {
        String mpDir = this.userConfig.getProperty(PARAM_MP_DIR, DISTRIBUTION_MP_DIR);
        return new File(this.getNuxeoHome(), mpDir);
    }

    public File getInstallFile() {
        return new File(this.serverConfigurator.getDataDir(), INSTALL_AFTER_RESTART);
    }

    public void addTemplate(String template) throws ConfigurationException {
        HashMap<String, String> newParametersToSave = new HashMap<String, String>();
        String oldTemplates = this.userConfig.getProperty(PARAM_TEMPLATES_NAME);
        String[] oldTemplatesSplit = oldTemplates.split(",");
        if (!Arrays.asList(oldTemplatesSplit).contains(template)) {
            String newTemplates = oldTemplates + (oldTemplates.length() > 0 ? "," : "") + template;
            newParametersToSave.put(PARAM_TEMPLATES_NAME, newTemplates);
            this.saveFilteredConfiguration(newParametersToSave);
            this.changeTemplates(newTemplates);
        }
    }

    public void rmTemplate(String template) throws ConfigurationException {
        HashMap<String, String> newParametersToSave = new HashMap<String, String>();
        String oldTemplates = this.userConfig.getProperty(PARAM_TEMPLATES_NAME);
        List<String> oldTemplatesSplit = Arrays.asList(oldTemplates.split(","));
        if (oldTemplatesSplit.contains(template)) {
            StringBuffer newTemplates = new StringBuffer();
            boolean firstIem = true;
            for (String templateItem : oldTemplatesSplit) {
                if (template.equals(templateItem)) continue;
                newTemplates.append((firstIem ? "" : ",") + templateItem);
                firstIem = false;
            }
            newParametersToSave.put(PARAM_TEMPLATES_NAME, newTemplates.toString());
            this.saveFilteredConfiguration(newParametersToSave);
            this.changeTemplates(newTemplates.toString());
        }
    }

    public String setProperty(String key, String value) throws ConfigurationException {
        HashMap<String, String> newParametersToSave = new HashMap<String, String>();
        newParametersToSave.put(key, value);
        String oldValue = this.userConfig.getProperty(key);
        this.saveFilteredConfiguration(newParametersToSave);
        this.setBasicConfiguration();
        return oldValue;
    }

    public void checkDatabaseConnection(String databaseTemplate, String dbName, String dbUser, String dbPassword, String dbHost, String dbPort) throws FileNotFoundException, IOException, DatabaseDriverException, SQLException {
        String connectionUrl;
        String classname;
        File databaseTemplateDir = new File(this.nuxeoHome, TEMPLATES + File.separator + databaseTemplate);
        Properties templateProperties = ConfigurationGenerator.loadTrimmedProperties(new File(databaseTemplateDir, NUXEO_DEFAULT_CONF));
        if (this.userConfig.getProperty(PARAM_TEMPLATE_DBNAME).equals(databaseTemplateDir)) {
            classname = this.userConfig.getProperty(PARAM_DB_DRIVER);
            connectionUrl = this.userConfig.getProperty(PARAM_DB_JDBC_URL);
        } else {
            classname = this.userConfig.containsKey(PARAM_DB_DRIVER) ? (String)this.userConfig.get(PARAM_DB_DRIVER) : templateProperties.getProperty(PARAM_DB_DRIVER);
            connectionUrl = this.userConfig.containsKey(PARAM_DB_JDBC_URL) ? (String)this.userConfig.get(PARAM_DB_JDBC_URL) : templateProperties.getProperty(PARAM_DB_JDBC_URL);
        }
        Driver driver = this.lookupDriver(databaseTemplate, databaseTemplateDir, classname);
        DriverManager.registerDriver(driver);
        TextTemplate tt = new TextTemplate();
        tt.setVariable(PARAM_DB_HOST, dbHost);
        tt.setVariable(PARAM_DB_PORT, dbPort);
        tt.setVariable(PARAM_DB_NAME, dbName);
        Properties props = new Properties();
        props.put("user", dbUser);
        props.put("password", dbPassword);
        String url = tt.processText(connectionUrl);
        log.debug((Object)("Testing URL " + url + " with " + props));
        Connection con = driver.connect(url, props);
        con.close();
    }

    private Driver lookupDriver(String databaseTemplate, File databaseTemplateDir, String classname) throws FileNotFoundException, IOException, DatabaseDriverException {
        File[] files = (File[])ArrayUtils.addAll((Object[])new File(databaseTemplateDir, "lib").listFiles(), (Object[])this.serverConfigurator.getServerLibDir().listFiles());
        ArrayList<URL> urlsList = new ArrayList<URL>();
        for (File file : files) {
            if (!file.getName().endsWith("jar")) continue;
            try {
                urlsList.add(new URL("jar:file:" + file.getPath() + "!/"));
                log.debug((Object)("Added " + file.getPath()));
            }
            catch (MalformedURLException e) {
                log.error((Object)e);
            }
        }
        URLClassLoader ucl = new URLClassLoader(urlsList.toArray(new URL[0]));
        try {
            return (Driver)Class.forName(classname, true, ucl).newInstance();
        }
        catch (InstantiationException e) {
            throw new DatabaseDriverException(e);
        }
        catch (IllegalAccessException e) {
            throw new DatabaseDriverException(e);
        }
        catch (ClassNotFoundException e) {
            throw new DatabaseDriverException(e);
        }
    }

    public Environment getEnv() {
        if (this.env == null) {
            this.env = new Environment(this.getRuntimeHome());
            this.env.init();
            this.env.setServerHome(this.getNuxeoHome());
            this.env.setData(new File(this.userConfig.getProperty("nuxeo.data.dir")));
            this.env.setLog(new File(this.userConfig.getProperty("nuxeo.log.dir")));
            this.env.setTemp(new File(this.userConfig.getProperty("nuxeo.tmp.dir")));
            File distribFile = new File(new File(this.nuxeoHome, TEMPLATES), "common/config/distribution.properties");
            if (distribFile.exists()) {
                try {
                    this.env.loadProperties(ConfigurationGenerator.loadTrimmedProperties(distribFile));
                }
                catch (FileNotFoundException e) {
                    log.error((Object)e);
                }
                catch (IOException e) {
                    log.error((Object)e);
                }
            }
            this.env.loadProperties(this.userConfig);
            this.env.setProperty(PARAM_MP_DIR, this.getDistributionMPDir().getAbsolutePath());
        }
        return this.env;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadTrimmedProperties(File propsFile) throws IOException {
        Properties props = new Properties();
        FileInputStream propsIS = new FileInputStream(propsFile);
        try {
            ConfigurationGenerator.loadTrimmedProperties(props, propsIS);
        }
        finally {
            propsIS.close();
        }
        return props;
    }

    public static void loadTrimmedProperties(Properties props, InputStream propsIS) throws IOException {
        if (props == null) {
            return;
        }
        Properties p = new Properties();
        p.load(propsIS);
        Enumeration<?> pEnum = p.propertyNames();
        while (pEnum.hasMoreElements()) {
            String key = (String)pEnum.nextElement();
            String value = p.getProperty(key);
            props.put(key.trim(), value.trim());
        }
    }

    public File getDumpedConfig() {
        return new File(this.getConfigDir(), CONFIGURATION_PROPERTIES);
    }

    static {
        HashMap<String, String> tempPM = new HashMap<String, String>();
        tempPM.put(OLD_PARAM_TEMPLATES_PARSING_EXTENSIONS, PARAM_TEMPLATES_PARSING_EXTENSIONS);
        tempPM.put("nuxeo.db.user.separator.key", "nuxeo.db.user_separator_key");
        tempPM.put("nuxeo.server.tomcat-admin.port", "nuxeo.server.tomcat_admin.port");
        tempPM.put("mail.pop3.host", "mail.store.host");
        tempPM.put("mail.pop3.port", "mail.store.port");
        tempPM.put("mail.smtp.host", "mail.transport.host");
        tempPM.put("mail.smtp.port", "mail.transport.port");
        tempPM.put("mail.smtp.username", "mail.transport.user");
        tempPM.put("mail.smtp.password", "mail.transport.password");
        tempPM.put("mail.smtp.usetls", "mail.transport.usetls");
        tempPM.put("mail.smtp.auth", "mail.transport.auth");
        parametersMigration = tempPM;
    }
}

