/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher.info;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.nuxeo.connect.update.NuxeoValidationState;
import org.nuxeo.connect.update.Package;
import org.nuxeo.connect.update.PackageDependency;
import org.nuxeo.connect.update.PackageState;
import org.nuxeo.connect.update.PackageType;
import org.nuxeo.connect.update.PackageVisibility;
import org.nuxeo.connect.update.ProductionState;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="package")
@XmlType(propOrder={"id", "state", "version", "name", "type", "visibility", "targetPlatforms", "vendor", "supportsHotReload", "supported", "productionState", "validationState", "provides", "dependencies", "conflicts", "title", "description", "homePage", "licenseType", "licenseUrl"})
public class PackageInfo {
    public String name;
    public String version;
    public String id;
    public PackageState state;
    public String title;
    public String description;
    public String homePage;
    public String licenseType;
    public String licenseUrl;
    public ProductionState productionState;
    public NuxeoValidationState validationState;
    public String[] targetPlatforms;
    public PackageType type;
    public String vendor;
    public PackageVisibility visibility;
    public PackageDependency[] provides;
    public PackageDependency[] dependencies;
    public PackageDependency[] conflicts;
    public boolean supportsHotReload;
    public boolean supported;

    public PackageInfo() {
    }

    @Deprecated
    public PackageInfo(String name, String version, String id, int state) {
        this.name = name;
        this.version = version;
        this.id = id;
        this.state = PackageState.getByValue((int)state);
    }

    public PackageInfo(Package pkg) {
        this.name = pkg.getName();
        this.version = pkg.getVersion().toString();
        this.id = pkg.getId();
        this.state = PackageState.getByValue((int)pkg.getState());
        this.title = pkg.getTitle();
        this.description = pkg.getDescription();
        this.homePage = pkg.getHomePage();
        this.licenseType = pkg.getLicenseType();
        this.licenseUrl = pkg.getLicenseUrl();
        this.productionState = pkg.getProductionState();
        this.validationState = pkg.getValidationState();
        this.targetPlatforms = pkg.getTargetPlatforms();
        this.type = pkg.getType();
        this.vendor = pkg.getVendor();
        this.visibility = pkg.getVisibility();
        if (this.visibility == null) {
            this.visibility = PackageVisibility.UNKNOWN;
        }
        this.provides = pkg.getProvides();
        this.dependencies = pkg.getDependencies();
        this.conflicts = pkg.getConflicts();
        this.supportsHotReload = pkg.supportsHotReload();
        this.supported = pkg.isSupported();
    }
}

