/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher.config.backingservices;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.codec.CryptoProperties;
import org.nuxeo.common.utils.TextTemplate;
import org.nuxeo.launcher.commons.DatabaseDriverException;
import org.nuxeo.launcher.config.ConfigurationException;
import org.nuxeo.launcher.config.ConfigurationGenerator;
import org.nuxeo.launcher.config.backingservices.BackingChecker;

public class DBCheck
implements BackingChecker {
    private static final Log log = LogFactory.getLog(DBCheck.class);
    public static final List<String> DB_EXCLUDE_CHECK_LIST = Arrays.asList("default", "none");

    @Override
    public boolean accepts(ConfigurationGenerator cg) {
        return !DB_EXCLUDE_CHECK_LIST.contains(cg.getUserConfig().getProperty("nuxeo.db.type"));
    }

    @Override
    public void check(ConfigurationGenerator cg) throws ConfigurationException {
        try {
            this.checkDatabaseConnection(cg);
        }
        catch (IOException e) {
            throw new ConfigurationException(e);
        }
        catch (DatabaseDriverException e) {
            log.debug((Object)e, (Throwable)e);
            log.error((Object)e.getMessage());
            throw new ConfigurationException("Could not find database driver: " + e.getMessage());
        }
        catch (SQLException e) {
            log.debug((Object)e, (Throwable)e);
            log.error((Object)e.getMessage());
            throw new ConfigurationException("Failed to connect on database: " + e.getMessage());
        }
    }

    public void checkDatabaseConnection(ConfigurationGenerator cg) throws FileNotFoundException, IOException, DatabaseDriverException, SQLException {
        String connectionUrl;
        String classname;
        CryptoProperties config = cg.getUserConfig();
        String databaseTemplate = config.getProperty("nuxeo.dbtemplate");
        String dbName = config.getProperty("nuxeo.db.name");
        String dbUser = config.getProperty("nuxeo.db.user");
        String dbPassword = config.getProperty("nuxeo.db.password");
        String dbHost = config.getProperty("nuxeo.db.host");
        String dbPort = config.getProperty("nuxeo.db.port");
        File databaseTemplateDir = new File(cg.getNuxeoHome(), "templates" + File.separator + databaseTemplate);
        Properties templateProperties = ConfigurationGenerator.loadTrimmedProperties(new File(databaseTemplateDir, "nuxeo.defaults"));
        if (config.getProperty("nuxeo.dbtemplate").equals(databaseTemplateDir)) {
            classname = config.getProperty("nuxeo.db.driver");
            connectionUrl = config.getProperty("nuxeo.db.jdbc.url");
        } else {
            classname = config.containsKey((Object)"nuxeo.db.driver") ? (String)config.get((Object)"nuxeo.db.driver") : templateProperties.getProperty("nuxeo.db.driver");
            connectionUrl = config.containsKey((Object)"nuxeo.db.jdbc.url") ? (String)config.get((Object)"nuxeo.db.jdbc.url") : templateProperties.getProperty("nuxeo.db.jdbc.url");
        }
        Driver driver = this.lookupDriver(cg, databaseTemplate, databaseTemplateDir, classname);
        DriverManager.registerDriver(driver);
        Properties ttProps = new Properties((Properties)config);
        ttProps.put("nuxeo.db.host", dbHost);
        ttProps.put("nuxeo.db.port", dbPort);
        ttProps.put("nuxeo.db.name", dbName);
        ttProps.put("nuxeo.db.user", dbUser);
        ttProps.put("nuxeo.db.password", dbPassword);
        TextTemplate tt = new TextTemplate(ttProps);
        String url = tt.processText(connectionUrl);
        Properties conProps = new Properties();
        conProps.put("user", dbUser);
        conProps.put("password", dbPassword);
        log.debug((Object)("Testing URL " + url + " with " + conProps));
        Connection con = driver.connect(url, conProps);
        con.close();
    }

    private Driver lookupDriver(ConfigurationGenerator cg, String databaseTemplate, File databaseTemplateDir, String classname) throws FileNotFoundException, IOException, DatabaseDriverException {
        File[] files = (File[])ArrayUtils.addAll((Object[])new File(databaseTemplateDir, "lib").listFiles(), (Object[])cg.getServerConfigurator().getServerLibDir().listFiles());
        ArrayList<URL> urlsList = new ArrayList<URL>();
        if (files != null) {
            for (File file : files) {
                if (!file.getName().endsWith("jar")) continue;
                try {
                    urlsList.add(new URL("jar:file:" + file.getPath() + "!/"));
                    log.debug((Object)("Added " + file.getPath()));
                }
                catch (MalformedURLException e) {
                    log.error((Object)e);
                }
            }
        }
        URLClassLoader ucl = new URLClassLoader(urlsList.toArray(new URL[0]));
        try {
            return (Driver)Class.forName(classname, true, ucl).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new DatabaseDriverException(e);
        }
    }
}

