/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.bridge;

import org.nuxeo.runtime.bridge.Application;
import org.nuxeo.runtime.bridge.ApplicationDescriptor;
import org.nuxeo.runtime.bridge.ApplicationManager;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class ApplicationLoader
extends DefaultComponent {
    public static final String XP_APPS = "applications";
    private static volatile ApplicationManager mgr;

    public static ApplicationManager getApplicationManager() {
        return mgr;
    }

    public static Application getApplication(String name) {
        ApplicationManager _mgr = mgr;
        return _mgr != null ? (Application)_mgr.getApplication(name) : null;
    }

    public void activate(ComponentContext context) throws Exception {
        mgr = new ApplicationManager();
    }

    public void deactivate(ComponentContext context) throws Exception {
        mgr = null;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (XP_APPS.equals(extensionPoint)) {
            ApplicationDescriptor desc = (ApplicationDescriptor)contribution;
            desc.setBundle(contributor.getContext().getBundle());
            mgr.addApplication(desc);
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (XP_APPS.equals(extensionPoint)) {
            ApplicationDescriptor desc = (ApplicationDescriptor)contribution;
            mgr.removeApplication(desc.getName());
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (ApplicationManager.class == adapter) {
            return (T)mgr;
        }
        return null;
    }
}

