/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.bridge;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.Environment;
import org.nuxeo.runtime.bridge.Application;
import org.nuxeo.runtime.bridge.ApplicationDescriptor;
import org.nuxeo.runtime.bridge.ApplicationFactory;
import org.nuxeo.runtime.bridge.ApplicationLoader;
import org.nuxeo.runtime.bridge.IsolatedClassLoader;

public class ApplicationManager {
    private static final Log log = LogFactory.getLog(ApplicationLoader.class);
    protected Map<String, Application> apps = new ConcurrentHashMap<String, Application>();

    public void addApplication(ApplicationDescriptor desc) throws Exception {
        Application app = this.load(desc);
        this.apps.put(desc.getName(), app);
    }

    public void removeApplication(String name) {
        Application app = this.apps.remove(name);
        if (app != null) {
            log.info((Object)("Unloading application: " + name));
            app.destroy();
        }
    }

    public <T extends Application> T getApplication(String name) {
        return (T)this.apps.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Application load(ApplicationDescriptor desc) throws Exception {
        log.info((Object)("Loading application: " + desc.getName()));
        if (desc.isIsolated()) {
            IsolatedClassLoader cl = this.createIsolatedClassLoader(desc);
            ApplicationFactory factory = (ApplicationFactory)cl.loadClass(desc.getFactory()).newInstance();
            Thread th = Thread.currentThread();
            ClassLoader oldcl = th.getContextClassLoader();
            th.setContextClassLoader(cl);
            try {
                Application application = factory.createApplication(desc);
                return application;
            }
            finally {
                th.setContextClassLoader(oldcl);
            }
        }
        ApplicationFactory factory = (ApplicationFactory)desc.getBundle().loadClass(desc.getFactory()).newInstance();
        return factory.createApplication(desc);
    }

    private void buildClassPath(File dir, String nameSuffix, IsolatedClassLoader cl) throws Exception {
        String[] names = dir.list();
        if (names != null) {
            for (String name : names) {
                if (nameSuffix != null && !name.endsWith(nameSuffix)) continue;
                cl.addURL(new File(dir, name).toURI().toURL());
            }
        }
    }

    private IsolatedClassLoader createIsolatedClassLoader(ApplicationDescriptor desc) throws Exception {
        IsolatedClassLoader cl = new IsolatedClassLoader(this.getClass().getClassLoader());
        List<String> classpath = desc.getClasspath();
        if (classpath != null) {
            File home = Environment.getDefault().getHome();
            for (String path : classpath) {
                int i = path.lastIndexOf("/*");
                if (i > -1) {
                    File dir;
                    String folderPath = path.substring(0, i);
                    File file = dir = folderPath.startsWith("/") ? new File(folderPath) : new File(home, folderPath);
                    if (path.length() == i + 2) {
                        this.buildClassPath(dir, null, cl);
                        continue;
                    }
                    this.buildClassPath(dir, path.substring(i + 2), cl);
                    continue;
                }
                File file = path.startsWith("/") ? new File(path) : new File(home, path);
                cl.addURL(file.toURI().toURL());
            }
        }
        return cl;
    }
}

