/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.bridge;

import java.net.URL;
import java.net.URLClassLoader;

public class IsolatedClassLoader
extends URLClassLoader {
    public IsolatedClassLoader() {
        super(new URL[0], (ClassLoader)null);
    }

    public IsolatedClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
    }

    public IsolatedClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    public ClassLoader getClassLoader() {
        return this;
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            try {
                c = this.preFind(name);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            if (c == null) {
                try {
                    c = this.findClass(name);
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
                if (c == null) {
                    c = this.postFind(name);
                }
            }
        }
        if (c == null) {
            throw new ClassNotFoundException(name);
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    protected Class<?> loadFromParent(String name) throws ClassNotFoundException {
        if (this.getParent() != null) {
            return this.getParent().loadClass(name);
        }
        return null;
    }

    protected Class<?> preFind(String name) throws ClassNotFoundException {
        if (this.delegateLookup(name)) {
            return this.loadFromParent(name);
        }
        return null;
    }

    protected Class<?> postFind(String name) throws ClassNotFoundException {
        return this.loadFromParent(name);
    }

    @Override
    public URL getResource(String name) {
        URL url;
        if (this.delegateLookup(name)) {
            url = super.getResource(name);
            if (url == null) {
                url = this.findResource(name);
            }
        } else {
            url = this.findResource(name);
            if (url == null) {
                url = super.getResource(name);
            }
        }
        return url;
    }

    private final boolean delegateLookup(String name) {
        return name.startsWith("java.") || name.startsWith("javax.") || name.startsWith("org.w3c.") || name.startsWith("org.apache.log4j");
    }
}

