/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.datasource;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import javax.transaction.TransactionManager;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.dbcp.BasicDataSourceFactory;
import org.apache.commons.dbcp.managed.BasicManagedDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.datasource.BasicManagedDataSourceFactory;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class DataSourceFactory
implements ObjectFactory {
    private static final Log log = LogFactory.getLog(DataSourceFactory.class);
    private static final String URL_UPPER = "URL";
    private static final String URL_LOWER = "url";

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> env) throws Exception {
        DataSource ds;
        BasicManagedDataSourceFactory factory;
        TransactionManager transactionManager;
        Reference ref = (Reference)obj;
        if (!DataSource.class.getName().equals(ref.getClassName())) {
            return null;
        }
        try {
            transactionManager = TransactionHelper.lookupTransactionManager();
        }
        catch (NamingException e) {
            transactionManager = null;
        }
        boolean xa = ref.get("xaDataSource") != null;
        log.info((Object)String.format("Creating pooled %s datasource: %s/%s", xa ? "XA" : "non-XA", nameCtx.getNameInNamespace(), name));
        if (xa && transactionManager == null) {
            throw new RuntimeException("Cannot configure XA datasource " + name + " without an available transaction manager");
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        Enumeration<RefAddr> refAddrs = ref.getAll();
        while (refAddrs.hasMoreElements()) {
            RefAddr ra = refAddrs.nextElement();
            String key = ra.getType();
            String value = ra.getContent().toString();
            if (!key.startsWith("property.")) continue;
            key = key.substring("property.".length());
            properties.put(key, value);
        }
        if (!xa) {
            for (Map.Entry en : properties.entrySet()) {
                if (!URL_LOWER.equalsIgnoreCase((String)en.getKey())) continue;
                ref.add(new StringRefAddr(URL_LOWER, (String)en.getValue()));
            }
            factory = new BasicDataSourceFactory();
            ds = (DataSource)factory.getObjectInstance(ref, name, nameCtx, env);
            BasicDataSource bds = (BasicDataSource)ds;
            for (Map.Entry en : properties.entrySet()) {
                String key = (String)en.getKey();
                if (URL_LOWER.equalsIgnoreCase(key)) continue;
                bds.addConnectionProperty(key, (String)en.getValue());
            }
        } else {
            factory = new BasicManagedDataSourceFactory();
            ds = (DataSource)factory.getObjectInstance(obj, name, nameCtx, env);
            if (ds == null) {
                return null;
            }
            BasicManagedDataSource bmds = (BasicManagedDataSource)ds;
            bmds.setTransactionManager(transactionManager);
            XADataSource xaDataSource = bmds.getXaDataSourceInstance();
            if (xaDataSource == null) {
                return null;
            }
            for (Map.Entry en : properties.entrySet()) {
                boolean ok;
                String value;
                String key;
                block17: {
                    key = (String)en.getKey();
                    if (Character.isLowerCase(key.charAt(1))) {
                        key = Character.toLowerCase(key.charAt(0)) + key.substring(1);
                    }
                    value = (String)en.getValue();
                    ok = false;
                    try {
                        BeanUtils.setProperty((Object)xaDataSource, (String)key, (Object)value);
                        ok = true;
                    }
                    catch (Exception e) {
                        if (!URL_LOWER.equals(key)) break block17;
                        try {
                            BeanUtils.setProperty((Object)xaDataSource, (String)URL_UPPER, (Object)value);
                            ok = true;
                        }
                        catch (Exception ee) {
                            // empty catch block
                        }
                    }
                }
                if (ok) continue;
                log.error((Object)String.format("Cannot set %s = %s on %s", key, value, xaDataSource.getClass().getName()));
            }
        }
        return ds;
    }
}

