/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.datasource;

import java.util.HashMap;
import java.util.Map;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.datasource.DataSourceDescriptor;
import org.nuxeo.runtime.datasource.DataSourceHelper;
import org.nuxeo.runtime.datasource.DataSourceLinkDescriptor;
import org.nuxeo.runtime.datasource.DatasourceExceptionSorter;
import org.nuxeo.runtime.datasource.PooledDataSourceRegistry;
import org.nuxeo.runtime.jtajca.NuxeoContainer;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class DataSourceComponent
extends DefaultComponent {
    private final Log log = LogFactory.getLog(DataSourceComponent.class);
    static DataSourceComponent instance;
    public static final String DATASOURCES_XP = "datasources";
    public static final String ENV_CTX_NAME = "java:comp/env/";
    protected Map<String, DataSourceDescriptor> datasources = new HashMap<String, DataSourceDescriptor>();
    protected Map<String, DataSourceLinkDescriptor> links = new HashMap<String, DataSourceLinkDescriptor>();
    protected final DatasourceExceptionSorter.Registry sorterRegistry = new DatasourceExceptionSorter.Registry();
    protected final PooledDataSourceRegistry poolRegistry = new PooledDataSourceRegistry();
    protected Context namingContext;

    public void activate(ComponentContext context) {
        instance = this;
        this.datasources = new HashMap<String, DataSourceDescriptor>();
        this.links = new HashMap<String, DataSourceLinkDescriptor>();
    }

    public void deactivate(ComponentContext context) {
        super.deactivate(context);
        this.links = null;
        this.datasources = null;
        instance = null;
    }

    public void registerContribution(Object contrib, String extensionPoint, ComponentInstance component) {
        if (contrib instanceof DataSourceDescriptor) {
            this.addDataSource((DataSourceDescriptor)contrib);
        } else if (contrib instanceof DataSourceLinkDescriptor) {
            this.addDataSourceLink((DataSourceLinkDescriptor)contrib);
        } else if (contrib instanceof DatasourceExceptionSorter.Configuration) {
            this.sorterRegistry.addContribution((DatasourceExceptionSorter.Configuration)contrib);
        } else {
            this.log.error((Object)("Wrong datasource extension type " + contrib.getClass().getName()));
        }
    }

    public void unregisterContribution(Object contrib, String extensionPoint, ComponentInstance component) {
        if (contrib instanceof DataSourceDescriptor) {
            this.removeDataSource((DataSourceDescriptor)contrib);
        } else if (contrib instanceof DataSourceLinkDescriptor) {
            this.removeDataSourceLink((DataSourceLinkDescriptor)contrib);
        } else if (contrib instanceof DatasourceExceptionSorter.Configuration) {
            this.sorterRegistry.removeContribution((DatasourceExceptionSorter.Configuration)contrib);
        }
    }

    public int getApplicationStartedOrder() {
        return -1000;
    }

    public boolean isStarted() {
        return this.namingContext != null;
    }

    public void start(ComponentContext context) {
        CompositeName comp;
        if (this.namingContext != null) {
            return;
        }
        this.namingContext = NuxeoContainer.getRootContext();
        try {
            comp = new CompositeName(DataSourceHelper.getDataSourceJNDIPrefix());
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        Context ctx = this.namingContext;
        for (int i = 0; i < comp.size(); ++i) {
            try {
                ctx = (Context)ctx.lookup(comp.get(i));
                continue;
            }
            catch (NamingException e) {
                try {
                    ctx = ctx.createSubcontext(comp.get(i));
                    continue;
                }
                catch (NamingException e1) {
                    throw new RuntimeException(e1);
                }
            }
        }
        for (DataSourceDescriptor datasourceDesc : this.datasources.values()) {
            this.bindDataSource(datasourceDesc);
        }
        for (DataSourceLinkDescriptor linkDesc : this.links.values()) {
            this.bindDataSourceLink(linkDesc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(ComponentContext context) {
        try {
            for (DataSourceLinkDescriptor dataSourceLinkDescriptor : this.links.values()) {
                this.unbindDataSourceLink(dataSourceLinkDescriptor);
            }
            for (DataSourceDescriptor dataSourceDescriptor : this.datasources.values()) {
                this.unbindDataSource(dataSourceDescriptor);
            }
            this.namingContext = null;
        }
        finally {
            this.namingContext = null;
        }
    }

    protected void addDataSource(DataSourceDescriptor contrib) {
        this.datasources.put(contrib.getName(), contrib);
        this.bindDataSource(contrib);
    }

    protected void removeDataSource(DataSourceDescriptor contrib) {
        this.unbindDataSource(contrib);
        this.datasources.remove(contrib.getName());
    }

    protected void bindDataSource(DataSourceDescriptor descr) {
        if (this.namingContext == null) {
            return;
        }
        this.log.info((Object)("Registering datasource: " + descr.getName()));
        try {
            descr.bindSelf(this.namingContext);
        }
        catch (NamingException e) {
            this.log.error((Object)("Cannot bind datasource '" + descr.getName() + "' in JNDI"), (Throwable)e);
        }
    }

    protected void unbindDataSource(DataSourceDescriptor descr) {
        if (this.namingContext == null) {
            return;
        }
        this.log.info((Object)("Unregistering datasource: " + descr.name));
        try {
            descr.unbindSelf(this.namingContext);
        }
        catch (NamingException cause) {
            this.log.error((Object)("Cannot unbind datasource '" + descr.name + "' in JNDI"), (Throwable)cause);
        }
    }

    protected void addDataSourceLink(DataSourceLinkDescriptor contrib) {
        this.links.put(contrib.name, contrib);
        this.bindDataSourceLink(contrib);
    }

    protected void removeDataSourceLink(DataSourceLinkDescriptor contrib) {
        this.unbindDataSourceLink(contrib);
        this.links.remove(contrib.name);
    }

    protected void bindDataSourceLink(DataSourceLinkDescriptor descr) {
        if (this.namingContext == null) {
            return;
        }
        this.log.info((Object)("Registering DataSourceLink: " + descr.name));
        try {
            descr.bindSelf(this.namingContext);
        }
        catch (NamingException e) {
            this.log.error((Object)("Cannot bind DataSourceLink '" + descr.name + "' in JNDI"), (Throwable)e);
        }
    }

    protected void unbindDataSourceLink(DataSourceLinkDescriptor descr) {
        if (this.namingContext == null) {
            return;
        }
        this.log.info((Object)("Unregistering DataSourceLink: " + descr.name));
        try {
            descr.unbindSelf(this.namingContext);
        }
        catch (NamingException e) {
            this.log.error((Object)("Cannot unbind DataSourceLink '" + descr.name + "' in JNDI"), (Throwable)e);
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(PooledDataSourceRegistry.class)) {
            return adapter.cast(this.poolRegistry);
        }
        return (T)super.getAdapter(adapter);
    }
}

