/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.deployment.preprocessor;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.xmap.annotation.XContent;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.runtime.deployment.preprocessor.FragmentRegistry;
import org.nuxeo.runtime.deployment.preprocessor.TemplateDescriptor;
import org.nuxeo.runtime.deployment.preprocessor.install.CommandContext;
import org.nuxeo.runtime.deployment.preprocessor.install.CommandProcessor;
import org.nuxeo.runtime.deployment.preprocessor.install.DOMCommandsParser;
import org.w3c.dom.DocumentFragment;

@XObject(value="container")
public class ContainerDescriptor {
    private static final Log log = LogFactory.getLog(ContainerDescriptor.class);
    @XNode(value="@name")
    public String name;
    @XNodeMap(value="template", key="@name", type=HashMap.class, componentType=TemplateDescriptor.class)
    public Map<String, TemplateDescriptor> templates;
    @XNodeList(value="directory", type=ArrayList.class, componentType=String.class)
    public List<String> directories;
    public File directory;
    public final FragmentRegistry fragments = new FragmentRegistry();
    public final List<ContainerDescriptor> subContainers = new ArrayList<ContainerDescriptor>();
    public CommandProcessor install;
    public CommandProcessor uninstall;
    public CommandContext context;

    @XContent(value="install")
    public void setInstallCommands(DocumentFragment df) {
        try {
            this.install = DOMCommandsParser.parse(df);
        }
        catch (Exception e) {
            log.error((Object)"Failed to set install commands");
        }
    }

    @XContent(value="uninstall")
    public void setUninstallCommands(DocumentFragment df) {
        try {
            this.uninstall = DOMCommandsParser.parse(df);
        }
        catch (Exception e) {
            log.error((Object)"Failed to set uninstall commands");
        }
    }
}

