/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.deployment.preprocessor.install.commands;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.common.utils.Path;
import org.nuxeo.runtime.deployment.preprocessor.install.Command;
import org.nuxeo.runtime.deployment.preprocessor.install.CommandContext;

public class AppendCommand
implements Command {
    protected final Path src;
    protected final Path dst;
    protected final boolean addNewLine;

    public AppendCommand(Path src, Path dst, boolean addNewLine) {
        this.src = src;
        this.dst = dst;
        this.addNewLine = addNewLine;
    }

    public AppendCommand(Path src, Path dst) {
        this(src, dst, true);
    }

    public void exec(CommandContext ctx) throws IOException {
        File baseDir = ctx.getBaseDir();
        File srcFile = new File(baseDir, ctx.expandVars(this.src.toString()));
        File dstFile = new File(baseDir, ctx.expandVars(this.dst.toString()));
        if (!srcFile.exists()) {
            throw new FileNotFoundException("Could not find the file " + srcFile.getAbsolutePath() + " to append.");
        }
        if (!dstFile.isFile()) {
            dstFile.createNewFile();
        }
        FileUtils.append((File)srcFile, (File)dstFile, (boolean)this.addNewLine);
    }

    public String toString() {
        return "append " + this.src.toString() + " > " + this.dst.toString();
    }

    public String toString(CommandContext ctx) {
        return "append " + ctx.expandVars(this.src.toString()) + " > " + ctx.expandVars(this.dst.toString());
    }
}

