/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.deployment.preprocessor.install.commands;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.nuxeo.common.utils.Path;
import org.nuxeo.common.utils.PathFilter;
import org.nuxeo.common.utils.ZipUtils;
import org.nuxeo.runtime.deployment.preprocessor.install.Command;
import org.nuxeo.runtime.deployment.preprocessor.install.CommandContext;

public class ZipCommand
implements Command {
    protected final Path src;
    protected final Path dst;
    protected final PathFilter filter;
    protected final String prefix;

    public ZipCommand(Path src, Path dst) {
        this(src, dst, null, null);
    }

    public ZipCommand(Path src, Path dst, String prefix) {
        this(src, dst, prefix, null);
    }

    public ZipCommand(Path src, Path dst, String prefix, PathFilter filter) {
        this.src = src;
        this.dst = dst;
        this.prefix = prefix;
        this.filter = filter;
    }

    public void exec(CommandContext ctx) throws IOException {
        File baseDir = ctx.getBaseDir();
        File srcFile = new File(baseDir, ctx.expandVars(this.src.toString()));
        File dstFile = new File(baseDir, ctx.expandVars(this.dst.toString()));
        if (!srcFile.exists()) {
            throw new FileNotFoundException("Could not find the file " + srcFile.getAbsolutePath() + " to zip.");
        }
        if (dstFile.isDirectory()) {
            throw new IllegalArgumentException("When ziping the destination file must be a file: " + dstFile.getAbsolutePath());
        }
        File parent = dstFile.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        if (srcFile.isDirectory()) {
            File[] files = srcFile.listFiles();
            if (this.filter != null) {
                ZipUtils.zip((File[])files, (File)dstFile, (String)this.prefix);
            } else {
                ZipUtils.zip((File[])files, (File)dstFile, (String)this.prefix);
            }
        } else if (this.filter != null) {
            ZipUtils.zip((File)srcFile, (File)dstFile, (String)this.prefix);
        } else {
            ZipUtils.zip((File)srcFile, (File)dstFile, (String)this.prefix);
        }
    }

    public String toString() {
        return "zip " + this.src.toString() + " > " + this.dst.toString();
    }

    public String toString(CommandContext ctx) {
        return "zip " + ctx.expandVars(this.src.toString()) + " > " + ctx.expandVars(this.dst.toString());
    }
}

