/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.deployment.preprocessor;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.deployment.preprocessor.ConfigurationException;
import org.nuxeo.runtime.deployment.preprocessor.JBossConfigurator;
import org.nuxeo.runtime.deployment.preprocessor.JettyConfigurator;
import org.nuxeo.runtime.deployment.preprocessor.ServerConfigurator;
import org.nuxeo.runtime.deployment.preprocessor.TomcatConfigurator;

public class ConfigurationGenerator {
    private static final Log log = LogFactory.getLog(ConfigurationGenerator.class);
    public static final String NUXEO_HOME = "nuxeo.home";
    public static final String NUXEO_CONF = "nuxeo.conf";
    protected static final String TEMPLATES = "templates";
    protected static final String NUXEO_DEFAULT_CONF = "nuxeo.defaults";
    @Deprecated
    public static final String PARAM_TEMPLATE_NAME = "nuxeo.template";
    public static final String PARAM_TEMPLATES_NAME = "nuxeo.templates";
    public static final String PARAM_TEMPLATE_DBNAME = "nuxeo.dbtemplate";
    public static final String PARAM_TEMPLATES_NODB = "nuxeo.nodbtemplates";
    public static final String PARAM_TEMPLATES_PARSING_EXTENSIONS = "nuxeo.templates.parsing.extensions";
    protected static final String PARAM_INCLUDED_TEMPLATES = "nuxeo.template.includes";
    protected static final String PARAM_FORCE_GENERATION = "nuxeo.force.generation";
    public static final String BOUNDARY_BEGIN = "### BEGIN - DO NOT EDIT BETWEEN BEGIN AND END ###";
    public static final String BOUNDARY_END = "### END - DO NOT EDIT BETWEEN BEGIN AND END ###";
    public static final List<String> DB_LIST = Arrays.asList("default", "postgresql", "oracle", "mysql", "mssql");
    private final File nuxeoHome;
    private final File nuxeoConf;
    private final List<File> includedTemplates = new ArrayList<File>();
    private File nuxeoDefaultConf;
    private boolean isJBoss;
    private boolean isJetty;
    private boolean isTomcat;
    private ServerConfigurator serverConfigurator;
    private boolean forceGeneration;
    private Properties defaultConfig;
    private Properties userConfig;
    private boolean configurable = false;
    private boolean onceGeneration = false;
    private String templates;
    private boolean setOnceToFalse = true;
    private boolean setFalseToOnce = false;

    public boolean isConfigurable() {
        return this.configurable;
    }

    public ConfigurationGenerator() {
        String nuxeoHomePath = System.getProperty(NUXEO_HOME);
        String nuxeoConfPath = System.getProperty(NUXEO_CONF);
        if (nuxeoHomePath != null && nuxeoConfPath != null) {
            this.nuxeoHome = new File(nuxeoHomePath);
            this.nuxeoConf = new File(nuxeoConfPath);
            this.nuxeoDefaultConf = new File(this.nuxeoHome, TEMPLATES + File.separator + NUXEO_DEFAULT_CONF);
        } else {
            this.nuxeoHome = new File(System.getProperty("user.dir")).getParentFile();
            this.nuxeoConf = new File(this.nuxeoHome, "bin" + File.separator + NUXEO_CONF);
        }
        log.info((Object)("Nuxeo configuration: " + this.nuxeoConf.getPath()));
        this.isJBoss = System.getProperty("jboss.home.dir") != null;
        this.isJetty = System.getProperty("jetty.home") != null;
        boolean bl = this.isTomcat = System.getProperty("tomcat.home") != null;
        if (!(this.isJBoss || this.isJetty || this.isTomcat)) {
            String[] files;
            this.isJBoss = new File(this.nuxeoHome, "bin/run.jar").exists();
            this.isTomcat = new File(this.nuxeoHome, "bin/bootstrap.jar").exists();
            for (String file : files = this.nuxeoHome.list()) {
                if (!file.startsWith("nuxeo-runtime-launcher")) continue;
                this.isJetty = true;
                break;
            }
        }
        if (this.isJBoss) {
            this.serverConfigurator = new JBossConfigurator(this);
        } else if (this.isTomcat) {
            this.serverConfigurator = new TomcatConfigurator(this);
        } else if (this.isJetty) {
            this.serverConfigurator = new JettyConfigurator(this);
        }
    }

    public void setForceGeneration(boolean forceGeneration) {
        this.forceGeneration = forceGeneration;
    }

    public Properties getUserConfig() {
        return this.userConfig;
    }

    public void run() throws ConfigurationException {
        if (this.init()) {
            if (!this.serverConfigurator.isConfigured()) {
                log.info((Object)"No current configuration, generating files...");
                this.generateFiles();
            } else if (this.forceGeneration) {
                log.info((Object)("Configuration files generation (nuxeo.force.generation=" + this.userConfig.getProperty(PARAM_FORCE_GENERATION, "false") + ")..."));
                this.generateFiles();
            } else {
                log.info((Object)"Server already configured (set nuxeo.force.generation=true to force configuration files generation).");
            }
        }
    }

    public boolean init() {
        if (this.serverConfigurator == null) {
            log.warn((Object)"Unrecognized server. Considered as already configured.");
            this.configurable = false;
        } else if (!this.nuxeoConf.exists()) {
            log.info((Object)("Missing " + this.nuxeoConf));
            this.configurable = false;
        } else if (this.userConfig == null) {
            try {
                this.setBasicConfiguration();
                this.configurable = true;
            }
            catch (ConfigurationException e) {
                log.warn((Object)"Error reading basic configuration.", (Throwable)e);
                this.configurable = false;
            }
        } else {
            this.configurable = true;
        }
        return this.configurable;
    }

    public void changeTemplates(String newTemplates) {
        try {
            this.includedTemplates.clear();
            this.templates = newTemplates;
            this.setBasicConfiguration();
            this.configurable = true;
        }
        catch (ConfigurationException e) {
            log.warn((Object)"Error reading basic configuration.", (Throwable)e);
            this.configurable = false;
        }
    }

    private void setBasicConfiguration() throws ConfigurationException {
        try {
            this.defaultConfig = new Properties();
            this.defaultConfig.load(new FileInputStream(this.nuxeoDefaultConf));
            this.userConfig = new Properties(this.defaultConfig);
            this.userConfig.putAll((Map<?, ?>)System.getProperties());
            this.userConfig.load(new FileInputStream(this.nuxeoConf));
            this.onceGeneration = "once".equals(this.userConfig.getProperty(PARAM_FORCE_GENERATION));
            this.forceGeneration = this.onceGeneration || Boolean.parseBoolean(this.userConfig.getProperty(PARAM_FORCE_GENERATION, "false"));
            this.userConfig.put("nuxeo.data.dir", System.getProperty("nuxeo.data.dir"));
            this.userConfig.put("nuxeo.log.dir", System.getProperty("nuxeo.log.dir"));
        }
        catch (NullPointerException e) {
            throw new ConfigurationException("Missing file", e);
        }
        catch (FileNotFoundException e) {
            throw new ConfigurationException("Missing file: " + this.nuxeoDefaultConf + " or " + this.nuxeoConf, e);
        }
        catch (IOException e) {
            throw new ConfigurationException("Error reading " + this.nuxeoConf, e);
        }
        try {
            if (this.templates == null) {
                this.templates = this.getUserTemplates();
            }
            this.extractDatabaseTemplateName();
            this.includeTemplates(this.templates);
            log.debug((Object)("Loaded configuration: " + this.userConfig));
        }
        catch (FileNotFoundException e) {
            throw new ConfigurationException("Missing file", e);
        }
        catch (IOException e) {
            throw new ConfigurationException("Error reading " + this.nuxeoConf, e);
        }
    }

    private String getUserTemplates() {
        String userTemplatesList = this.userConfig.getProperty(PARAM_TEMPLATES_NAME);
        if (userTemplatesList == null) {
            userTemplatesList = this.userConfig.getProperty(PARAM_TEMPLATE_NAME);
        }
        return userTemplatesList;
    }

    protected void generateFiles() throws ConfigurationException {
        try {
            this.serverConfigurator.parseAndCopy(this.userConfig);
            log.info((Object)"Configuration files generated.");
            if (this.onceGeneration) {
                this.setOnceToFalse = true;
                this.writeConfiguration(this.loadConfiguration());
            }
        }
        catch (FileNotFoundException e) {
            throw new ConfigurationException("Missing file", e);
        }
        catch (IOException e) {
            throw new ConfigurationException("Configuration failure", e);
        }
    }

    private void writeConfiguration(StringBuffer configuration) throws ConfigurationException {
        this.writeConfiguration(configuration, null);
    }

    private void includeTemplates(String templatesList) throws IOException {
        StringTokenizer st = new StringTokenizer(templatesList, ",");
        while (st.hasMoreTokens()) {
            String nextToken = st.nextToken();
            File chosenTemplate = new File(nextToken);
            if (!chosenTemplate.exists() || !chosenTemplate.getPath().equals(chosenTemplate.getAbsolutePath())) {
                chosenTemplate = new File(this.nuxeoDefaultConf.getParentFile(), nextToken);
            }
            if (this.includedTemplates.contains(chosenTemplate)) {
                log.debug((Object)("Already included " + nextToken));
                continue;
            }
            if (chosenTemplate.exists()) {
                File chosenTemplateConf = new File(chosenTemplate, NUXEO_DEFAULT_CONF);
                if (chosenTemplateConf.exists()) {
                    Properties subTemplateConf = new Properties();
                    subTemplateConf.load(new FileInputStream(chosenTemplateConf));
                    String subTemplatesList = subTemplateConf.getProperty(PARAM_INCLUDED_TEMPLATES);
                    if (subTemplatesList != null && subTemplatesList.length() > 0) {
                        this.includeTemplates(subTemplatesList);
                    }
                    this.defaultConfig.load(new FileInputStream(chosenTemplateConf));
                    log.info((Object)("Include template: " + chosenTemplate.getPath()));
                } else {
                    log.debug((Object)("No default configuration for template " + nextToken));
                }
                this.includedTemplates.add(chosenTemplate);
                continue;
            }
            log.error((Object)String.format("Template '%s' not found with relative or absolute path (%s). Check your %s parameter, and %s for included files.", nextToken, chosenTemplate, PARAM_TEMPLATES_NAME, PARAM_INCLUDED_TEMPLATES));
        }
    }

    public File getNuxeoHome() {
        return this.nuxeoHome;
    }

    public File getNuxeoDefaultConf() {
        return this.nuxeoDefaultConf;
    }

    public List<File> getIncludedTemplates() {
        return this.includedTemplates;
    }

    public static void main(String[] args) throws ConfigurationException {
        new ConfigurationGenerator().run();
    }

    public void saveConfiguration(Map<String, String> changedParameters) throws ConfigurationException {
        this.setOnceToFalse = false;
        this.setFalseToOnce = true;
        this.writeConfiguration(this.loadConfiguration(), changedParameters);
    }

    private void writeConfiguration(StringBuffer newContent, Map<String, String> changedParameters) throws ConfigurationException {
        FileWriter writer = null;
        try {
            writer = new FileWriter(this.nuxeoConf, false);
            writer.append(newContent.toString());
            if (changedParameters != null && !changedParameters.isEmpty()) {
                writer.write("### BEGIN - DO NOT EDIT BETWEEN BEGIN AND END ### " + new Date().toString() + System.getProperty("line.separator"));
                for (String key : changedParameters.keySet()) {
                    writer.write("#" + key + "=" + this.userConfig.getProperty(key) + System.getProperty("line.separator"));
                    writer.write(key + "=" + changedParameters.get(key) + System.getProperty("line.separator"));
                }
                writer.write(BOUNDARY_END + System.getProperty("line.separator"));
            }
        }
        catch (IOException e) {
            throw new ConfigurationException("Error writing in " + this.nuxeoConf, e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    throw new ConfigurationException(e);
                }
            }
        }
    }

    private StringBuffer loadConfiguration() throws ConfigurationException {
        StringBuffer newContent = new StringBuffer();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(this.nuxeoConf));
            boolean onConfiguratorContent = false;
            while ((line = reader.readLine()) != null) {
                if (!onConfiguratorContent) {
                    if (!line.startsWith(BOUNDARY_BEGIN)) {
                        if (line.startsWith(PARAM_FORCE_GENERATION)) {
                            if (this.setOnceToFalse && this.onceGeneration) {
                                line = "nuxeo.force.generation=false";
                            }
                            if (this.setFalseToOnce && !this.forceGeneration) {
                                line = "nuxeo.force.generation=once";
                            }
                        }
                        newContent.append(line + System.getProperty("line.separator"));
                        continue;
                    }
                    onConfiguratorContent = true;
                    continue;
                }
                if (!line.startsWith(BOUNDARY_END)) continue;
                onConfiguratorContent = false;
            }
            reader.close();
        }
        catch (IOException e) {
            throw new ConfigurationException("Error reading " + this.nuxeoConf, e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    throw new ConfigurationException(e);
                }
            }
        }
        return newContent;
    }

    public String extractDatabaseTemplateName() {
        String dbTemplate = "unknown";
        String nodbTemplates = "";
        StringTokenizer st = new StringTokenizer(this.templates, ",");
        while (st.hasMoreTokens()) {
            String template = st.nextToken();
            if (DB_LIST.contains(template)) {
                dbTemplate = template;
                continue;
            }
            nodbTemplates = nodbTemplates + template;
        }
        this.userConfig.put(PARAM_TEMPLATES_NODB, nodbTemplates);
        this.userConfig.put(PARAM_TEMPLATE_DBNAME, dbTemplate);
        return dbTemplate;
    }
}

