/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.deployment.preprocessor.install.commands;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.nuxeo.common.utils.Path;
import org.nuxeo.common.utils.PathFilter;
import org.nuxeo.common.utils.ZipUtils;
import org.nuxeo.runtime.deployment.preprocessor.install.Command;
import org.nuxeo.runtime.deployment.preprocessor.install.CommandContext;
import org.nuxeo.runtime.deployment.preprocessor.install.commands.CopyCommand;

public class UnzipCommand
implements Command {
    protected final Path src;
    protected final Path dst;
    protected final PathFilter filter;
    protected final String prefix;

    public UnzipCommand(Path src, Path dst) {
        this(src, dst, null, null);
    }

    public UnzipCommand(Path src, Path dst, PathFilter filter) {
        this(src, dst, filter, null);
    }

    public UnzipCommand(Path src, Path dst, String prefix) {
        this(src, dst, null, prefix);
    }

    public UnzipCommand(Path src, Path dst, PathFilter filter, String prefix) {
        this.src = src;
        this.dst = dst;
        this.filter = filter;
        this.prefix = prefix;
    }

    @Override
    public void exec(CommandContext ctx) throws IOException {
        File baseDir = ctx.getBaseDir();
        File srcFile = new File(baseDir, ctx.expandVars(this.src.toString()));
        File dstFile = new File(baseDir, ctx.expandVars(this.dst.toString()));
        if (!srcFile.exists()) {
            throw new FileNotFoundException("Could not find the file " + srcFile.getAbsolutePath() + " to unzip.");
        }
        if (srcFile.isDirectory()) {
            new CopyCommand(this.src.addTrailingSeparator(), this.dst.addTrailingSeparator(), this.filter).exec(ctx);
            return;
        }
        if (dstFile.isFile()) {
            throw new IllegalArgumentException("When unziping the destination file must be a directory: " + dstFile.getAbsolutePath());
        }
        if (!dstFile.exists()) {
            dstFile.mkdirs();
        }
        if (this.filter != null) {
            if (this.prefix != null) {
                ZipUtils.unzip((String)this.prefix, (File)srcFile, (File)dstFile, (PathFilter)this.filter);
            } else {
                ZipUtils.unzip((File)srcFile, (File)dstFile, (PathFilter)this.filter);
            }
        } else if (this.prefix != null) {
            ZipUtils.unzip((String)this.prefix, (File)srcFile, (File)dstFile);
        } else {
            ZipUtils.unzip((File)srcFile, (File)dstFile);
        }
    }

    public String toString() {
        return "unzip " + this.src.toString() + " > " + this.dst.toString();
    }

    @Override
    public String toString(CommandContext ctx) {
        return "unzip " + ctx.expandVars(this.src.toString()) + " > " + ctx.expandVars(this.dst.toString());
    }
}

