/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.deployment.preprocessor.install;

import java.io.IOException;
import java.util.List;
import org.nuxeo.common.utils.Path;
import org.nuxeo.common.utils.PathFilter;
import org.nuxeo.common.utils.PathFilterSet;
import org.nuxeo.common.xmap.DOMSerializer;
import org.nuxeo.runtime.deployment.preprocessor.install.Command;
import org.nuxeo.runtime.deployment.preprocessor.install.CommandProcessor;
import org.nuxeo.runtime.deployment.preprocessor.install.CommandProcessorImpl;
import org.nuxeo.runtime.deployment.preprocessor.install.commands.AppendCommand;
import org.nuxeo.runtime.deployment.preprocessor.install.commands.CopyCommand;
import org.nuxeo.runtime.deployment.preprocessor.install.commands.DeleteCommand;
import org.nuxeo.runtime.deployment.preprocessor.install.commands.MkdirCommand;
import org.nuxeo.runtime.deployment.preprocessor.install.commands.MkfileCommand;
import org.nuxeo.runtime.deployment.preprocessor.install.commands.MoveCommand;
import org.nuxeo.runtime.deployment.preprocessor.install.commands.PropertyCommand;
import org.nuxeo.runtime.deployment.preprocessor.install.commands.SeamHotDeployCommand;
import org.nuxeo.runtime.deployment.preprocessor.install.commands.UnzipCommand;
import org.nuxeo.runtime.deployment.preprocessor.install.commands.ZipCommand;
import org.nuxeo.runtime.deployment.preprocessor.install.filters.ExcludeFilter;
import org.nuxeo.runtime.deployment.preprocessor.install.filters.IncludeFilter;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class DOMCommandsParser {
    private DOMCommandsParser() {
    }

    public static CommandProcessor parse(Node element) throws IOException {
        CommandProcessorImpl cmdp = new CommandProcessorImpl();
        List<Command> cmds = cmdp.getCommands();
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            String name = node.getNodeName();
            if (name.equals("copy")) {
                cmds.add(DOMCommandsParser.parseCopy((Element)node));
                continue;
            }
            if (name.equals("unzip")) {
                cmds.add(DOMCommandsParser.parseUnzip((Element)node));
                continue;
            }
            if (name.equals("mkdir")) {
                cmds.add(DOMCommandsParser.parseMkdir((Element)node));
                continue;
            }
            if (name.equals("delete")) {
                cmds.add(DOMCommandsParser.parseDelete((Element)node));
                continue;
            }
            if (name.equals("mkfile")) {
                cmds.add(DOMCommandsParser.parseMkfile((Element)node));
                continue;
            }
            if (name.equals("append")) {
                cmds.add(DOMCommandsParser.parseAppend((Element)node));
                continue;
            }
            if (name.equals("zip")) {
                cmds.add(DOMCommandsParser.parseZip((Element)node));
                continue;
            }
            if (name.equals("property")) {
                cmds.add(DOMCommandsParser.parseProperty((Element)node));
                continue;
            }
            if (!name.equals("seamHotDeploy")) continue;
            cmds.add(DOMCommandsParser.parseSeamHotDeploy((Element)node));
        }
        return cmdp;
    }

    public static PropertyCommand parseProperty(Element element) {
        String name = element.getAttribute("name");
        String value = element.getAttribute("value");
        if (value == null || value.length() == 0) {
            value = element.getTextContent();
        }
        return new PropertyCommand(name, value);
    }

    public static CopyCommand parseCopy(Element element) {
        String from = element.getAttribute("from");
        String to = element.getAttribute("to");
        PathFilterSet filter = DOMCommandsParser.readPathFilter(element);
        return new CopyCommand(new Path(from), new Path(to), (PathFilter)filter);
    }

    public static MoveCommand parseMove(Element element) {
        String from = element.getAttribute("from");
        String to = element.getAttribute("to");
        PathFilterSet filter = DOMCommandsParser.readPathFilter(element);
        return new MoveCommand(new Path(from), new Path(to), (PathFilter)filter);
    }

    public static AppendCommand parseAppend(Element element) {
        String from = element.getAttribute("from");
        String to = element.getAttribute("to");
        boolean addNewLine = false;
        String addNewLineStr = element.getAttribute("addNewLine");
        if (addNewLineStr.length() > 0) {
            addNewLine = Boolean.parseBoolean(addNewLineStr);
        }
        return new AppendCommand(new Path(from), new Path(to), addNewLine);
    }

    public static UnzipCommand parseUnzip(Element element) {
        String from = element.getAttribute("from");
        String to = element.getAttribute("to");
        String prefix = element.getAttribute("prefix");
        if (prefix != null && prefix.trim().length() == 0) {
            prefix = null;
        }
        PathFilterSet filter = DOMCommandsParser.readPathFilter(element);
        return new UnzipCommand(new Path(from), new Path(to), (PathFilter)filter, prefix);
    }

    public static ZipCommand parseZip(Element element) {
        String from = element.getAttribute("from");
        String to = element.getAttribute("to");
        String prefix = element.getAttribute("prefix");
        PathFilterSet filter = DOMCommandsParser.readPathFilter(element);
        return new ZipCommand(new Path(from), new Path(to), prefix, (PathFilter)filter);
    }

    public static MkdirCommand parseMkdir(Element element) {
        String path = element.getAttribute("path");
        return new MkdirCommand(new Path(path));
    }

    public static DeleteCommand parseDelete(Element element) {
        String path = element.getAttribute("path");
        return new DeleteCommand(new Path(path));
    }

    public static MkfileCommand parseMkfile(Element element) throws IOException {
        String path = element.getAttribute("path");
        DocumentFragment df = DOMSerializer.getContentAsFragment((Element)element);
        if (df != null) {
            String content = DOMSerializer.toString((DocumentFragment)df);
            return new MkfileCommand(new Path(path), content.getBytes());
        }
        return new MkfileCommand(new Path(path), null);
    }

    public static SeamHotDeployCommand parseSeamHotDeploy(Element element) throws IOException {
        PathFilterSet filter = DOMCommandsParser.readPathFilter(element);
        return new SeamHotDeployCommand(filter);
    }

    public static PathFilterSet readPathFilter(Element element) {
        PathFilterSet filters = new PathFilterSet();
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            String value;
            if (node.getNodeType() != 1) continue;
            String nodeName = node.getNodeName();
            if (nodeName.equals("include")) {
                value = node.getTextContent();
                if (value == null) continue;
                filters.add((Object)new IncludeFilter(new Path(value.trim())));
                continue;
            }
            if (!nodeName.equals("exclude") || (value = node.getTextContent()) == null) continue;
            filters.add((Object)new ExcludeFilter(new Path(value.trim())));
        }
        return filters.isEmpty() ? null : filters;
    }
}

