/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.deployment.preprocessor.template;

import org.nuxeo.common.xmap.Resource;
import org.nuxeo.common.xmap.annotation.XContent;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;

@XObject
public class TemplateContribution {
    @XNode(value="@src")
    private Resource src;
    private String template;
    private String marker;
    @XContent
    private String content;
    @XNode(value="@mode")
    private String mode = "append";

    @XNode(value="@target")
    public void setTarget(String target) {
        int p = target.lastIndexOf(35);
        if (p > -1) {
            this.template = target.substring(0, p);
            this.marker = target.substring(p + 1);
        } else {
            this.template = target;
            this.marker = "END";
        }
    }

    public String getContent() {
        if (this.content == null) {
            if (this.src == null) {
                return "";
            }
            return this.src.toString();
        }
        return this.content;
    }

    public String getTemplate() {
        return this.template;
    }

    public String getMarker() {
        return this.marker;
    }

    public String getMode() {
        return this.mode;
    }

    public boolean isAppending() {
        return "append".equals(this.mode);
    }

    public boolean isPrepending() {
        return "prepend".equals(this.mode);
    }

    public boolean isReplacing() {
        return "replace".equals(this.mode);
    }
}

