/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.deployment.preprocessor;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.collections.DependencyTree;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.common.utils.JarUtils;
import org.nuxeo.common.utils.Path;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.common.xmap.XMap;
import org.nuxeo.launcher.config.ConfigurationGenerator;
import org.nuxeo.runtime.deployment.preprocessor.ContainerDescriptor;
import org.nuxeo.runtime.deployment.preprocessor.FragmentDescriptor;
import org.nuxeo.runtime.deployment.preprocessor.FragmentRegistry;
import org.nuxeo.runtime.deployment.preprocessor.TemplateDescriptor;
import org.nuxeo.runtime.deployment.preprocessor.install.CommandContext;
import org.nuxeo.runtime.deployment.preprocessor.install.CommandContextImpl;
import org.nuxeo.runtime.deployment.preprocessor.template.TemplateContribution;
import org.nuxeo.runtime.deployment.preprocessor.template.TemplateParser;

public class DeploymentPreprocessor {
    public static final String FRAGMENT_FILE = "OSGI-INF/deployment-fragment.xml";
    public static final String CONTAINER_FILE = "META-INF/nuxeo-preprocessor.xml";
    public static final String CONTAINER_FILE_COMPAT = "OSGI-INF/deployment-container.xml";
    private static final Pattern ARTIFACT_NAME_PATTERN = Pattern.compile("-[0-9]+");
    private static final Log log = LogFactory.getLog(DeploymentPreprocessor.class);
    private final File dir;
    private final XMap xmap;
    private ContainerDescriptor root;
    @Deprecated
    private final Map<String, String> jar2Id = new HashMap<String, String>();

    public DeploymentPreprocessor(File dir) {
        this.dir = dir;
        this.xmap = new XMap();
        this.xmap.register(ContainerDescriptor.class);
        this.xmap.register(FragmentDescriptor.class);
    }

    @Deprecated
    public String getJarId(String jarName) {
        return this.jar2Id.get(jarName);
    }

    public ContainerDescriptor getRootContainer() {
        return this.root;
    }

    public void init() throws Exception {
        this.root = this.getDefaultContainer(this.dir);
        if (this.root != null) {
            this.init(this.root);
        }
    }

    public void init(File metadata, File[] files) throws Exception {
        this.root = metadata == null ? this.getDefaultContainer(this.dir) : this.getContainer(this.dir, metadata);
        if (this.root != null) {
            this.root.files = files;
            this.init(this.root);
        }
    }

    protected void init(ContainerDescriptor cd) throws Exception {
        cd.context = new CommandContextImpl(cd.directory);
        this.initContextProperties(cd.context);
        if (cd.install != null) {
            cd.install.setLogger(log);
            log.info((Object)("Running custom installation for container: " + cd.name));
            cd.install.exec(cd.context);
        }
        if (cd.files != null) {
            this.init(cd, cd.files);
        } else if (cd.directories == null || cd.directories.isEmpty()) {
            this.init(cd, this.dir);
        } else {
            for (String dirPath : cd.directories) {
                this.init(cd, new File(this.dir, dirPath));
            }
        }
    }

    protected void initContextProperties(CommandContext ctx) {
        ConfigurationGenerator confGen = new ConfigurationGenerator();
        confGen.init();
        Properties props = confGen.getUserConfig();
        for (String key : props.stringPropertyNames()) {
            ctx.put(key, props.getProperty(key));
        }
    }

    protected void processFile(ContainerDescriptor cd, File file) throws Exception {
        String name;
        String fileName = file.getName();
        FragmentDescriptor fd = null;
        boolean isBundle = false;
        if (fileName.endsWith("-fragment.xml")) {
            fd = this.getXMLFragment(file);
        } else {
            if (fileName.endsWith("-fragments.xml")) {
                this.collectXMLFragments(cd, file);
                return;
            }
            if (fileName.endsWith(".jar") || fileName.endsWith(".war") || fileName.endsWith(".sar") || fileName.endsWith(".rar")) {
                isBundle = true;
                fd = file.isDirectory() ? this.getDirectoryFragment(file) : this.getJARFragment(file);
            }
        }
        if (fd != null) {
            fd.fileName = fileName;
            fd.filePath = DeploymentPreprocessor.getRelativeChildPath(cd.directory.getAbsolutePath(), file.getAbsolutePath());
            cd.fragments.add(fd);
            if (fd.templates != null) {
                for (TemplateDescriptor td : fd.templates.values()) {
                    td.baseDir = file;
                    cd.templates.put(td.name, td);
                }
            }
        } else if (isBundle && (name = this.getSymbolicName(file)) != null) {
            cd.fragments.add(new FragmentDescriptor(name, true));
        }
    }

    protected String getSymbolicName(File file) throws Exception {
        Attributes attrs;
        String id;
        Manifest mf = JarUtils.getManifest((File)file);
        if (mf != null && (id = (attrs = mf.getMainAttributes()).getValue("Bundle-SymbolicName")) != null) {
            int p = id.indexOf(59);
            if (p > -1) {
                id = id.substring(0, p);
            }
            return id;
        }
        return null;
    }

    protected String getJarArtifactName(String name) {
        Matcher m;
        if (name.endsWith(".jar")) {
            name = name.substring(0, name.length() - 4);
        }
        if ((m = ARTIFACT_NAME_PATTERN.matcher(name)).find()) {
            name = name.substring(0, m.start());
        }
        return name;
    }

    protected void init(ContainerDescriptor cd, File[] files) throws Exception {
        for (File file : files) {
            this.processFile(cd, file);
        }
    }

    protected void init(ContainerDescriptor cd, File dir) throws Exception {
        log.info((Object)("Scanning directory: " + dir.getName()));
        if (!dir.exists()) {
            log.warn((Object)("Directory doesn't exist: " + dir.getPath()));
            return;
        }
        Object[] files = dir.listFiles();
        Arrays.sort(files);
        this.init(cd, (File[])files);
    }

    public void predeploy() throws Exception {
        if (this.root != null) {
            DeploymentPreprocessor.predeploy(this.root);
        }
    }

    protected static String listFragmentDescriptor(FragmentDescriptor fd) {
        return fd.name + " (" + fd.fileName + ")";
    }

    protected static void printInfo(FragmentRegistry fragments) {
        boolean first;
        List<DependencyTree.Entry<String, FragmentDescriptor>> entries = fragments.getResolvedEntries();
        StringBuilder buf = new StringBuilder("Preprocessing order: ");
        for (DependencyTree.Entry<String, FragmentDescriptor> entry : entries) {
            FragmentDescriptor fd = (FragmentDescriptor)entry.get();
            if (fd == null || fd.isMarker()) continue;
            buf.append("\n\t");
            buf.append(DeploymentPreprocessor.listFragmentDescriptor((FragmentDescriptor)entry.get()));
        }
        log.info((Object)buf);
        StringBuilder errors = new StringBuilder();
        List<DependencyTree.Entry<String, FragmentDescriptor>> missing = fragments.getMissingRequirements();
        for (DependencyTree.Entry<String, FragmentDescriptor> entry : missing) {
            buf = new StringBuilder("Unknown bundle: ");
            buf.append((String)entry.getKey());
            buf.append(" required by: ");
            first = true;
            for (DependencyTree.Entry dep : entry.getDependsOnMe()) {
                if (!first) {
                    buf.append(", ");
                }
                first = false;
                buf.append(DeploymentPreprocessor.listFragmentDescriptor((FragmentDescriptor)dep.get()));
            }
            log.error((Object)buf);
            errors.append((CharSequence)buf);
            errors.append("\n");
        }
        for (DependencyTree.Entry<String, FragmentDescriptor> entry : fragments.getPendingEntries()) {
            if (!entry.isRegistered()) continue;
            buf = new StringBuilder("Bundle not preprocessed: ");
            buf.append(DeploymentPreprocessor.listFragmentDescriptor((FragmentDescriptor)entry.get()));
            buf.append(" waiting for: ");
            first = true;
            for (DependencyTree.Entry dep : entry.getWaitsFor()) {
                if (!first) {
                    buf.append(", ");
                }
                first = false;
                buf.append((String)dep.getKey());
            }
            log.error((Object)buf);
            errors.append((CharSequence)buf);
            errors.append("\n");
        }
        if (errors.length() != 0) {
            System.setProperty("org.nuxeo.runtime.deployment.errors", errors.toString());
        }
    }

    protected static void predeploy(ContainerDescriptor cd) throws Exception {
        List<DependencyTree.Entry<String, FragmentDescriptor>> entries = cd.fragments.getResolvedEntries();
        DeploymentPreprocessor.printInfo(cd.fragments);
        for (DependencyTree.Entry<String, FragmentDescriptor> entry : entries) {
            FragmentDescriptor fd = (FragmentDescriptor)entry.get();
            if (fd == null || fd.isMarker()) continue;
            cd.context.put("bundle.fileName", fd.filePath);
            cd.context.put("bundle.shortName", fd.fileName);
            cd.context.put("bundle", fd.name);
            if (fd.install != null) {
                fd.install.setLogger(log);
                log.info((Object)("Running custom installation for fragment: " + fd.name));
                fd.install.exec(cd.context);
            }
            if (fd.contributions == null) continue;
            for (TemplateContribution tc : fd.contributions) {
                TemplateDescriptor td = cd.templates.get(tc.getTemplate());
                if (td != null) {
                    if (td.baseDir == null) {
                        td.baseDir = cd.directory;
                    }
                    if (td.template == null) {
                        File file = new File(td.baseDir, td.src);
                        td.template = TemplateParser.parse(file);
                    }
                } else {
                    log.warn((Object)("No template '" + tc.getTemplate() + "' found for deployment fragment:  " + fd.name));
                    continue;
                }
                td.template.update(tc, cd.context);
            }
        }
        for (TemplateDescriptor td : cd.templates.values()) {
            File file;
            if (td.baseDir == null) {
                td.baseDir = cd.directory;
            }
            if (td.template == null && td.isRequired) {
                file = new File(td.baseDir, td.src);
                td.template = TemplateParser.parse(file);
            }
            if (td.template == null) continue;
            file = new File(td.baseDir, td.installPath);
            file.getParentFile().mkdirs();
            FileUtils.writeFile((File)file, (String)td.template.getText());
        }
        for (ContainerDescriptor subCd : cd.subContainers) {
            DeploymentPreprocessor.predeploy(subCd);
        }
    }

    protected FragmentDescriptor getXMLFragment(File file) throws Exception {
        FragmentDescriptor fd = (FragmentDescriptor)this.xmap.load(file.toURI().toURL());
        if (fd != null && fd.name == null) {
            fd.name = file.getName();
        }
        return fd;
    }

    protected void collectXMLFragments(ContainerDescriptor cd, File file) throws Exception {
        Object[] result;
        String fileName = file.getName();
        for (Object entry : result = this.xmap.loadAll(file.toURI().toURL())) {
            FragmentDescriptor fd = (FragmentDescriptor)entry;
            assert (fd != null);
            if (fd.name == null) {
                log.error((Object)("Invalid fragments file: " + file.getName() + ". Fragments declared in a -fragments.xml file must have names."));
                continue;
            }
            cd.fragments.add(fd);
            fd.fileName = fileName;
            fd.filePath = DeploymentPreprocessor.getRelativeChildPath(cd.directory.getAbsolutePath(), file.getAbsolutePath());
        }
    }

    protected void processBundleForCompat(FragmentDescriptor fd, File file) {
        log.warn((Object)("Entering compatibility mode - Please update the deployment-fragment.xml in " + file.getName() + " to use new dependency management"));
        Manifest mf = JarUtils.getManifest((File)file);
        if (mf == null) {
            throw new RuntimeException("Compat: Fragments without a name must reside in an OSGi bundle");
        }
        fd.name = file.getName();
        this.processManifest(fd, fd.name, mf);
    }

    protected FragmentDescriptor getDirectoryFragment(File directory) throws Exception {
        FragmentDescriptor fd = null;
        File file = new File(directory.getAbsolutePath() + '/' + FRAGMENT_FILE);
        if (!file.isFile()) {
            return null;
        }
        fd = (FragmentDescriptor)this.xmap.load(file.toURI().toURL());
        if (fd.name == null) {
            fd.name = this.getSymbolicName(directory);
        }
        if (fd.name == null) {
            fd.name = this.getJarArtifactName(directory.getName());
        }
        if (fd.version == 0) {
            this.processBundleForCompat(fd, directory);
        }
        return fd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FragmentDescriptor getJARFragment(File file) throws Exception {
        FragmentDescriptor fd;
        block9: {
            fd = null;
            try (JarFile jar = new JarFile(file);){
                ZipEntry ze = jar.getEntry(FRAGMENT_FILE);
                if (ze == null) break block9;
                try (BufferedInputStream in = new BufferedInputStream(jar.getInputStream(ze));){
                    fd = (FragmentDescriptor)this.xmap.load((InputStream)in);
                }
                if (fd.name == null) {
                    fd.name = this.getSymbolicName(file);
                }
                if (fd.name == null) {
                    fd.name = this.getJarArtifactName(file.getName());
                }
                if (fd.version == 0) {
                    this.processBundleForCompat(fd, file);
                }
            }
        }
        return fd;
    }

    protected void processManifest(FragmentDescriptor fd, String fileName, Manifest mf) {
        Attributes attrs = mf.getMainAttributes();
        String id = attrs.getValue("Bundle-SymbolicName");
        if (id != null) {
            String requiredBy;
            int p = id.indexOf(59);
            if (p > -1) {
                id = id.substring(0, p);
            }
            this.jar2Id.put(fileName, id);
            fd.name = id;
            if (fd.requires != null && !fd.requires.isEmpty()) {
                throw new RuntimeException("In compatibility mode you must not use <require> tags for OSGi bundles - use Require-Bundle manifest header instead. Bundle: " + fileName);
            }
            String requires = attrs.getValue("Nuxeo-Require");
            if (requires == null) {
                requires = attrs.getValue("Require-Bundle");
            }
            if (requires != null) {
                String[] ids = StringUtils.split((String)requires, (char)',', (boolean)true);
                fd.requires = new ArrayList<String>(ids.length);
                for (int i = 0; i < ids.length; ++i) {
                    String rid = ids[i];
                    p = rid.indexOf(59);
                    if (p > -1) {
                        ids[i] = rid.substring(0, p);
                    }
                    fd.requires.add(ids[i]);
                }
            }
            if ((requiredBy = attrs.getValue("Nuxeo-RequiredBy")) != null) {
                String[] ids = StringUtils.split((String)requiredBy, (char)',', (boolean)true);
                for (int i = 0; i < ids.length; ++i) {
                    String rid = ids[i];
                    p = rid.indexOf(59);
                    if (p <= -1) continue;
                    ids[i] = rid.substring(0, p);
                }
                fd.requiredBy = ids;
            }
        } else {
            this.jar2Id.put(fileName, fd.name);
        }
    }

    protected ContainerDescriptor getContainer(File home, File file) throws Exception {
        ContainerDescriptor cd = (ContainerDescriptor)this.xmap.load(file.toURI().toURL());
        if (cd != null) {
            cd.directory = home;
            if (cd.name == null) {
                cd.name = home.getName();
            }
        }
        return cd;
    }

    protected ContainerDescriptor getDefaultContainer(File directory) throws Exception {
        File file = new File(directory.getAbsolutePath() + '/' + CONTAINER_FILE);
        if (!file.isFile()) {
            file = new File(directory.getAbsolutePath() + '/' + CONTAINER_FILE_COMPAT);
        }
        ContainerDescriptor cd = null;
        if (file.isFile()) {
            cd = this.getContainer(directory, file);
        }
        return cd;
    }

    public static String getRelativeChildPath(String parent, String child) {
        Path childPath;
        Path parentPath;
        if (parent.indexOf(92) > -1) {
            parent = parent.replace('\\', '/');
        }
        if (child.indexOf(92) > -1) {
            child = child.replace('\\', '/');
        }
        if ((parentPath = new Path(parent)).isPrefixOf(childPath = new Path(child))) {
            return childPath.removeFirstSegments(parentPath.segmentCount()).makeRelative().toString();
        }
        return null;
    }

    public static void process(File home, File metadata, File[] files) throws Exception {
        DeploymentPreprocessor processor = new DeploymentPreprocessor(home);
        processor.init(metadata, files);
        processor.predeploy();
    }

    public static void main(String[] args) {
        File root = args.length > 0 ? new File(args[0]) : new File(".");
        System.out.println("Preprocessing: " + root);
        DeploymentPreprocessor processor = new DeploymentPreprocessor(root);
        try {
            processor.init();
            processor.predeploy();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.out.println("Done.");
    }
}

